/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.ItemHandlerProxyTrait;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveBlastFurnaceMachine;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PrimitiveBlastFurnaceHatch
extends MultiblockPartMachine {
    private final ItemHandlerProxyTrait inputInventory = new ItemHandlerProxyTrait((MetaMachine)this, IO.IN);
    private final ItemHandlerProxyTrait outputInventory = new ItemHandlerProxyTrait((MetaMachine)this, IO.OUT);
    @Nullable
    private TickableSubscription autoIOSubs;
    @Nullable
    private ISubscription outputInventorySubs;

    public PrimitiveBlastFurnaceHatch(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onUnload() {
        super.onUnload();
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
    }

    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof PrimitiveBlastFurnaceMachine) {
            PrimitiveBlastFurnaceMachine primitiveBlastFurnace = (PrimitiveBlastFurnaceMachine)controller;
            this.outputInventorySubs = primitiveBlastFurnace.exportItems.addChangedListener(this::updateAutoIOSubscription);
            this.inputInventory.setProxy((IItemHandlerModifiable)primitiveBlastFurnace.importItems);
            this.outputInventory.setProxy((IItemHandlerModifiable)primitiveBlastFurnace.exportItems);
        }
    }

    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
    }

    public boolean canShared() {
        return false;
    }

    public boolean replacePartModelWhenFormed() {
        return false;
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoIOSubscription();
    }

    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateAutoIOSubscription();
    }

    private void updateAutoIOSubscription() {
        if (!this.outputInventory.isEmpty() && this.blockEntityDirectionCache.hasAdjacentItemHandler(this.getLevel(), this.getPos(), this.getFrontFacing())) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO, 20);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    private void autoIO() {
        this.outputInventory.exportToNearby(new Direction[]{this.getFrontFacing()});
        this.updateAutoIOSubscription();
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }
}

