/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.common.machine.multiblock.part.OpticalDataHatchMachine;
import com.hepdd.gtmthings.api.capability.IGTMTJadeIF;
import com.hepdd.gtmthings.api.misc.CleanableReferenceSupplier;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class WirelessOpticalDataHatchMachine
extends OpticalDataHatchMachine
implements IDataStickInteractable,
IGTMTJadeIF {
    @Persisted
    private BlockPos transmitterPos;
    @Persisted
    private BlockPos receiverPos;
    private static final String KEY_TRANSMITTER = "wireless_data_transmitter";
    private static final String KEY_RECEIVER = "wireless_data_receiver";
    private final CleanableReferenceSupplier<MetaMachine> transmitterMachine = new CleanableReferenceSupplier(() -> MetaMachine.getMachine((BlockGetter)this.getLevel(), (BlockPos)this.transmitterPos), MetaMachine::isInValid);

    public WirelessOpticalDataHatchMachine(MetaMachineBlockEntity holder, boolean transmitter) {
        super(holder, transmitter);
    }

    @Nullable
    protected IDataAccessHatch getAccessHatch() {
        Level level = this.getLevel();
        if (level == null || this.transmitterPos == null) {
            return null;
        }
        Object object = this.transmitterMachine.get();
        if (object instanceof WirelessOpticalDataHatchMachine) {
            WirelessOpticalDataHatchMachine machine = (WirelessOpticalDataHatchMachine)((Object)object);
            return machine;
        }
        return null;
    }

    private static CompoundTag createPos(BlockPos pos) {
        CompoundTag posTag = new CompoundTag();
        posTag.m_128405_("x", pos.m_123341_());
        posTag.m_128405_("y", pos.m_123342_());
        posTag.m_128405_("z", pos.m_123343_());
        return posTag;
    }

    private static BlockPos getPos(CompoundTag tag) {
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    private void setTransmitterPos(BlockPos pos) {
        MetaMachine metaMachine;
        Level level;
        if (this.transmitterPos != null && (level = this.getLevel()) != null && (metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)this.transmitterPos)) instanceof WirelessOpticalDataHatchMachine) {
            WirelessOpticalDataHatchMachine machine = (WirelessOpticalDataHatchMachine)metaMachine;
            machine.receiverPos = null;
        }
        this.transmitterPos = pos;
    }

    private void setReceiverPos(BlockPos pos) {
        MetaMachine metaMachine;
        Level level;
        if (this.receiverPos != null && (level = this.getLevel()) != null && (metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)this.receiverPos)) instanceof WirelessOpticalDataHatchMachine) {
            WirelessOpticalDataHatchMachine machine = (WirelessOpticalDataHatchMachine)metaMachine;
            machine.transmitterPos = null;
        }
        this.receiverPos = pos;
    }

    public boolean isbinded() {
        return this.transmitterPos != null || this.receiverPos != null;
    }

    public String getBindPos() {
        if (this.isTransmitter() && this.receiverPos != null) {
            return this.receiverPos.m_123344_();
        }
        if (!this.isTransmitter() && this.transmitterPos != null) {
            return this.transmitterPos.m_123344_();
        }
        return "";
    }

    public InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        if (this.isRemote()) {
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = dataStick.m_41784_();
        BlockPos currentPos = this.getPos();
        if (this.isTransmitter()) {
            tag.m_128365_(KEY_TRANSMITTER, (Tag)WirelessOpticalDataHatchMachine.createPos(currentPos));
            player.m_213846_((Component)Component.m_237115_((String)"gtocore.machine.wireless_data_transmitter_hatch.to_bind"));
        } else {
            tag.m_128365_(KEY_RECEIVER, (Tag)WirelessOpticalDataHatchMachine.createPos(currentPos));
            player.m_213846_((Component)Component.m_237115_((String)"gtocore.machine.wireless_data_receiver_hatch.to_bind"));
        }
        dataStick.m_41714_((Component)Component.m_237110_((String)"gtceu.machine.me.import_part.data_stick.name", (Object[])new Object[]{Component.m_237115_((String)this.getDefinition().getDescriptionId())}));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        BlockPos otherPos;
        if (this.isRemote()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        CompoundTag tag = dataStick.m_41783_();
        if (tag == null) {
            return InteractionResult.PASS;
        }
        if (this.isTransmitter() && tag.m_128425_(KEY_RECEIVER, 10) ? this.bindWith(otherPos = WirelessOpticalDataHatchMachine.getPos(tag.m_128469_(KEY_RECEIVER)), player) : !this.isTransmitter() && tag.m_128425_(KEY_TRANSMITTER, 10) && this.bindWith(otherPos = WirelessOpticalDataHatchMachine.getPos(tag.m_128469_(KEY_TRANSMITTER)), player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean bindWith(BlockPos otherPos, Player player) {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        MetaMachine otherMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)otherPos);
        if (otherMachine instanceof WirelessOpticalDataHatchMachine) {
            WirelessOpticalDataHatchMachine otherWodh = (WirelessOpticalDataHatchMachine)otherMachine;
            if (this.isTransmitter() == otherWodh.isTransmitter()) {
                return false;
            }
            if (this.isTransmitter()) {
                this.setReceiverPos(otherPos);
                otherWodh.setTransmitterPos(this.getPos());
            } else {
                this.setTransmitterPos(otherPos);
                otherWodh.setReceiverPos(this.getPos());
            }
            player.m_213846_((Component)Component.m_237115_((String)"gtocore.machine.wireless_data_hatch.bind"));
            return true;
        }
        return false;
    }
}

