/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.ProcessingPatternItem;
import com.fast.fastcollection.OpenCacheHashSet;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IWailaDisplayProvider;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.ButtonConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyInvConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.FancyTankConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.trait.CircuitHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.LockableItemStackHandler;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.gui.configurators.MultiMachineModeFancyConfigurator;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.data.machines.GTAEMachines;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferProxyPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternPartMachineKt;
import com.gtocore.common.machine.trait.InternalSlotRecipeHandler;
import com.gtolib.api.ae2.MyPatternDetailsHelper;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.capability.ISync;
import com.gtolib.api.machine.trait.NotifiableNotConsumableFluidHandler;
import com.gtolib.api.machine.trait.NotifiableNotConsumableItemHandler;
import com.gtolib.api.network.SyncManagedFieldHolder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.utils.ExpandedR2LMap;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.RLUtils;
import com.hepdd.gtmthings.common.item.VirtualItemProviderBehavior;
import com.hepdd.gtmthings.data.CustomItems;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@DataGeneratorScanned
public abstract class MEPatternBufferPartMachine
extends MEPatternPartMachineKt<InternalSlot>
implements IDataStickInteractable,
IWailaDisplayProvider {
    private static final SyncManagedFieldHolder SYNC_MANAGED_FIELD_HOLDER = new SyncManagedFieldHolder(MEPatternBufferPartMachine.class, MEPatternPartMachineKt.getSYNC_MANAGED_FIELD_HOLDER());
    @RegisterLanguage(cn="\u914d\u65b9\u5df2\u7f13\u5b58", en="Recipe cached")
    private static final String CACHE = "gtocore.pattern_buffer.cache";
    @RegisterLanguage(cn="\u6837\u677f\u72ec\u7acb\u914d\u7f6e", en="Pattern independent configuration")
    private static final String INDEPENDENT = "gtocore.pattern_buffer.independent";
    @RegisterLanguage(cn="\u603b\u6210\u5171\u4eab\u914d\u7f6e", en="Buffer share configuration")
    private static final String SHARE = "gtocore.pattern_buffer.share";
    @Persisted
    @DescSynced
    private final ArrayList<GTRecipeType> recipeTypes = new ArrayList();
    @Persisted
    @DescSynced
    public GTRecipeType recipeType = GTORecipeTypes.HATCH_COMBINED;
    @DescSynced
    private final boolean[] caches;
    @Persisted
    public final NotifiableNotConsumableItemHandler shareInventory;
    @Persisted
    public final NotifiableNotConsumableFluidHandler shareTank;
    @Persisted
    public final NotifiableItemStackHandler circuitInventorySimulated;
    @Persisted
    private final Set<BlockPos> proxies = new OpenCacheHashSet();
    private final Set<MEPatternBufferProxyPartMachine> proxyMachines = new ReferenceOpenHashSet();
    public final InternalSlotRecipeHandler internalRecipeHandler;
    protected ISync.IntSyncedField configuratorField = ISync.createIntField((ISync)this).set(-1).setSenderListener((side, o, n) -> {}).setReceiverListener((side, o, n) -> {
        if (side.isServer()) {
            Objects.requireNonNull(Objects.requireNonNull(this.getLevel()).m_7654_()).m_6937_((Runnable)new TickTask(10, () -> this.freshWidgetGroup.serverFresh()));
        }
    });
    protected ConfiguratorPanel configuratorPanel;

    @Override
    public SyncManagedFieldHolder getSyncHolder() {
        return SYNC_MANAGED_FIELD_HOLDER;
    }

    MEPatternBufferPartMachine(MetaMachineBlockEntity holder, int maxPatternCount) {
        super(holder, maxPatternCount);
        this.caches = new boolean[maxPatternCount];
        this.shareInventory = this.createShareInventory();
        this.shareTank = new NotifiableNotConsumableFluidHandler((MetaMachine)this, 9, 64000);
        this.circuitInventorySimulated = CircuitHandler.create((MetaMachine)this);
        this.internalRecipeHandler = new InternalSlotRecipeHandler(this, (InternalSlot[])this.getInternalInventory());
    }

    NotifiableNotConsumableItemHandler createShareInventory() {
        NotifiableNotConsumableItemHandler h = new NotifiableNotConsumableItemHandler((MetaMachine)this, 9, IO.NONE);
        h.setFilter(stack -> !(stack.m_41720_() instanceof EncodedPatternItem));
        return h;
    }

    public InternalSlot[] createInternalSlotArray() {
        return new InternalSlot[this.getMaxPatternCount()];
    }

    @Override
    public boolean patternFilter(ItemStack stack) {
        StringTag stringTag;
        Recipe recipe;
        Object v = stack.m_41784_().f_128329_.get("recipe");
        if (v instanceof StringTag && (recipe = (Recipe)RecipeBuilder.RECIPE_MAP.get(RLUtils.parse((String)(stringTag = (StringTag)v).m_7916_()))) != null && (this.recipeType == GTORecipeTypes.HATCH_COMBINED ? !this.recipeTypes.isEmpty() && !RecipeType.available((GTRecipeType)recipe.recipeType, (GTRecipeType[])this.recipeTypes.toArray(new GTRecipeType[0])) : !RecipeType.available((GTRecipeType)recipe.recipeType, (GTRecipeType[])new GTRecipeType[]{this.recipeType}))) {
            return false;
        }
        return stack.m_41720_() instanceof ProcessingPatternItem;
    }

    @Override
    public InternalSlot createInternalSlot(int i) {
        return new InternalSlot(this, i);
    }

    @Override
    public List<RecipeHandlerList> getRecipeHandlers() {
        return this.internalRecipeHandler.getSlotHandlers();
    }

    void addProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.add(proxy.getPos());
        this.proxyMachines.add(proxy);
    }

    void removeProxy(MEPatternBufferProxyPartMachine proxy) {
        this.proxies.remove(proxy.getPos());
        this.proxyMachines.remove((Object)proxy);
    }

    private Set<MEPatternBufferProxyPartMachine> getProxies() {
        if (this.proxyMachines.size() != this.proxies.size() && this.getLevel() != null) {
            this.proxyMachines.clear();
            for (BlockPos pos : this.proxies) {
                MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)this.getLevel(), (BlockPos)pos);
                if (!(metaMachine instanceof MEPatternBufferProxyPartMachine)) continue;
                MEPatternBufferProxyPartMachine proxy = (MEPatternBufferProxyPartMachine)metaMachine;
                proxy.setBuffer(this.getPos());
            }
        }
        return this.proxyMachines;
    }

    private void refundAll(ClickData clickData) {
        if (!clickData.isRemote) {
            for (InternalSlot internalSlot : (InternalSlot[])this.getInternalInventory()) {
                internalSlot.refund();
            }
        }
    }

    private void changeMode(@Nullable GTRecipeType type) {
        this.recipeType = type == null ? GTORecipeTypes.HATCH_COMBINED : type;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.recipeType == GTORecipeTypes.DUMMY_RECIPES) {
            this.recipeType = GTORecipeTypes.HATCH_COMBINED;
        }
    }

    @Override
    public void attachSideTabs(TabsWidget sideTabs) {
        super.attachSideTabs(sideTabs);
        sideTabs.attachSubTab((IFancyUIProvider)new MultiMachineModeFancyConfigurator(this.recipeTypes, this.recipeType, this::changeMode));
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        this.recipeTypes.clear();
        this.recipeTypes.addAll(MultiMachineModeFancyConfigurator.extractRecipeTypes(this.getControllers()));
    }

    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        this.recipeTypes.clear();
        this.recipeTypes.addAll(MultiMachineModeFancyConfigurator.extractRecipeTypes(this.getControllers()));
    }

    @Override
    public void onPatternChange(int index) {
        ((InternalSlot[])this.getInternalInventory())[index].setLock(false);
        super.onPatternChange(index);
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        InternalSlot slot = (InternalSlot)this.getDetailsSlotMap().get((Object)patternDetails);
        if (slot != null) {
            return slot.pushPattern(patternDetails, inputHolder);
        }
        return false;
    }

    @Override
    @Nullable
    public IPatternDetails decodePattern(ItemStack stack, int index) {
        Object v;
        IPatternDetails pattern = super.decodePattern(stack, index);
        if (pattern == null) {
            return null;
        }
        if (!this.caches[index] && (v = stack.m_41784_().f_128329_.get("recipe")) instanceof StringTag) {
            StringTag stringTag = (StringTag)v;
            Recipe recipe = (Recipe)RecipeBuilder.RECIPE_MAP.get(RLUtils.parse((String)stringTag.m_7916_()));
            ((InternalSlot[])this.getInternalInventory())[index].setRecipe(recipe);
        }
        return pattern;
    }

    @Override
    public IPatternDetails convertPattern(IPatternDetails pattern, int index) {
        if (pattern instanceof AEProcessingPattern) {
            AEProcessingPattern processingPattern = (AEProcessingPattern)pattern;
            GenericStack[] sparseInput = processingPattern.getSparseInputs();
            ArrayList<GenericStack> input = new ArrayList<GenericStack>(sparseInput.length);
            int in = 0;
            InternalSlot slot = ((InternalSlot[])this.getInternalInventory())[index];
            boolean locked = false;
            for (GenericStack stack : sparseInput) {
                AEItemKey what;
                AEKey aEKey;
                if (stack != null && (aEKey = stack.what()) instanceof AEItemKey && (what = (AEItemKey)aEKey).getItem() == CustomItems.VIRTUAL_ITEM_PROVIDER.get() && what.getTag() != null && what.getTag().f_128329_.containsKey("n")) {
                    ItemStack virtualItem = VirtualItemProviderBehavior.getVirtualItem((ItemStack)what.getReadOnlyStack());
                    if (virtualItem.m_41619_()) continue;
                    if (!locked) {
                        slot.setLock(true);
                        locked = true;
                    }
                    if (GTItems.PROGRAMMED_CIRCUIT.isIn(virtualItem)) {
                        slot.circuitInventory.storage.setStackInSlot(0, virtualItem);
                        continue;
                    }
                    virtualItem.m_41764_(Math.clamp(stack.amount(), 1, virtualItem.m_41741_()));
                    IGrid grid = this.getGrid();
                    if (grid == null || grid.getStorageService().getInventory().extract((AEKey)what, 1L, Actionable.SIMULATE, this.getActionSource()) != 1L) continue;
                    CustomItemStackHandler storage = slot.shareInventory.storage;
                    ItemStack inSlot = storage.getStackInSlot(in);
                    if (!inSlot.m_41619_()) {
                        storage.setStackInSlot(in, ItemStack.f_41583_);
                        grid.getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)inSlot), (long)inSlot.m_41613_(), Actionable.MODULATE, this.getActionSource());
                    }
                    storage.setStackInSlot(in, virtualItem);
                    ++in;
                    continue;
                }
                input.add(stack);
            }
            if (input.size() < sparseInput.length) {
                if (input.isEmpty()) {
                    return pattern;
                }
                ItemStack stack = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])input.toArray(new GenericStack[0]), (GenericStack[])processingPattern.getSparseOutputs());
                return (IPatternDetails)MyPatternDetailsHelper.CACHE.getCache((Object)AEItemKey.of((ItemStack)stack));
            }
        }
        return pattern;
    }

    @Override
    @Nullable
    public Component appendHoverTooltips(int index) {
        if (this.caches[index]) {
            return Component.m_237115_((String)CACHE);
        }
        return null;
    }

    @Override
    public void onMouseClicked(int index) {
        if (!this.isRemote()) {
            return;
        }
        if (this.configuratorField.get() == index) {
            this.configuratorField.setAndSyncToServer(-1);
        } else {
            this.configuratorField.setAndSyncToServer(index);
        }
    }

    @Override
    public void addWidget(WidgetGroup group) {
        group.addWidget(new LabelWidget(81, 2, () -> this.configuratorField.get() < 0 ? SHARE : INDEPENDENT).setHoverTooltips(new Component[]{Component.m_237115_((String)"monitor.gui.title.slot").m_130946_(String.valueOf(this.configuratorField.get()))}));
    }

    @Override
    public PatternContainerGroup getTerminalGroup() {
        if (this.isFormed()) {
            MutableComponent groupName;
            String lid;
            IRecipeLogicMachine rlm;
            IMultiController controller = this.getController();
            MultiblockMachineDefinition controllerDefinition = controller.self().getDefinition();
            GTRecipeType rt = this.recipeType;
            MutableComponent lidComp = null;
            if (rt == null) {
                if (controller instanceof IRecipeLogicMachine) {
                    rlm = (IRecipeLogicMachine)controller;
                    v0 = rlm.getRecipeType();
                } else {
                    v0 = rt = null;
                }
            }
            if (rt == null || rt == GTORecipeTypes.HATCH_COMBINED) {
                Stream<GTRecipeType> stream;
                rt = null;
                if (controller instanceof IRecipeLogicMachine) {
                    rlm = (IRecipeLogicMachine)controller;
                    stream = Stream.of(rlm.getRecipeTypes());
                } else {
                    stream = Stream.empty();
                }
                lidComp = (MutableComponent)stream.map(r -> Component.m_237115_((String)("gtceu." + r.registryName.m_135815_()))).collect(GTOUtils.joiningComponent((Component)Component.m_237113_((String)"/")));
            }
            String string = lid = rt != null ? rt.registryName.m_214298_() : controllerDefinition.getDescriptionId();
            if (!this.getCustomName().isEmpty()) {
                return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)Component.m_237113_((String)this.getCustomName()), Collections.emptyList());
            }
            ItemStack circuitStack = this.circuitInventorySimulated.storage.getStackInSlot(0);
            int circuitConfiguration = circuitStack.m_41619_() ? -1 : IntCircuitBehaviour.getCircuitConfiguration((ItemStack)circuitStack);
            MutableComponent mutableComponent = groupName = lidComp != null ? lidComp : Component.m_237115_((String)lid);
            if (circuitConfiguration != -1) {
                groupName = groupName.m_130946_(" - " + circuitConfiguration);
            }
            return new PatternContainerGroup(AEItemKey.of((ItemStack)controllerDefinition.asStack()), (Component)groupName, lidComp != null ? List.of(Component.m_237115_((String)lid)) : Collections.emptyList());
        }
        if (!this.getCustomName().isEmpty()) {
            return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.asItem()), (Component)Component.m_237113_((String)this.getCustomName()), Collections.emptyList());
        }
        return new PatternContainerGroup(AEItemKey.of((ItemLike)GTAEMachines.ME_PATTERN_BUFFER.asItem()), GTAEMachines.ME_PATTERN_BUFFER.get().getDefinition().asItem().m_41466_(), Collections.emptyList());
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        this.configuratorPanel = configuratorPanel;
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new ButtonConfigurator((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.REFUND_OVERLAY}), this::refundAll).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.refund_all.desc")))});
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new CircuitFancyConfigurator(this.circuitInventorySimulated.storage)});
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new FancyInvConfigurator(this.shareInventory.storage, (Component)Component.m_237115_((String)"gui.gtceu.share_inventory.title")).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.share_inventory.desc.0"), Component.m_237115_((String)"gui.gtceu.share_inventory.desc.1")))});
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new FancyTankConfigurator(this.shareTank.getStorages(), (Component)Component.m_237115_((String)"gui.gtceu.share_tank.title")).setTooltips(List.of(Component.m_237115_((String)"gui.gtceu.share_tank.desc.0"), Component.m_237115_((String)"gui.gtceu.share_inventory.desc.1")))});
        super.attachConfigurators(configuratorPanel);
    }

    @Override
    public void saveToItem(CompoundTag tag) {
        super.saveToItem(tag);
        tag.m_128365_("si", (Tag)this.shareInventory.storage.serializeNBT());
        ListTag tanks = new ListTag();
        for (CustomFluidTank tank : this.shareTank.getStorages()) {
            tanks.add((Object)tank.serializeNBT());
        }
        tag.m_128365_("st", (Tag)tanks);
        tag.m_128365_("ci", (Tag)this.circuitInventorySimulated.storage.serializeNBT());
    }

    @Override
    public void loadFromItem(CompoundTag tag) {
        super.loadFromItem(tag);
        this.shareInventory.storage.deserializeNBT(tag.m_128469_("si"));
        ListTag tanks = tag.m_128437_("st", 10);
        for (int i = 0; i < tanks.size(); ++i) {
            this.shareTank.getStorages()[i].deserializeNBT(tanks.m_128728_(i));
        }
        this.circuitInventorySimulated.storage.deserializeNBT(tag.m_128469_("ci"));
    }

    public InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        dataStick.m_41784_().m_128385_("pos", new int[]{this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_()});
        return InteractionResult.SUCCESS;
    }

    public void appendWailaTooltip(CompoundTag data, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (!data.m_128471_("formed")) {
            return;
        }
        int proxies = data.m_128451_("proxies");
        if (proxies > 0) {
            iTooltip.add((Component)Component.m_237110_((String)"gtceu.top.proxies_bound", (Object[])new Object[]{data.m_128451_("proxies")}).m_130938_(TooltipHelper.RAINBOW_HSL_SLOW));
        }
        MEPatternBufferPartMachine.readBufferTag(iTooltip, data);
    }

    public void appendWailaData(CompoundTag data, BlockAccessor blockAccessor) {
        if (!this.isFormed()) {
            data.m_128379_("formed", false);
            return;
        }
        data.m_128379_("formed", true);
        int proxies = this.getProxies().size();
        if (proxies > 0) {
            data.m_128405_("proxies", proxies);
        }
        MEPatternBufferPartMachine.writeBufferTag(data, this);
    }

    static void writeBufferTag(CompoundTag data, MEPatternBufferPartMachine buffer) {
        ExpandedR2LMap items = new ExpandedR2LMap();
        ExpandedR2LMap fluids = new ExpandedR2LMap();
        for (InternalSlot slot : (InternalSlot[])buffer.getInternalInventory()) {
            slot.itemInventory.reference2LongEntrySet().fastForEach(e -> items.addTo((Object)((AEItemKey)e.getKey()), e.getLongValue()));
            slot.fluidInventory.reference2LongEntrySet().fastForEach(e -> fluids.addTo((Object)((AEFluidKey)e.getKey()), e.getLongValue()));
        }
        ListTag itemsTag = new ListTag();
        for (Reference2LongMap.Entry entry : items.reference2LongEntrySet()) {
            CompoundTag ct = ((AEItemKey)entry.getKey()).toTag();
            ct.m_128356_("real", entry.getLongValue());
            itemsTag.add((Object)ct);
        }
        if (!itemsTag.isEmpty()) {
            data.m_128365_("items", (Tag)itemsTag);
        }
        ListTag fluidsTag = new ListTag();
        for (Reference2LongMap.Entry entry : fluids.reference2LongEntrySet()) {
            CompoundTag ct = ((AEFluidKey)entry.getKey()).toTag();
            ct.m_128356_("real", entry.getLongValue());
            fluidsTag.add((Object)ct);
        }
        if (!fluidsTag.isEmpty()) {
            data.m_128365_("fluids", (Tag)fluidsTag);
        }
    }

    static void readBufferTag(ITooltip iTooltip, CompoundTag data) {
        IElementHelper helper = iTooltip.getElementHelper();
        ListTag itemsTag = data.m_128437_("items", 10);
        for (Tag t : itemsTag) {
            long amount;
            CompoundTag ct;
            AEItemKey stack;
            if (!(t instanceof CompoundTag) || (stack = AEItemKey.fromTag((CompoundTag)(ct = (CompoundTag)t))) == null || (amount = ct.m_128454_("real")) <= 0L) continue;
            iTooltip.add(helper.smallItem(stack.getReadOnlyStack()));
            MutableComponent text = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(amount)).m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)Component.m_237113_((String)"\u00d7 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)stack.getDisplayName().m_6881_().m_130940_(ChatFormatting.GOLD));
            iTooltip.append((Component)text);
        }
        ListTag fluidsTag = data.m_128437_("fluids", 10);
        for (Tag t : fluidsTag) {
            long amount;
            CompoundTag ct;
            AEFluidKey stack;
            if (!(t instanceof CompoundTag) || (stack = AEFluidKey.fromTag((CompoundTag)(ct = (CompoundTag)t))) == null || (amount = ct.m_128454_("real")) <= 0L) continue;
            iTooltip.add(GTElementHelper.smallFluid((JadeFluidObject)JadeFluidObject.of((Fluid)stack.getFluid())));
            MutableComponent text = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatBuckets((long)amount))).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)stack.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_AQUA));
            iTooltip.append((Component)text);
        }
    }

    @Generated
    public ArrayList<GTRecipeType> getRecipeTypes() {
        return this.recipeTypes;
    }

    @Generated
    public ISync.IntSyncedField getConfiguratorField() {
        return this.configuratorField;
    }

    public static final class InternalSlot
    extends MEPatternPartMachineKt.AbstractInternalSlot {
        public Recipe recipe;
        public final MEPatternBufferPartMachine machine;
        public final int index;
        private final InputSink inputSink;
        private Runnable onContentsChanged = () -> {};
        public boolean itemChanged = true;
        public boolean fluidChanged = true;
        public final IntLongMap itemIngredientMap = new IntLongMap();
        public final IntLongMap fluidIngredientMap = new IntLongMap();
        public final ExpandedR2LMap<AEItemKey> itemInventory = new ExpandedR2LMap();
        public final ExpandedR2LMap<AEFluidKey> fluidInventory = new ExpandedR2LMap();
        public final NotifiableNotConsumableItemHandler shareInventory;
        public final NotifiableNotConsumableFluidHandler shareTank;
        public final NotifiableItemStackHandler circuitInventory;
        final LockableItemStackHandler lockableInventory;
        private boolean lock;
        private boolean shouldLockRecipe = true;

        private InternalSlot(MEPatternBufferPartMachine machine, int index) {
            this.machine = machine;
            this.index = index;
            this.shareInventory = machine.createShareInventory();
            this.shareTank = new NotifiableNotConsumableFluidHandler((MetaMachine)machine, 9, 64000);
            this.circuitInventory = CircuitHandler.create((MetaMachine)machine);
            this.inputSink = new InputSink(this);
            this.lockableInventory = new LockableItemStackHandler((IItemHandlerModifiable)this.shareInventory.storage);
        }

        public void setLock(boolean lock) {
            if (this.lock) {
                this.circuitInventory.storage.setStackInSlot(0, ItemStack.f_41583_);
                for (int i = 0; i < 9; ++i) {
                    this.shareInventory.setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            this.lock = lock;
            this.lockableInventory.setLock(lock);
        }

        public void setRecipe(@Nullable Recipe recipe) {
            if (!this.shouldLockRecipe) {
                return;
            }
            this.recipe = recipe;
            this.machine.caches[this.index] = recipe != null;
        }

        public boolean isEmpty() {
            return this.itemInventory.isEmpty() && this.fluidInventory.isEmpty();
        }

        private void refund() {
            IGrid network = this.machine.getMainNode().getGrid();
            if (network != null) {
                long inserted;
                AEItemKey key;
                Reference2LongMap.Entry entry;
                MEStorage networkInv = network.getStorageService().getInventory();
                IEnergyService energy = network.getEnergyService();
                ObjectIterator it = this.itemInventory.reference2LongEntrySet().fastIterator();
                while (it.hasNext()) {
                    entry = (Reference2LongMap.Entry)it.next();
                    long count = entry.getLongValue();
                    if (count == 0L) {
                        it.remove();
                        continue;
                    }
                    key = (AEItemKey)entry.getKey();
                    if (key == null || (inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)key, (long)count, (IActionSource)this.machine.getActionSourceField())) <= 0L) continue;
                    if ((count -= inserted) == 0L) {
                        it.remove();
                        continue;
                    }
                    entry.setValue(count);
                }
                it = this.fluidInventory.reference2LongEntrySet().fastIterator();
                while (it.hasNext()) {
                    entry = (Reference2LongMap.Entry)it.next();
                    long amount = entry.getLongValue();
                    if (amount == 0L) {
                        it.remove();
                        continue;
                    }
                    key = (AEFluidKey)entry.getKey();
                    if (key == null || (inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkInv, (AEKey)key, (long)amount, (IActionSource)this.machine.getActionSourceField())) <= 0L) continue;
                    if ((amount -= inserted) == 0L) {
                        it.remove();
                        continue;
                    }
                    entry.setValue(amount);
                }
                this.itemChanged = true;
                this.fluidChanged = true;
                this.onContentsChanged.run();
            }
        }

        @Override
        public void onPatternChange() {
            this.setRecipe(null);
            this.refund();
        }

        @Override
        public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
            patternDetails.pushInputsToExternalInventory(inputHolder, (IPatternDetails.PatternInputSink)this.inputSink);
            this.itemChanged = true;
            this.fluidChanged = true;
            this.onContentsChanged.run();
            return true;
        }

        @Nullable
        public List<Ingredient> handleItemInternal(List<Ingredient> left, boolean simulate) {
            boolean changed = false;
            Iterator<Ingredient> it = left.iterator();
            block0: while (it.hasNext()) {
                long amount;
                Ingredient ingredient = it.next();
                if (ingredient.m_43947_()) {
                    it.remove();
                    continue;
                }
                if (ingredient instanceof FastSizedIngredient) {
                    FastSizedIngredient si = (FastSizedIngredient)ingredient;
                    amount = si.getAmount();
                } else {
                    amount = 1L;
                }
                ObjectIterator it2 = this.itemInventory.reference2LongEntrySet().fastIterator();
                while (it2.hasNext()) {
                    Reference2LongMap.Entry entry = (Reference2LongMap.Entry)it2.next();
                    if (!ingredient.test(((AEItemKey)entry.getKey()).getReadOnlyStack())) continue;
                    long count = entry.getLongValue();
                    long extracted = Math.min(count, amount);
                    if (!simulate && extracted > 0L) {
                        changed = true;
                        if ((count -= extracted) < 1L) {
                            it2.remove();
                        } else {
                            entry.setValue(count);
                        }
                    }
                    if ((amount -= extracted) >= 1L) continue;
                    it.remove();
                    continue block0;
                }
            }
            if (changed) {
                this.itemChanged = true;
                this.fluidChanged = true;
                this.onContentsChanged.run();
            }
            return left.isEmpty() ? null : left;
        }

        @Nullable
        public List<FluidIngredient> handleFluidInternal(List<FluidIngredient> left, boolean simulate) {
            boolean changed = false;
            Iterator<FluidIngredient> it = left.iterator();
            block0: while (it.hasNext()) {
                FluidIngredient ingredient = it.next();
                if (ingredient.isEmpty()) {
                    it.remove();
                    continue;
                }
                long amount = FastFluidIngredient.getAmount((FluidIngredient)ingredient);
                ObjectIterator it2 = this.fluidInventory.reference2LongEntrySet().fastIterator();
                while (it2.hasNext()) {
                    Reference2LongMap.Entry entry = (Reference2LongMap.Entry)it2.next();
                    if (!FastFluidIngredient.testAeKay((FluidIngredient)ingredient, (AEFluidKey)((AEFluidKey)entry.getKey()))) continue;
                    long count = entry.getLongValue();
                    long extracted = Math.min(count, amount);
                    if (!simulate && extracted > 0L) {
                        changed = true;
                        if ((count -= extracted) < 1L) {
                            it2.remove();
                        } else {
                            entry.setValue(count);
                        }
                    }
                    if ((amount -= extracted) >= 1L) continue;
                    it.remove();
                    continue block0;
                }
            }
            if (changed) {
                this.itemChanged = true;
                this.fluidChanged = true;
                this.onContentsChanged.run();
            }
            return left.isEmpty() ? null : left;
        }

        @Override
        public CompoundTag serializeNBT() {
            int c;
            CompoundTag tag = super.serializeNBT();
            if (this.recipe != null) {
                tag.m_128365_("recipe", (Tag)this.recipe.serializeNBT());
            }
            ListTag itemsTag = new ListTag();
            ObjectIterator it = this.itemInventory.reference2LongEntrySet().fastIterator();
            while (it.hasNext()) {
                Reference2LongMap.Entry entry = (Reference2LongMap.Entry)it.next();
                CompoundTag ct = ((AEItemKey)entry.getKey()).toTag();
                ct.m_128356_("real", entry.getLongValue());
                itemsTag.add((Object)ct);
            }
            if (!itemsTag.isEmpty()) {
                tag.m_128365_("inventory", (Tag)itemsTag);
            }
            ListTag fluidsTag = new ListTag();
            ObjectIterator it2 = this.fluidInventory.reference2LongEntrySet().fastIterator();
            while (it2.hasNext()) {
                Reference2LongMap.Entry entry = (Reference2LongMap.Entry)it2.next();
                CompoundTag ct = ((AEFluidKey)entry.getKey()).toTag();
                ct.m_128356_("real", entry.getLongValue());
                fluidsTag.add((Object)ct);
            }
            if (!fluidsTag.isEmpty()) {
                tag.m_128365_("fluidInventory", (Tag)fluidsTag);
            }
            if (!this.lock && !this.shareInventory.isEmpty()) {
                tag.m_128365_("inv", (Tag)this.shareInventory.storage.serializeNBT());
            }
            if (!this.shareTank.isEmpty()) {
                ListTag tanks = new ListTag();
                for (CustomFluidTank tank : this.shareTank.getStorages()) {
                    if (tank.isEmpty()) {
                        tanks.add((Object)new CompoundTag());
                        continue;
                    }
                    tanks.add((Object)tank.serializeNBT());
                }
                tag.m_128365_("tank", (Tag)tanks);
            }
            if (!this.lock && (c = IntCircuitBehaviour.getCircuitConfiguration((ItemStack)this.circuitInventory.storage.getStackInSlot(0))) > 0) {
                tag.m_128405_("c", c);
            }
            tag.m_128379_("l", this.lock);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            int c;
            Object t3;
            this.setRecipe(Recipe.deserializeNBT((Tag)tag.m_128423_("recipe")));
            ListTag items = tag.m_128437_("inventory", 10);
            for (Object t2 : items) {
                long amount;
                CompoundTag ct;
                AEItemKey stack;
                if (!(t2 instanceof CompoundTag) || (stack = AEItemKey.fromTag((CompoundTag)(ct = (CompoundTag)t2))) == null || (amount = ct.m_128454_("real")) <= 0L) continue;
                this.itemInventory.put((Object)stack, amount);
            }
            ListTag fluids = tag.m_128437_("fluidInventory", 10);
            for (Object t3 : fluids) {
                long amount;
                CompoundTag ct;
                AEFluidKey stack;
                if (!(t3 instanceof CompoundTag) || (stack = AEFluidKey.fromTag((CompoundTag)(ct = (CompoundTag)t3))) == null || (amount = ct.m_128454_("real")) <= 0L) continue;
                this.fluidInventory.put((Object)stack, amount);
            }
            t3 = tag.f_128329_.get("inv");
            if (t3 instanceof CompoundTag) {
                CompoundTag inv = (CompoundTag)t3;
                this.shareInventory.storage.deserializeNBT(inv);
            }
            if ((t3 = tag.f_128329_.get("tank")) instanceof ListTag) {
                ListTag tanks = (ListTag)t3;
                for (int i = 0; i < tanks.size(); ++i) {
                    CompoundTag t4 = tanks.m_128728_(i);
                    if (t4.m_128456_()) continue;
                    CustomFluidTank tank = this.shareTank.getStorages()[i];
                    tank.deserializeNBT(t4);
                }
            }
            if ((c = tag.m_128451_("c")) > 0) {
                this.circuitInventory.storage.setStackInSlot(0, IntCircuitBehaviour.stack((int)c));
            }
            this.setLock(tag.m_128471_("l"));
        }

        public void setOnContentsChanged(Runnable onContentsChanged) {
            this.onContentsChanged = onContentsChanged;
        }

        public Runnable getOnContentsChanged() {
            return this.onContentsChanged;
        }

        @Generated
        public boolean isLock() {
            return this.lock;
        }

        @Generated
        public void setShouldLockRecipe(boolean shouldLockRecipe) {
            this.shouldLockRecipe = shouldLockRecipe;
        }
    }

    private record InputSink(InternalSlot slot) implements IPatternDetails.PatternInputSink
    {
        public void pushInput(AEKey key, long amount) {
            if (amount < 1L) {
                return;
            }
            if (key instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)key;
                this.slot.itemInventory.addTo((Object)itemKey, amount);
            } else if (key instanceof AEFluidKey) {
                AEFluidKey fluidKey = (AEFluidKey)key;
                this.slot.fluidInventory.addTo((Object)fluidKey, amount);
            }
        }
    }
}

