/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IWailaDisplayProvider;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gtocore.common.machine.multiblock.part.ae.MEPatternBufferPartMachine;
import com.gtocore.common.machine.trait.ProxySlotRecipeHandler;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class MEPatternBufferProxyPartMachine
extends WorkableTieredIOPartMachine
implements IMachineLife,
IDataStickInteractable,
IWailaDisplayProvider {
    private ProxySlotRecipeHandler proxySlotRecipeHandler = ProxySlotRecipeHandler.DEFAULT;
    @Persisted
    @DescSynced
    @Nullable
    private BlockPos bufferPos;
    @Nullable
    private MEPatternBufferPartMachine buffer = null;
    private boolean bufferResolved = false;

    public MEPatternBufferProxyPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 6, IO.IN);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7654_().m_6937_((Runnable)new TickTask(0, () -> this.setBuffer(this.bufferPos)));
        }
    }

    public void onUnload() {
        super.onUnload();
        MEPatternBufferPartMachine buf = this.getBuffer();
        if (buf != null) {
            buf.removeProxy(this);
            this.proxySlotRecipeHandler = ProxySlotRecipeHandler.DEFAULT;
            this.bufferResolved = false;
        }
    }

    public List<RecipeHandlerList> getRecipeHandlers() {
        return this.proxySlotRecipeHandler.getProxySlotHandlers();
    }

    public void setBuffer(@Nullable BlockPos pos) {
        this.bufferResolved = true;
        Level level = this.getLevel();
        if (level == null || pos == null) {
            this.buffer = null;
        } else {
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)pos);
            if (metaMachine instanceof MEPatternBufferPartMachine) {
                MEPatternBufferPartMachine machine = (MEPatternBufferPartMachine)metaMachine;
                this.proxySlotRecipeHandler = new ProxySlotRecipeHandler(this, machine);
                this.bufferPos = pos;
                this.buffer = machine;
                machine.addProxy(this);
                if (!this.isRemote()) {
                    this.proxySlotRecipeHandler.updateProxy(machine);
                    for (IMultiController controller : this.getControllers()) {
                        controller.requestCheck();
                    }
                }
            } else {
                this.buffer = null;
            }
        }
    }

    @Nullable
    public MEPatternBufferPartMachine getBuffer() {
        if (!this.bufferResolved) {
            this.setBuffer(this.bufferPos);
        }
        return this.buffer;
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return this.getBuffer() != null;
    }

    public ModularUI createUI(Player entityPlayer) {
        assert (this.getBuffer() != null);
        return this.getBuffer().createUI(entityPlayer);
    }

    public void onMachineRemoved() {
        MEPatternBufferPartMachine buf = this.getBuffer();
        if (buf != null) {
            buf.removeProxy(this);
            this.proxySlotRecipeHandler = ProxySlotRecipeHandler.DEFAULT;
        }
    }

    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        if (dataStick.m_41782_()) {
            assert (dataStick.m_41783_() != null);
            if (dataStick.m_41783_().m_128425_("pos", 11)) {
                int[] posArray = dataStick.m_41784_().m_128465_("pos");
                BlockPos bufferPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.setBuffer(bufferPos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void appendWailaTooltip(CompoundTag data, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (!data.m_128471_("formed")) {
            return;
        }
        if (!data.m_128471_("bound")) {
            iTooltip.add((Component)Component.m_237115_((String)"gtceu.top.buffer_not_bound").m_130940_(ChatFormatting.RED));
            return;
        }
        int[] pos = data.m_128465_("pos");
        iTooltip.add((Component)Component.m_237110_((String)"gtceu.top.buffer_bound_pos", (Object[])new Object[]{pos[0], pos[1], pos[2]}).m_130938_(TooltipHelper.RAINBOW_HSL_SLOW));
        MEPatternBufferPartMachine.readBufferTag(iTooltip, data);
    }

    public void appendWailaData(CompoundTag data, BlockAccessor blockAccessor) {
        if (!this.isFormed()) {
            data.m_128379_("formed", false);
            return;
        }
        data.m_128379_("formed", true);
        MEPatternBufferPartMachine buffer = this.getBuffer();
        if (buffer == null) {
            data.m_128379_("bound", false);
            return;
        }
        data.m_128379_("bound", true);
        BlockPos pos = buffer.getPos();
        data.m_128385_("pos", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        MEPatternBufferPartMachine.writeBufferTag(data, buffer);
    }
}

