/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.multiblock.IMEStockingPart;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.gtocore.common.machine.multiblock.part.ae.MEInputBusPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemSlot;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEStockingItemList;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEStockingBusPartMachine
extends MEInputBusPartMachine
implements IMEStockingPart,
IStorageService.UpdateRequester {
    @Persisted
    private boolean autoPull;

    public MEStockingBusPartMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        super.addedToController(controller);
    }

    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        super.removedFromController(controller);
    }

    @Override
    protected ExportOnlyAEStockingItemList createInventory() {
        return new ExportOnlyAEStockingItemList(this, 16);
    }

    @Override
    void syncME() {
        if (this.autoPull) {
            this.refreshList();
        } else {
            IGrid grid = this.getMainNode().getGrid();
            if (grid == null) {
                return;
            }
            MEStorage networkInv = grid.getStorageService().getInventory();
            for (ExportOnlyAEItemSlot slot : this.aeItemHandler.getInventory()) {
                AEKey key;
                long extracted;
                GenericStack config = slot.getConfig();
                if (config != null && (extracted = networkInv.extract(key = config.what(), Long.MAX_VALUE, Actionable.SIMULATE, this.getActionSourceField())) > 0L) {
                    slot.setStock(new GenericStack(key, extracted));
                    continue;
                }
                slot.setStock(null);
            }
        }
    }

    @Override
    protected void flushInventory() {
    }

    @Override
    public void setDistinct(boolean isDistinct) {
        super.setDistinct(isDistinct);
        if (!this.isRemote() && !isDistinct) {
            this.validateConfig();
        }
    }

    public IConfigurableSlotList getSlotList() {
        return this.aeItemHandler;
    }

    public boolean testConfiguredInOtherPart(@Nullable GenericStack config) {
        if (config == null) {
            return false;
        }
        if (!this.isFormed()) {
            return false;
        }
        for (IMultiController controller : this.getControllers()) {
            for (IMultiPart part : controller.getParts()) {
                MEStockingBusPartMachine bus;
                if (!(part instanceof MEStockingBusPartMachine) || (bus = (MEStockingBusPartMachine)part) == this || !bus.aeItemHandler.hasStackInConfig(config, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void setAutoPull(boolean autoPull) {
        this.autoPull = autoPull;
        if (!this.isRemote()) {
            if (!this.autoPull) {
                this.aeItemHandler.clearInventory(0);
            } else if (this.updateMEStatus()) {
                this.refreshList();
                this.updateInventorySubscription();
            }
        }
    }

    boolean test(AEKey what) {
        return true;
    }

    private void refreshList() {
        int index;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            this.aeItemHandler.clearInventory(0);
            return;
        }
        KeyCounter counter = grid.getStorageService().getCachedInventory();
        if (counter.isEmpty()) {
            return;
        }
        MEStorage networkStorage = grid.getStorageService().getInventory();
        PriorityQueue<GenericStack> queue = new PriorityQueue<GenericStack>(16, Comparator.comparingLong(GenericStack::amount));
        try {
            for (Reference2LongMap.Entry entry : counter) {
                GenericStack stack;
                boolean free;
                AEKey what;
                long amount = entry.getLongValue();
                if (amount <= 0L || !((what = (AEKey)entry.getKey()) instanceof AEItemKey)) continue;
                boolean bl = free = queue.size() < 16;
                if (!free && queue.peek().amount() >= amount || !this.test(what) || this.testConfiguredInOtherPart(stack = new GenericStack(what, amount))) continue;
                if (free) {
                    queue.offer(stack);
                    continue;
                }
                queue.poll();
                queue.offer(stack);
            }
        }
        catch (NullPointerException e) {
            GTOCore.LOGGER.error("exception in MEStockingBusPartMachine.refreshList");
        }
        int size = queue.size();
        for (index = 0; index < 16 && !queue.isEmpty(); ++index) {
            GenericStack stack = queue.poll();
            AEKey what = stack.what();
            long amount = stack.amount();
            long request = networkStorage.extract(what, amount, Actionable.SIMULATE, this.getActionSourceField());
            ExportOnlyAEItemSlot slot = this.aeItemHandler.getInventory()[size - index - 1];
            slot.setConfig(new GenericStack(what, 1L));
            slot.setStock(new GenericStack(what, request));
        }
        this.aeItemHandler.clearInventory(index);
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        super.attachConfigurators(configuratorPanel);
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            this.setAutoPull(!this.autoPull);
            if (this.autoPull) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.stocking_auto_pull_enabled"));
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.stocking_auto_pull_disabled"));
            }
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    @Override
    protected CompoundTag writeConfigToTag() {
        if (!this.autoPull) {
            CompoundTag tag = super.writeConfigToTag();
            tag.m_128379_("AutoPull", false);
            return tag;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("AutoPull", true);
        tag.m_128379_("DistinctBuses", this.isDistinct());
        if (!this.circuitInventory.storage.getStackInSlot(0).m_41619_()) {
            tag.m_128344_("GhostCircuit", (byte)IntCircuitBehaviour.getCircuitConfiguration((ItemStack)this.circuitInventory.storage.getStackInSlot(0)));
        }
        return tag;
    }

    @Override
    protected void readConfigFromTag(CompoundTag tag) {
        if (tag.m_128471_("AutoPull")) {
            this.setAutoPull(true);
            if (tag.m_128441_("DistinctBuses")) {
                this.setDistinct(tag.m_128471_("DistinctBuses"));
            }
            if (tag.m_128441_("GhostCircuit")) {
                this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack((int)tag.m_128445_("GhostCircuit")));
            } else {
                this.circuitInventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            return;
        }
        this.setAutoPull(false);
        super.readConfigFromTag(tag);
    }

    public boolean isAutoPull() {
        return this.autoPull;
    }

    public void setAutoPullTest(Predicate<GenericStack> autoPullTest) {
    }
}

