/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAESlot;
import com.gtolib.utils.MathUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEFluidSlot
extends ExportOnlyAESlot
implements IFluidHandlerModifiable,
IFluidTank {
    FluidStack stack = null;

    public ExportOnlyAEFluidSlot() {
    }

    ExportOnlyAEFluidSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        if (this.stock == null) {
            this.stock = stack;
            this.stack = null;
        } else {
            this.stock = GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
            if (this.stack != null) {
                this.stack.setAmount(MathUtil.saturatedCast((long)((long)this.stack.getAmount() + stack.amount())));
            }
        }
        this.onContentsChanged();
    }

    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.stack = null;
        this.onContentsChanged();
    }

    public FluidStack getReadOnlyStack() {
        AEKey aEKey;
        if (this.stock != null && (aEKey = this.stock.what()) instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return fluidKey.getReadOnlyStack();
        }
        return FluidStack.EMPTY;
    }

    public FluidStack getFluid() {
        AEKey aEKey;
        if (this.stock != null && (aEKey = this.stock.what()) instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            if (this.stack == null) {
                this.stack = fluidKey.toStack(GTMath.saturatedCast((long)this.stock.amount()));
            }
            return this.stack;
        }
        return FluidStack.EMPTY;
    }

    public boolean isFluidValid(FluidStack stack) {
        return false;
    }

    public int getFluidAmount() {
        return this.stock != null ? GTMath.saturatedCast((long)this.stock.amount()) : 0;
    }

    public int getCapacity() {
        return 0;
    }

    public int getTanks() {
        return 0;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public void setFluidInTank(int tank, FluidStack stack) {
    }

    public int getTankCapacity(int tank) {
        return 0;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public boolean supportsFill(int tank) {
        return false;
    }

    public long drain(long amount, boolean simulate, boolean notify) {
        if (this.stock == null || !(this.stock.what() instanceof AEFluidKey)) {
            return 0L;
        }
        long drained = Math.min(this.stock.amount(), amount);
        if (!simulate) {
            this.stock = new GenericStack(this.stock.what(), this.stock.amount() - drained);
            if (this.stock.amount() == 0L) {
                this.stock = null;
                this.stack = null;
            } else if (this.stack != null) {
                this.stack.setAmount(MathUtil.saturatedCast((long)this.stock.amount()));
            }
            if (notify) {
                this.onContentsChanged();
            }
        }
        return drained;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getFluid().isFluidEqual(resource)) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        AEKey aEKey;
        if (this.stock == null || !((aEKey = this.stock.what()) instanceof AEFluidKey)) {
            return FluidStack.EMPTY;
        }
        AEFluidKey fluidKey = (AEFluidKey)aEKey;
        int drained = (int)Math.min(this.stock.amount(), (long)maxDrain);
        FluidStack result = fluidKey.toStack(drained);
        if (action.execute()) {
            this.stock = new GenericStack(this.stock.what(), this.stock.amount() - (long)drained);
            if (this.stock.amount() == 0L) {
                this.stock = null;
                this.stack = null;
            } else if (this.stack != null) {
                this.stack.setAmount(MathUtil.saturatedCast((long)this.stock.amount()));
            }
            this.onContentsChanged();
        }
        return result;
    }

    public boolean supportsDrain(int tank) {
        return tank == 0;
    }

    public ExportOnlyAEFluidSlot copy() {
        return new ExportOnlyAEFluidSlot(this.config == null ? null : ExportOnlyAESlot.copy(this.config), this.stock == null ? null : ExportOnlyAESlot.copy(this.stock));
    }
}

