/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemSlot;
import com.gtolib.api.ae2.stacks.IAEItemKey;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ExportOnlyAEItemList
extends NotifiableItemStackHandler
implements IConfigurableSlotList {
    @Persisted
    final ExportOnlyAEItemSlot[] inventory;

    public ExportOnlyAEItemList(MetaMachine holder, int slots) {
        this(holder, slots, ExportOnlyAEItemSlot::new);
    }

    ExportOnlyAEItemList(MetaMachine holder, int slots, Supplier<ExportOnlyAEItemSlot> slotFactory) {
        super(holder, 0, IO.IN, IO.NONE, i -> new ItemStackHandlerDelegate());
        ((ItemStackHandlerDelegate)this.storage).list = this;
        this.inventory = new ExportOnlyAEItemSlot[slots];
        for (int i2 = 0; i2 < slots; ++i2) {
            this.inventory[i2] = slotFactory.get();
            this.inventory[i2].setOnContentsChanged(this::onContentsChanged);
        }
    }

    public void onContentsChanged() {
        super.onContentsChanged();
        this.changed = true;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (ExportOnlyAEItemSlot i : this.inventory) {
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public int getSlots() {
        return this.inventory.length;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot].getStack();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.inventory[slot].extractItem(0, amount, simulate);
    }

    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
        if (io == IO.IN) {
            boolean changed = false;
            Iterator<Ingredient> it = left.iterator();
            while (it.hasNext()) {
                long amount;
                FastSizedIngredient si;
                Ingredient ingredient = it.next();
                if (ingredient.m_43947_()) {
                    it.remove();
                    continue;
                }
                if (ingredient instanceof FastSizedIngredient) {
                    si = (FastSizedIngredient)ingredient;
                    amount = si.getAmount();
                } else {
                    amount = 1L;
                }
                if (amount < 1L) {
                    it.remove();
                    continue;
                }
                for (ExportOnlyAEItemSlot i : this.inventory) {
                    long extracted;
                    long count;
                    GenericStack stored = i.stock;
                    if (stored == null || (count = stored.amount()) == 0L) continue;
                    if (ingredient.test(i.getReadOnlyStack()) && (extracted = i.extractItem(Math.min(count, amount), simulate, false)) > 0L) {
                        changed = true;
                        amount -= extracted;
                    }
                    if (amount > 0L) continue;
                    it.remove();
                    break;
                }
                if (amount <= 0L || !(ingredient instanceof FastSizedIngredient)) continue;
                si = (FastSizedIngredient)ingredient;
                si.setAmount(amount);
            }
            if (!simulate && changed) {
                this.onContentsChanged();
            }
        }
        return left.isEmpty() ? null : left;
    }

    public boolean forEachItems(ObjectLongPredicate<ItemStack> function) {
        for (ExportOnlyAEItemSlot i : this.inventory) {
            GenericStack stock;
            if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L || !function.test((Object)i.getReadOnlyStack(), stock.amount())) continue;
            return true;
        }
        return false;
    }

    public void fastForEachItems(ObjectLongConsumer<ItemStack> function) {
        for (ExportOnlyAEItemSlot i : this.inventory) {
            GenericStack stock;
            if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L) continue;
            function.accept((Object)i.getReadOnlyStack(), stock.amount());
        }
    }

    public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
        if (this.changed) {
            this.changed = false;
            this.intIngredientMap.clear();
            boolean specialConverter = ((RecipeType)type).specialConverter;
            for (ExportOnlyAEItemSlot i : this.inventory) {
                AEKey aEKey;
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null || stock.amount() == 0L || !((aEKey = stock.what()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)aEKey;
                if (specialConverter) {
                    type.convertItem(i.getReadOnlyStack(), stock.amount(), this.intIngredientMap);
                    continue;
                }
                ((IAEItemKey)itemKey).gtolib$convert(stock.amount(), this.intIngredientMap);
            }
        }
        return this.intIngredientMap;
    }

    public IConfigurableSlot getConfigurableSlot(int index) {
        return this.inventory[index];
    }

    public int getConfigurableSlots() {
        return this.inventory.length;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    @Generated
    public ExportOnlyAEItemSlot[] getInventory() {
        return this.inventory;
    }

    private static final class ItemStackHandlerDelegate
    extends CustomItemStackHandler {
        private ExportOnlyAEItemList list;

        private ItemStackHandlerDelegate() {
        }

        public int getSlots() {
            return this.list.inventory.length;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.list.inventory[slot].getStack();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            return this.list.inventory[slot].extractItem(0, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

