/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAESlot;
import com.gtolib.utils.MathUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEItemSlot
extends ExportOnlyAESlot {
    ItemStack stack = null;

    public ExportOnlyAEItemSlot() {
    }

    ExportOnlyAEItemSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        if (this.stock == null) {
            this.stock = stack;
            this.stack = null;
        } else {
            this.stock = GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
            if (this.stack != null) {
                this.stack.m_41764_(MathUtil.saturatedCast((long)((long)this.stack.m_41613_() + stack.amount())));
            }
        }
        this.onContentsChanged();
    }

    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.stack = null;
        this.onContentsChanged();
    }

    public ItemStack getReadOnlyStack() {
        AEKey aEKey;
        if (this.stock != null && (aEKey = this.stock.what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            return itemKey.getReadOnlyStack();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getStack() {
        if (this.stock != null) {
            if (this.stack == null) {
                ItemStack itemStack;
                AEKey aEKey = this.stock.what();
                if (aEKey instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    itemStack = itemKey.toStack(GTMath.saturatedCast((long)this.stock.amount()));
                } else {
                    itemStack = ItemStack.f_41583_;
                }
                this.stack = itemStack;
            }
            return this.stack;
        }
        return ItemStack.f_41583_;
    }

    public long extractItem(long amount, boolean simulate, boolean notify) {
        if (this.stock != null) {
            long extracted = Math.min(this.stock.amount(), amount);
            if (!(this.stock.what() instanceof AEItemKey)) {
                return 0L;
            }
            if (!simulate) {
                this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - extracted);
                if (this.stock.amount() == 0L) {
                    this.stock = null;
                    this.stack = null;
                } else if (this.stack != null) {
                    this.stack.m_41764_(MathUtil.saturatedCast((long)this.stock.amount()));
                }
                if (notify) {
                    this.onContentsChanged();
                }
            }
            return extracted;
        }
        return 0L;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && this.stock != null) {
            int extracted = (int)Math.min(this.stock.amount(), (long)amount);
            AEKey aEKey = this.stock.what();
            if (!(aEKey instanceof AEItemKey)) {
                return ItemStack.f_41583_;
            }
            AEItemKey itemKey = (AEItemKey)aEKey;
            ItemStack result = itemKey.toStack(extracted);
            if (!simulate) {
                this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - (long)extracted);
                if (this.stock.amount() == 0L) {
                    this.stock = null;
                    this.stack = null;
                } else if (this.stack != null) {
                    this.stack.m_41764_(MathUtil.saturatedCast((long)this.stock.amount()));
                }
                this.onContentsChanged();
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ExportOnlyAEItemSlot copy() {
        return new ExportOnlyAEItemSlot(this.config == null ? null : ExportOnlyAEItemSlot.copy(this.config), this.stock == null ? null : ExportOnlyAEItemSlot.copy(this.stock));
    }
}

