/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.slots;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import com.fast.recipesearch.IntLongMap;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.utils.function.ObjectLongConsumer;
import com.gregtechceu.gtceu.utils.function.ObjectLongPredicate;
import com.gtocore.common.machine.multiblock.part.ae.MEStockingBusPartMachine;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemList;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemSlot;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAESlot;
import com.gtolib.api.ae2.stacks.IAEItemKey;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.utils.MathUtil;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportOnlyAEStockingItemList
extends ExportOnlyAEItemList {
    private final MEStockingBusPartMachine machine;

    public ExportOnlyAEStockingItemList(MEStockingBusPartMachine holder, int slots) {
        super((MetaMachine)holder, slots, () -> new ExportOnlyAEStockingItemSlot(holder));
        this.machine = holder;
    }

    @Override
    public boolean forEachItems(ObjectLongPredicate<ItemStack> function) {
        if (this.machine.isWorkingEnabled()) {
            if (!this.machine.isOnline()) {
                return false;
            }
            IGrid grid = this.machine.getMainNode().getGrid();
            if (grid == null) {
                return false;
            }
            Reference2LongOpenHashMap map = null;
            int time = this.machine.getOffsetTimer();
            for (ExportOnlyAEItemSlot i : this.inventory) {
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null) continue;
                if (map == null && (map = IKeyCounter.of((KeyCounter)grid.getStorageService().getCachedInventory()).gtolib$getMap()) == null) break;
                long amount = ((ExportOnlyAEStockingItemSlot)i).refresh((Reference2LongOpenHashMap<AEKey>)map, stock.amount(), stock.what(), time);
                if (amount < 1L || !function.test((Object)i.getReadOnlyStack(), amount)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void fastForEachItems(ObjectLongConsumer<ItemStack> function) {
        if (this.machine.isWorkingEnabled()) {
            if (!this.machine.isOnline()) {
                return;
            }
            IGrid grid = this.machine.getMainNode().getGrid();
            if (grid == null) {
                return;
            }
            Reference2LongOpenHashMap map = null;
            int time = this.machine.getOffsetTimer();
            for (ExportOnlyAEItemSlot i : this.inventory) {
                GenericStack stock;
                if (i.config == null || (stock = i.stock) == null) continue;
                if (map == null && (map = IKeyCounter.of((KeyCounter)grid.getStorageService().getCachedInventory()).gtolib$getMap()) == null) break;
                long amount = ((ExportOnlyAEStockingItemSlot)i).refresh((Reference2LongOpenHashMap<AEKey>)map, stock.amount(), stock.what(), time);
                if (amount < 1L) continue;
                function.accept((Object)i.getReadOnlyStack(), amount);
            }
        }
    }

    @Override
    public IntLongMap getIngredientMap(@NotNull GTRecipeType type) {
        if (this.machine.isWorkingEnabled()) {
            if (this.changed) {
                if (!this.machine.isOnline()) {
                    return IntLongMap.EMPTY;
                }
                IGrid grid = this.machine.getMainNode().getGrid();
                if (grid == null) {
                    return IntLongMap.EMPTY;
                }
                Reference2LongOpenHashMap map = null;
                this.intIngredientMap.clear();
                boolean specialConverter = ((RecipeType)type).specialConverter;
                int time = this.machine.getOffsetTimer();
                for (ExportOnlyAEItemSlot i : this.inventory) {
                    AEKey aEKey;
                    GenericStack stock;
                    if (i.config == null || (stock = i.stock) == null || !((aEKey = stock.what()) instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    if (map == null && (map = IKeyCounter.of((KeyCounter)grid.getStorageService().getCachedInventory()).gtolib$getMap()) == null) {
                        return IntLongMap.EMPTY;
                    }
                    long amount = ((ExportOnlyAEStockingItemSlot)i).refresh((Reference2LongOpenHashMap<AEKey>)map, stock.amount(), (AEKey)itemKey, time);
                    if (amount < 1L) continue;
                    if (specialConverter) {
                        type.convertItem(i.getReadOnlyStack(), amount, this.intIngredientMap);
                        continue;
                    }
                    ((IAEItemKey)itemKey).gtolib$convert(amount, this.intIngredientMap);
                }
                this.changed = false;
            }
            return this.intIngredientMap;
        }
        return IntLongMap.EMPTY;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
        if (this.machine.isWorkingEnabled()) {
            return super.handleRecipeInner(io, recipe, left, simulate);
        }
        return left;
    }

    @Override
    public boolean isAutoPull() {
        return this.machine.isAutoPull();
    }

    @Override
    public boolean isStocking() {
        return true;
    }

    public boolean hasStackInConfig(GenericStack stack, boolean checkExternal) {
        boolean inThisBus = super.hasStackInConfig(stack, false);
        if (inThisBus) {
            return true;
        }
        if (checkExternal) {
            return this.machine.testConfiguredInOtherPart(stack);
        }
        return false;
    }

    private static final class ExportOnlyAEStockingItemSlot
    extends ExportOnlyAEItemSlot {
        private final MEStockingBusPartMachine machine;
        private long refreshTime;

        private ExportOnlyAEStockingItemSlot(MEStockingBusPartMachine machine) {
            this.machine = machine;
        }

        private ExportOnlyAEStockingItemSlot(MEStockingBusPartMachine machine, @Nullable GenericStack config, @Nullable GenericStack stock) {
            super(config, stock);
            this.machine = machine;
        }

        private long refresh(Reference2LongOpenHashMap<AEKey> map, long amount, AEKey request, int time) {
            if (this.refreshTime != (long)time) {
                this.refreshTime = time;
                long storage = map.getLong((Object)request);
                if (storage > 0L) {
                    if (amount != storage) {
                        this.stock = new GenericStack(request, storage);
                        this.stack = null;
                    }
                } else {
                    this.stock = new GenericStack(request, storage);
                    this.stack = null;
                }
                return storage;
            }
            return amount;
        }

        @Override
        public long extractItem(long amount, boolean simulate, boolean notify) {
            if (this.stock != null && this.config != null) {
                long extracted;
                if (!this.machine.isOnline()) {
                    return 0L;
                }
                IGrid grid = this.machine.getMainNode().getGrid();
                if (grid == null) {
                    return 0L;
                }
                long l = extracted = simulate ? this.stock.amount() : grid.getStorageService().getInventory().extract(this.stock.what(), amount, Actionable.MODULATE, this.machine.getActionSource());
                if (extracted > 0L) {
                    if (!simulate) {
                        this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - extracted);
                        if (this.stock.amount() == 0L) {
                            this.stock = null;
                            this.stack = null;
                        } else if (this.stack != null) {
                            this.stack.m_41764_(MathUtil.saturatedCast((long)this.stock.amount()));
                        }
                        if (notify) {
                            this.onContentsChanged();
                        }
                    }
                    return extracted;
                }
            }
            return 0L;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && this.stock != null && this.config != null) {
                long extracted;
                if (!this.machine.isOnline()) {
                    return ItemStack.f_41583_;
                }
                IGrid grid = this.machine.getMainNode().getGrid();
                if (grid == null) {
                    return ItemStack.f_41583_;
                }
                AEKey key = this.stock.what();
                long l = extracted = simulate ? this.stock.amount() : grid.getStorageService().getInventory().extract(key, (long)amount, Actionable.MODULATE, this.machine.getActionSource());
                if (extracted > 0L) {
                    ItemStack resultStack;
                    if (key instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)key;
                        v1 = itemKey.toStack((int)extracted);
                    } else {
                        v1 = resultStack = ItemStack.f_41583_;
                    }
                    if (!simulate) {
                        this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - extracted);
                        if (this.stock.amount() == 0L) {
                            this.stock = null;
                            this.stack = null;
                        } else if (this.stack != null) {
                            this.stack.m_41764_(MathUtil.saturatedCast((long)this.stock.amount()));
                        }
                        this.onContentsChanged();
                    }
                    return resultStack;
                }
            }
            return ItemStack.f_41583_;
        }

        @Override
        @NotNull
        public ExportOnlyAEStockingItemSlot copy() {
            return new ExportOnlyAEStockingItemSlot(this.machine, this.config == null ? null : ExportOnlyAEStockingItemSlot.copy(this.config), this.stock == null ? null : ExportOnlyAEStockingItemSlot.copy(this.stock));
        }
    }
}

