/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.ae.widget.slot;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.IGhostFluidTarget;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.utils.AEUtil;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEFluidSlot;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAESlot;
import com.gtocore.common.machine.multiblock.part.ae.widget.ConfigWidget;
import com.gtocore.common.machine.multiblock.part.ae.widget.slot.AEConfigSlotWidget;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class AEFluidConfigSlotWidget
extends AEConfigSlotWidget
implements IGhostFluidTarget {
    public AEFluidConfigSlotWidget(int x, int y, ConfigWidget widget2, int index) {
        super(new Position(x, y), new Size(18, 36), widget2, index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String amountStr;
        net.minecraftforge.fluids.FluidStack stack;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        GenericStack config = slot.getConfig();
        GenericStack stock = slot.getStock();
        AEFluidConfigSlotWidget.drawSlots(graphics, mouseX, mouseY, position.x, position.y, this.parentWidget.isAutoPull());
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null && !(stack = AEUtil.toFluidStack((GenericStack)config)).isEmpty()) {
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)stack), (long)config.amount(), (int)stackX, (int)stackY, (int)16, (int)16);
            if (!this.parentWidget.isStocking()) {
                amountStr = FormattingUtil.formatNumberReadable((double)config.amount(), (boolean)true, (NumberFormat)FormattingUtil.DECIMAL_FORMAT_0F, (String)"B");
                DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
            }
        }
        if (stock != null && !(stack = AEUtil.toFluidStack((GenericStack)stock)).isEmpty()) {
            DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)stack), (long)stock.amount(), (int)stackX, (int)(stackY + 18), (int)16, (int)16);
            amountStr = FormattingUtil.formatNumberReadable((double)stock.amount(), (boolean)true, (NumberFormat)FormattingUtil.DECIMAL_FORMAT_0F, (String)"B");
            DrawerHelper.drawStringFixedCorner((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 17), (float)(stackY + 18 + 17), (int)0xFFFFFF, (boolean)true, (float)0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEListGridWidget.drawSelectionOverlay((GuiGraphics)graphics, (int)stackX, (int)stackY, (int)16, (int)16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEListGridWidget.drawSelectionOverlay((GuiGraphics)graphics, (int)stackX, (int)(stackY + 18), (int)16, (int)16);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawSlots(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, boolean autoPull) {
        if (autoPull) {
            GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        } else {
            GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
            GuiTextures.CONFIG_ARROW.draw(graphics, mouseX, mouseY, (float)x, (float)y, 18, 18);
        }
        GuiTextures.SLOT_DARK.draw(graphics, mouseX, mouseY, (float)x, (float)(y + 18), 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button2) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (this.parentWidget.isAutoPull()) {
                return false;
            }
            if (button2 == 1) {
                this.writeClientAction(1000, buf -> {});
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.disableAmountClient();
                }
            } else if (button2 == 0) {
                ItemStack hold = this.gui.getModularUIContainer().m_142621_();
                FluidUtil.getFluidContained((ItemStack)hold).ifPresent(f -> this.writeClientAction(1001, arg_0 -> ((net.minecraftforge.fluids.FluidStack)f).writeToPacket(arg_0)));
                if (!this.parentWidget.isStocking()) {
                    this.parentWidget.enableAmountClient(this.index);
                    this.select = true;
                }
            }
            return true;
        }
        if (this.mouseOverStock(mouseX, mouseY)) {
            if (button2 != 0) {
                return false;
            }
            if (this.parentWidget.isStocking()) {
                return false;
            }
            if (this.parentWidget.getDisplay(this.index).getStock() != null) {
                this.writeClientAction(1003, buf -> buf.writeBoolean(AEFluidConfigSlotWidget.isShiftDown()));
            }
            return true;
        }
        return false;
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        switch (id) {
            case 1000: {
                slot.setConfig(null);
                this.parentWidget.disableAmount();
                this.writeUpdateInfo(1000, buf -> {});
                break;
            }
            case 1001: {
                net.minecraftforge.fluids.FluidStack fluid = net.minecraftforge.fluids.FluidStack.readFromPacket((FriendlyByteBuf)buffer);
                GenericStack stack = AEUtil.fromFluidStack((net.minecraftforge.fluids.FluidStack)fluid);
                if (!this.isStackValidForSlot(stack)) {
                    return;
                }
                slot.setConfig(stack);
                this.parentWidget.enableAmount(this.index);
                if (fluid == net.minecraftforge.fluids.FluidStack.EMPTY) break;
                this.writeUpdateInfo(1001, arg_0 -> ((net.minecraftforge.fluids.FluidStack)fluid).writeToPacket(arg_0));
                break;
            }
            case 1002: {
                if (slot.getConfig() == null) break;
                int amt = buffer.readInt();
                slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
                this.writeUpdateInfo(1002, buf -> buf.writeInt(amt));
                break;
            }
            case 1003: {
                boolean isShiftDown;
                int clickResult;
                if (slot.getStock() == null || (clickResult = this.tryClickContainer(isShiftDown = buffer.readBoolean())) < 0) break;
                this.writeUpdateInfo(1003, buf -> buf.m_130130_(clickResult));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        switch (id) {
            case 1000: {
                slot.setConfig(null);
                break;
            }
            case 1001: {
                net.minecraftforge.fluids.FluidStack fluid = new net.minecraftforge.fluids.FluidStack((Fluid)BuiltInRegistries.f_257020_.m_7745_(buffer.m_130281_()), buffer.m_130242_());
                slot.setConfig(new GenericStack((AEKey)AEFluidKey.of((Fluid)fluid.getFluid()), (long)fluid.getAmount()));
                break;
            }
            case 1002: {
                if (slot.getConfig() == null) break;
                int amt = buffer.readInt();
                slot.setConfig(ExportOnlyAESlot.copy(slot.getConfig(), amt));
                break;
            }
            case 1003: {
                GenericStack stack1;
                AEKey aEKey;
                if (slot.getStock() == null || !((aEKey = slot.getStock().what()) instanceof AEFluidKey)) break;
                AEFluidKey key = (AEFluidKey)aEKey;
                ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
                int newStackSize = buffer.m_130242_();
                currentStack.m_41764_(newStackSize);
                this.gui.getModularUIContainer().m_142503_(currentStack);
                net.minecraftforge.fluids.FluidStack stack = new net.minecraftforge.fluids.FluidStack(key.getFluid(), GTMath.saturatedCast((long)slot.getStock().amount()));
                CompoundTag tag = key.getTag();
                if (tag != null) {
                    stack.setTag(tag.m_6426_());
                }
                slot.setStock((stack1 = ExportOnlyAESlot.copy(slot.getStock(), Math.max(0L, slot.getStock().amount() - (long)stack.getAmount()))).amount() == 0L ? null : stack1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rect2i getRectangleBox() {
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        return rectangle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void acceptFluid(net.minecraftforge.fluids.FluidStack fluidStack) {
        if (fluidStack.getRawFluid() != Fluids.f_76191_ && (long)fluidStack.getAmount() <= 0L) {
            fluidStack.setAmount(1000);
        }
        if (!fluidStack.isEmpty()) {
            this.writeClientAction(1001, arg_0 -> ((net.minecraftforge.fluids.FluidStack)fluidStack).writeToPacket(arg_0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        long amt;
        net.minecraftforge.fluids.FluidStack fluid;
        if (this.parentWidget.isStocking()) {
            return false;
        }
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rect2i rectangle = this.toRectangleBox();
        rectangle.m_173058_(rectangle.m_110091_() / 2);
        if (slot.getConfig() == null || wheelDelta == 0.0 || !rectangle.m_110087_((int)mouseX, (int)mouseY)) {
            return false;
        }
        AEKey aEKey = slot.getConfig().what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            v0 = new net.minecraftforge.fluids.FluidStack(fluidKey.getFluid(), GTMath.saturatedCast((long)slot.getConfig().amount()), fluidKey.getTag());
        } else {
            v0 = fluid = net.minecraftforge.fluids.FluidStack.EMPTY;
        }
        if (AEFluidConfigSlotWidget.isCtrlDown()) {
            amt = wheelDelta > 0.0 ? (long)fluid.getAmount() : (long)fluid.getAmount() / 2L;
        } else {
            long l = amt = wheelDelta > 0.0 ? (long)fluid.getAmount() + 1L : (long)fluid.getAmount() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            int finalAmt = (int)amt;
            this.writeClientAction(1002, buf -> buf.writeInt(finalAmt));
            return true;
        }
        return false;
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        ExportOnlyAEFluidSlot fluid;
        ExportOnlyAEFluidSlot fluidTank;
        IConfigurableSlot iConfigurableSlot = this.parentWidget.getConfig(this.index);
        ExportOnlyAEFluidSlot exportOnlyAEFluidSlot = fluidTank = iConfigurableSlot instanceof ExportOnlyAEFluidSlot ? (fluid = (ExportOnlyAEFluidSlot)iConfigurableSlot) : null;
        if (fluidTank == null) {
            return -1;
        }
        Player player = this.gui.entityPlayer;
        ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)currentStack).resolve().orElse(null);
        if (handler == null) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.m_41613_() : 1;
        if (fluidTank.getFluidAmount() > 0) {
            FluidActionResult result;
            boolean performedFill = false;
            net.minecraftforge.fluids.FluidStack initialFluid = fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess(); ++i) {
                ItemStack remainingStack = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                currentStack.m_41774_(1);
                performedFill = true;
                if (remainingStack.m_41619_() || player.m_36356_(remainingStack)) continue;
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                break;
            }
            if (performedFill) {
                SoundEvent soundevent = initialFluid.getFluid().getFluidType().getSound(initialFluid, SoundActions.BUCKET_FILL);
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        }
        return -1;
    }
}

