/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part.maintenance;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.SingleCustomItemStackHandler;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.machine.multiblock.part.maintenance.ACMHatchPartMachine;
import com.gtocore.common.machine.multiblock.part.maintenance.CMHatchPartMachine;
import com.gtocore.common.machine.multiblock.part.maintenance.IModularMaintenance;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public class ModularHatchPartMachine
extends ACMHatchPartMachine
implements IModularMaintenance,
IMachineModifyDrops {
    private TickableSubscription tickSubs;
    @Persisted
    private final NotifiableItemStackHandler temperatureModuleInv = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, SingleCustomItemStackHandler::new);
    @Persisted
    private final NotifiableItemStackHandler gravityModuleInv;
    @Persisted
    private final NotifiableItemStackHandler vacuumModuleInv;
    @Persisted
    private final NotifiableItemStackHandler cleanroomModuleInv;
    @Persisted
    private int temperature = 293;
    @Persisted
    private int activeTemperature = 293;
    @Persisted
    @DescSynced
    private int currentGravity = 0;
    @Persisted
    @DescSynced
    private boolean vacuumMode = false;
    @Persisted
    @DescSynced
    private boolean gravityMode = false;
    @Persisted
    @DescSynced
    private boolean temperatureMode = false;
    private IntInputWidget gravityWidget;
    private IntInputWidget temperatureWidget;
    private static final int xlabel = 6;
    private static final int xslot = 160;
    private static final int ylabel = 4;
    private static final int MIN_TEMPERATURE = 273;
    private static final int MAX_TEMPERATURE = 2273;
    private static final int MIN_GRAVITY = 0;
    private static final int MAX_GRAVITY = 100;
    @RegisterLanguage(cn="\u5728\u69fd\u4f4d\u653e\u5165%s\u4ee5\u542f\u7528%s\u529f\u80fd", en="Place %s in the corresponding slot to enable %s functionality")
    private static final String TOOLTIP_KEY = "gtocore.machine.modular_maintenance.tooltip";
    @RegisterLanguage(cn="\u5728\u69fd\u4f4d\u653e\u5165\u8d85\u51c0\u53ef\u914d\u7f6e\u7ef4\u62a4\u4ed3\u4ee5\u542f\u7528\u5bf9\u5e94\u7b49\u7ea7\u7684\u8d85\u51c0\u73af\u5883", en="Place a Cleanroom Configurable Maintenance Hatch in the slot to enable the corresponding level of cleanroom environment")
    private static final String TOOLTIP_KEY_CLEANROOM = "gtocore.machine.modular_maintenance.tooltip.cleanroom";
    @RegisterLanguage(cn="\u653e\u5165%s\u4ee5\u542f\u7528\u8c03\u8282", en="Insert %s to enable adjustment")
    private static final String TOOLTIP_REQUIRED_KEY = "gtocore.machine.modular_maintenance.required.tooltip";
    @RegisterLanguage(cn="\u63a7\u5236\u91cd\u529b\uff1a", en="Control Gravity\uff1a")
    private static final String GRAVITY_CONFIG = "gtocore.machine.modular_maintenance.gravity_config";
    @RegisterLanguage(cn="\u8c03\u8282\u6e29\u5ea6\uff1a", en="Adjust Temperature\uff1a")
    private static final String TEMPERATURE_CONFIG = "gtocore.machine.modular_maintenance.temperature_config";
    @RegisterLanguage(cn="\u672a\u8bbe\u7f6e\u8d85\u51c0\u73af\u5883", en="Cleanroom Not Set")
    public static final String CLEANROOM_NOT_SET = "gtocore.machine.modular_maintenance.no_cleanroom";
    @RegisterLanguage(cn="\u65e0\u63a7\u5236\u5668\u6216\u4e0d\u63a5\u53d7\u8d85\u51c0", en="No Controller or Not Accepting Cleanroom")
    private static final String CLEANROOM_NOT_APPLICABLE = "gtocore.machine.modular_maintenance.no_controller";
    @RegisterLanguage(cn="\u8c03\u8282\u8303\u56f4\u9650\u5236\uff1a%s~%s", en="Adjustment Range Limit: %s~%s")
    private static final String RANGE_LIMIT = "gtocore.machine.modular_maintenance.range_limit";
    @RegisterLanguage(cn="\u5f53\u524d\u7684\u8d85\u51c0\u73af\u5883\uff1a", en="Current Cleanroom: ")
    public static final String CURRENT_CLEANROOM = "gtocore.machine.modular_maintenance.current_cleanroom";
    @RegisterLanguage(cn="4\u7ea7\u771f\u7a7a", en="Tier 4 Vacuum")
    private static final String VACUUM_TIER_4 = "gtocore.machine.modular_maintenance.vacuum_tier_4";
    @RegisterLanguage(cn="\u53ef\u63a7\u6e29\u5ea6", en="Controllable Temperature")
    private static final String TEMPERATURE_FUNC = "gtocore.machine.modular_maintenance.temperature_check";
    @RegisterLanguage(cn="\u53ef\u63a7\u91cd\u529b", en="Controllable Gravity")
    private static final String GRAVITY_FUNC = "gtocore.machine.modular_maintenance.gravity_check";

    public ModularHatchPartMachine(MetaMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId);
        this.temperatureModuleInv.setFilter(stack -> stack.m_41720_() == Wrapper.TEMPERATURE_CHECK);
        this.temperatureModuleInv.addChangedListener(this::onConditionChange);
        this.gravityModuleInv = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, SingleCustomItemStackHandler::new);
        this.gravityModuleInv.setFilter(stack -> stack.m_41720_() == Wrapper.GRAVITY_CHECK);
        this.gravityModuleInv.addChangedListener(this::onConditionChange);
        this.vacuumModuleInv = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, SingleCustomItemStackHandler::new);
        this.vacuumModuleInv.setFilter(stack -> stack.m_41720_() == Wrapper.VACUUM_CHECK);
        this.vacuumModuleInv.addChangedListener(this::onConditionChange);
        this.cleanroomModuleInv = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH, SingleCustomItemStackHandler::new);
        this.cleanroomModuleInv.setFilter(stack -> Wrapper.CLEAN_CHECK.containsKey(stack.m_41720_()));
        this.cleanroomModuleInv.addChangedListener(this::onConditionChange);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public int getCurrentGravity() {
        return this.gravityMode ? this.currentGravity : 1;
    }

    public int getTemperature() {
        return this.temperatureMode ? this.activeTemperature : this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    @Override
    public int getVacuumTier() {
        return this.vacuumMode ? 4 : IModularMaintenance.super.getVacuumTier();
    }

    @NotNull
    public MetaMachine self() {
        return this;
    }

    @Override
    @NotNull
    public Widget createUIWidget() {
        int y = 0;
        DraggableScrollableWidgetGroup group = new DraggableScrollableWidgetGroup(0, 0, 200, 100);
        group.addWidget(new WidgetGroup(4, 4, 192, 140).addWidget((Widget)ModularHatchPartMachine.getConfigPanel(6, 4 + y++ * 22, () -> ModularHatchPartMachine.getTextWidgetText(this::getDurationMultiplier), () -> Component.m_237115_((String)"gtceu.maintenance.configurable_duration.modify"), this::incInternalMultiplier, this::decInternalMultiplier, () -> true, ModularHatchPartMachine.getMIN_DURATION_MULTIPLIER(), ModularHatchPartMachine.getMAX_DURATION_MULTIPLIER())).addWidget(new SlotWidget((IItemHandlerModifiable)this.temperatureModuleInv.storage, 0, 160, 4 + y * 22, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237110_((String)TOOLTIP_KEY, (Object[])new Object[]{Wrapper.TEMPERATURE_CHECK.m_7968_().m_41611_(), Component.m_237115_((String)TEMPERATURE_FUNC)})})).addWidget((Widget)ModularHatchPartMachine.getConfigPanel(6, 4 + y++ * 22, () -> Component.m_237110_((String)"gtocore.machine.current_temperature", (Object[])new Object[]{this.getTemperature()}), () -> this.temperatureMode ? Component.m_237115_((String)TEMPERATURE_CONFIG) : Component.m_237110_((String)TOOLTIP_REQUIRED_KEY, (Object[])new Object[]{Wrapper.TEMPERATURE_CHECK.m_7968_().m_41611_()}), v -> this.setActiveTemperature(this.activeTemperature + v), v -> this.setActiveTemperature(this.activeTemperature - v), () -> this.temperatureMode, 273.0f, 2273.0f)).addWidget(new SlotWidget((IItemHandlerModifiable)this.gravityModuleInv.storage, 0, 160, 4 + y * 22, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237110_((String)TOOLTIP_KEY, (Object[])new Object[]{Wrapper.GRAVITY_CHECK.m_7968_().m_41611_(), Component.m_237115_((String)GRAVITY_FUNC)})})).addWidget((Widget)ModularHatchPartMachine.getConfigPanel(6, 4 + y++ * 22, () -> Component.m_237115_((String)"forge.entity_gravity").m_130946_(": %s".formatted(this.getCurrentGravity())), () -> this.gravityMode ? Component.m_237115_((String)GRAVITY_CONFIG) : Component.m_237110_((String)TOOLTIP_REQUIRED_KEY, (Object[])new Object[]{Wrapper.GRAVITY_CHECK.m_7968_().m_41611_()}), v -> this.setCurrentGravity(this.getCurrentGravity() + v), v -> this.setCurrentGravity(this.getCurrentGravity() - v), () -> this.gravityMode, 0.0f, 100.0f)).addWidget(new SlotWidget((IItemHandlerModifiable)this.vacuumModuleInv.storage, 0, 160, 4 + y * 22, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237110_((String)TOOLTIP_KEY, (Object[])new Object[]{Wrapper.VACUUM_CHECK.m_7968_().m_41611_(), Component.m_237115_((String)VACUUM_TIER_4)})})).addWidget((Widget)new ComponentPanelWidget(6, 4 + y++ * 22 + 11, list -> list.add(Component.m_237110_((String)"gtocore.recipe.vacuum.tier", (Object[])new Object[]{this.getVacuumTier()})))).addWidget(new SlotWidget((IItemHandlerModifiable)this.cleanroomModuleInv.storage, 0, 160, 4 + y * 22, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}).setHoverTooltips(new Component[]{Component.m_237115_((String)TOOLTIP_KEY_CLEANROOM)})).addWidget((Widget)new ComponentPanelWidget(6, 4 + y++ * 22, list -> {
            list.add(Component.m_237115_((String)CURRENT_CLEANROOM));
            list.add(this.getCurrentCleanroom().m_130940_(ChatFormatting.GREEN));
        })).setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE}));
        return group;
    }

    private static ComponentPanelWidget getConfigPanel(int x, int y, Supplier<Component> firstLine, Supplier<Component> secondLineTitle, IntConsumer onAdd, IntConsumer onSub, BooleanSupplier enableWrite, float min, float max) {
        return new ComponentPanelWidget(x, y, list -> {
            list.add((Component)firstLine.get());
            MutableComponent buttonText = ((Component)secondLineTitle.get()).m_6881_();
            if (enableWrite.getAsBoolean()) {
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]").m_130940_(ChatFormatting.RED), (String)"sub"));
                buttonText.m_130946_(" ");
                buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]").m_130940_(ChatFormatting.GREEN), (String)"add"));
            }
            list.add(buttonText.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)RANGE_LIMIT, (Object[])new Object[]{String.format("%.2f", Float.valueOf(min)), String.format("%.2f", Float.valueOf(max))})))));
        }).setMaxWidthLimit(130).clickHandler((componentData, clickData) -> {
            if (!clickData.isRemote && enableWrite.getAsBoolean()) {
                int multiplier;
                int n = clickData.isCtrlClick ? 100 : (multiplier = clickData.isShiftClick ? 10 : 1);
                if ("sub".equals(componentData)) {
                    onSub.accept(multiplier);
                } else if ("add".equals(componentData)) {
                    onAdd.accept(multiplier);
                }
            }
        });
    }

    private MutableComponent getCurrentCleanroom() {
        IMultiController iMultiController;
        if (!this.getControllers().isEmpty() && (iMultiController = this.getController()) instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)iMultiController;
            if (receiver.getCleanroom() != null) {
                List<MutableComponent> cleanroomTypes = receiver.getCleanroom().getTypes().stream().map(type -> Component.m_237115_((String)type.getTranslationKey())).toList();
                if (cleanroomTypes.isEmpty()) {
                    return Component.m_237115_((String)CLEANROOM_NOT_SET);
                }
                MutableComponent result = Component.m_237119_();
                for (int i = 0; i < cleanroomTypes.size(); ++i) {
                    result.m_7220_((Component)cleanroomTypes.get(i));
                    if (i >= cleanroomTypes.size() - 1) continue;
                    result.m_130946_(", ");
                }
                return result;
            }
            return Component.m_237115_((String)CLEANROOM_NOT_SET);
        }
        return Component.m_237115_((String)CLEANROOM_NOT_APPLICABLE);
    }

    private int getActiveTemperature() {
        return this.activeTemperature;
    }

    private void setActiveTemperature(int activeTemperature) {
        this.activeTemperature = Mth.m_14045_((int)activeTemperature, (int)273, (int)2273);
    }

    public void onDrops(List<ItemStack> drops) {
        this.clearInventory((IItemHandlerModifiable)this.temperatureModuleInv);
        this.clearInventory((IItemHandlerModifiable)this.gravityModuleInv);
        this.clearInventory((IItemHandlerModifiable)this.vacuumModuleInv);
        this.clearInventory((IItemHandlerModifiable)this.cleanroomModuleInv);
    }

    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        this.onConditionChange();
    }

    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        if (controller instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)controller;
            receiver.setCleanroom(null);
        }
    }

    private void onConditionChange() {
        ICleanroomReceiver receiver;
        this.temperatureMode = !this.temperatureModuleInv.getStackInSlot(0).m_41619_();
        this.gravityMode = !this.gravityModuleInv.getStackInSlot(0).m_41619_();
        this.vacuumMode = !this.vacuumModuleInv.getStackInSlot(0).m_41619_();
        ICleanroomProvider cleanroom = Wrapper.CLEAN_CHECK.get(this.cleanroomModuleInv.getStackInSlot(0).m_41720_());
        IMultiController iMultiController = this.getController();
        if (iMultiController instanceof ICleanroomReceiver && (receiver = (ICleanroomReceiver)iMultiController).getCleanroom() != cleanroom) {
            receiver.setCleanroom(cleanroom);
        }
        if (this.gravityWidget != null) {
            this.gravityWidget.setActive(this.vacuumMode).setVisible(this.vacuumMode);
        }
        if (this.temperatureWidget != null) {
            this.temperatureWidget.setActive(this.temperatureMode).setVisible(this.temperatureMode);
        }
    }

    private void setCurrentGravity(int gravity) {
        this.currentGravity = Mth.m_14045_((int)gravity, (int)0, (int)100);
    }

    public boolean showFancyTooltip() {
        return super.showFancyTooltip();
    }

    @Override
    public int getMaxTemperature() {
        return 2273;
    }

    @Generated
    public boolean isVacuumMode() {
        return this.vacuumMode;
    }

    @Generated
    public boolean isGravityMode() {
        return this.gravityMode;
    }

    @Generated
    public boolean isTemperatureMode() {
        return this.temperatureMode;
    }

    private static class Wrapper {
        private static final Item VACUUM_CHECK = GTOMachines.VACUUM_CONFIGURATION_HATCH.asItem();
        private static final Item GRAVITY_CHECK = GTOMachines.GRAVITY_CONFIGURATION_HATCH.asItem();
        private static final Item TEMPERATURE_CHECK = GTOMachines.ELECTRIC_HEATER.asItem();
        private static final Map<Item, ICleanroomProvider> CLEAN_CHECK = Map.of(GTOMachines.CLEANING_CONFIGURATION_MAINTENANCE_HATCH.asItem(), CMHatchPartMachine.DUMMY_CLEANROOM, GTOMachines.STERILE_CONFIGURATION_CLEANING_MAINTENANCE_HATCH.asItem(), CMHatchPartMachine.STERILE_DUMMY_CLEANROOM, GTOMachines.LAW_CONFIGURATION_CLEANING_MAINTENANCE_HATCH.asItem(), CMHatchPartMachine.LAW_DUMMY_CLEANROOM);

        private Wrapper() {
        }
    }
}

