/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.SteamHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gtocore.common.machine.multiblock.part.LargeSteamHatchPartMachine;
import com.gtolib.api.machine.feature.DummyEnergyMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseSteamMultiblockMachine
extends SteamParallelMultiblockMachine
implements DummyEnergyMachine {
    protected int maxOCamount;
    private int euMultiplier;
    @Persisted
    private int amountOC;
    @NotNull
    private IEnergyContainer container = IEnergyContainer.DEFAULT;
    private final long eut;
    private final double durationMultiplier;

    public BaseSteamMultiblockMachine(MetaMachineBlockEntity holder, int maxParallels, int eut, double durationMultiplier) {
        super(holder, new Object[]{maxParallels});
        this.eut = eut;
        this.durationMultiplier = durationMultiplier;
    }

    BaseSteamMultiblockMachine(MetaMachineBlockEntity holder, int maxParallels, double durationMultiplier) {
        this(holder, maxParallels, 32, durationMultiplier);
    }

    boolean oc() {
        return false;
    }

    public void onStructureFormed() {
        this.steamEnergy = new SteamEnergyRecipeHandler(null, 0.0);
        super.onStructureFormed();
        this.container = IEnergyContainer.DEFAULT;
        this.maxOCamount = 0;
        this.euMultiplier = 0;
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof SteamHatchPartMachine)) continue;
            SteamHatchPartMachine machine = (SteamHatchPartMachine)part;
            double conversionRate = 2.0;
            FluidStack fluid = GTMaterials.Steam.getFluid(1);
            if (machine instanceof LargeSteamHatchPartMachine) {
                LargeSteamHatchPartMachine partMachine = (LargeSteamHatchPartMachine)machine;
                conversionRate = partMachine.c;
                fluid = partMachine.f;
                this.euMultiplier = partMachine.o;
                if (this.oc()) {
                    this.maxOCamount = partMachine.o;
                }
            }
            this.steamEnergy = new SteamEnergyRecipeHandler(machine.tank, this.getConversionRate());
            this.container = new EnergyContainer(fluid, conversionRate, machine.tank);
            return;
        }
    }

    protected void addSteamEnergy() {
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.steamEnergy = null;
        this.container = IEnergyContainer.DEFAULT;
    }

    @NotNull
    public IEnergyContainer gtolib$getEnergyContainer() {
        return this.container;
    }

    @Nullable
    protected GTRecipe getRealRecipe(GTRecipe r) {
        Recipe recipe = (Recipe)r;
        long eut = recipe.getInputEUt();
        if (eut <= this.eut << this.euMultiplier) {
            if ((recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.getMaxParallels())) == null) {
                return null;
            }
            recipe.duration = (int)((double)recipe.duration * this.durationMultiplier);
            if (this.maxOCamount > 0) {
                recipe.eut = (eut *= recipe.parallels) << (this.amountOC << 1);
                recipe.duration = Math.max(1, recipe.duration / (1 << this.amountOC));
            }
            return recipe;
        }
        return null;
    }

    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed() && this.maxOCamount > 0) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.oc_amount", (Object[])new Object[]{this.amountOC}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.oc")))));
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.modification_oc").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-] "), (String)"ocSub")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"ocAdd")));
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote && this.maxOCamount > 0) {
            this.amountOC = Mth.m_14045_((int)(this.amountOC + ("ocAdd".equals(componentData) ? 1 : -1)), (int)0, (int)this.maxOCamount);
        }
    }

    public void setCleanroom(@Nullable ICleanroomProvider provider) {
        if (provider instanceof CleanroomMachine) {
            return;
        }
        super.setCleanroom(provider);
    }

    private static class EnergyContainer
    extends DummyEnergyMachine.DummyContainer {
        private final FluidStack steam;
        private final double conversionRate;
        private final NotifiableFluidTank steamTank;

        private EnergyContainer(FluidStack steam, double conversionRate, NotifiableFluidTank steamTank) {
            super(Integer.MAX_VALUE);
            this.steam = steam;
            this.conversionRate = conversionRate;
            this.steamTank = steamTank;
        }

        public long changeEnergy(long differenceAmount) {
            differenceAmount = -differenceAmount;
            int totalSteam = Math.max(1, MathUtil.saturatedCast((long)((long)((double)differenceAmount * this.conversionRate))));
            FluidStack steam = this.steam.copy();
            steam.setAmount(totalSteam);
            int leftSteam = this.steamTank.drainInternal(steam, IFluidHandler.FluidAction.EXECUTE).getAmount();
            if (leftSteam == totalSteam) {
                return -differenceAmount;
            }
            differenceAmount = (long)((double)leftSteam / this.conversionRate);
            return -differenceAmount;
        }

        public long getEnergyStored() {
            return (long)((double)this.steamTank.getFluidInTank(0).getAmount() / this.conversionRate);
        }
    }
}

