/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class FlocculationPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final Fluid PolyAluminiumChloride = GTOMaterials.PolyAluminiumChloride.getFluid();
    private static final Fluid FlocculationWasteSolution = GTOMaterials.FlocculationWasteSolution.getFluid();
    @Persisted
    private long chance;
    @Persisted
    private long inputCount;
    @Persisted
    private long outputCount;

    public FlocculationPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 4L);
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237110_((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{this.chance}));
        }
    }

    public boolean onWorking() {
        long amount;
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 20 == 0 && this.inputFluid(PolyAluminiumChloride, amount = this.getFluidAmount(new Fluid[]{PolyAluminiumChloride})[0])) {
            this.outputCount += amount;
            if (amount % 100000L == 0L) {
                if (this.chance < 100L) {
                    this.chance += amount / 10000L;
                }
            } else {
                this.chance *= 1L << (int)(-10L * Math.abs((amount - 100000L) / 100000L));
            }
        }
        return true;
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        this.outputFluid(FlocculationWasteSolution, this.outputCount);
        long outputCount = this.inputCount * 9L / 10L;
        if (Math.random() * 100.0 <= (double)this.chance) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater3, outputCount);
        } else {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater2, outputCount);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.chance = 0L;
        this.outputCount = 0L;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater2})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater2, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.calculateVoltage(this.inputCount);
            }
        }
        return this.eut;
    }
}

