/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.machine.multiblock.part.IndicatorHatchPartMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtocore.common.machine.multiblock.water.WaterPurificationUnitMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.holder.IntHolder;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ResidualDecontaminantDegasserPurificationUnitMachine
extends WaterPurificationUnitMachine {
    private static final List<FluidStack> FLUIDS = List.of(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 10000), GTMaterials.Helium.getFluid(10000), GTMaterials.SamariumIronArsenicOxide.getFluid(1000), GTMaterials.Neon.getFluid(8000), GTMaterials.IndiumTinBariumTitaniumCuprate.getFluid(1000), GTMaterials.Argon.getFluid(6000), GTMaterials.UraniumRhodiumDinaquadide.getFluid(1000), GTMaterials.Krypton.getFluid(4000), GTMaterials.EnrichedNaquadahTriniumEuropiumDuranide.getFluid(1000), GTMaterials.Xenon.getFluid(2000), GTMaterials.RutheniumTriniumAmericiumNeutronate.getFluid(1000), GTMaterials.Neutronium.getFluid(2000));
    @Persisted
    private long inputCount;
    @Persisted
    private boolean successful;
    @Persisted
    private boolean failed;
    @Persisted
    private FluidStack fluidStack;
    private IndicatorHatchPartMachine indicatorHatchPartMachine;

    public ResidualDecontaminantDegasserPurificationUnitMachine(MetaMachineBlockEntity holder) {
        super(holder, 64L);
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.residual_decontaminant_degasser_purification_unit.fluids", (Object[])new Object[]{this.fluidStack.getDisplayName()}));
            textList.add((Component)Component.m_237110_((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{this.successful && !this.failed ? 100 : 0}));
        }
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.indicatorHatchPartMachine == null && part instanceof IndicatorHatchPartMachine) {
            IndicatorHatchPartMachine indicatorHatch;
            this.indicatorHatchPartMachine = indicatorHatch = (IndicatorHatchPartMachine)part;
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.indicatorHatchPartMachine = null;
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (!this.failed && this.getOffsetTimer() % 20 == 0) {
            IntHolder nonEmpty = new IntHolder(0);
            this.fastForEachInputFluids((stack, amount) -> {
                if (stack.getFluid() == WaterPurificationPlantMachine.GradePurifiedWater6) {
                    return;
                }
                ++nonEmpty.value;
                if (!this.fluidStack.isEmpty() && this.fluidStack.getFluid() == stack.getFluid() && (long)this.fluidStack.getAmount() <= amount) {
                    this.successful = true;
                } else {
                    this.failed = true;
                }
                this.inputFluid(stack.getFluid(), amount);
            });
            if (this.fluidStack.isEmpty() && nonEmpty.value == 0) {
                this.successful = true;
            }
        }
        return true;
    }

    public void afterWorking() {
        super.afterWorking();
        this.indicatorHatchPartMachine.setRedstoneSignalOutput(0);
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        if (this.successful && !this.failed) {
            this.outputFluid(WaterPurificationPlantMachine.GradePurifiedWater7, this.inputCount * 9L / 10L);
        }
    }

    @Override
    long before() {
        this.eut = 0L;
        this.successful = false;
        this.failed = false;
        this.inputCount = Math.min(this.parallel(), this.getFluidAmount(new Fluid[]{WaterPurificationPlantMachine.GradePurifiedWater6})[0]);
        if (this.inputCount > 0L) {
            this.recipe = this.getRecipeBuilder().duration(2400).inputFluids(WaterPurificationPlantMachine.GradePurifiedWater6, this.inputCount).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)this.recipe)) {
                this.indicatorHatchPartMachine.setRedstoneSignalOutput((int)(Math.random() * 15.0));
                this.fluidStack = this.indicatorHatchPartMachine.getRedstoneSignalOutput() == 13 || this.indicatorHatchPartMachine.getRedstoneSignalOutput() == 15 ? FLUIDS.get(11) : (this.indicatorHatchPartMachine.getRedstoneSignalOutput() == 12 || this.indicatorHatchPartMachine.getRedstoneSignalOutput() == 14 ? FluidStack.EMPTY : FLUIDS.get(this.indicatorHatchPartMachine.getRedstoneSignalOutput()));
                this.calculateVoltage(this.inputCount);
            }
        }
        return this.eut;
    }
}

