/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.water;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gtocore.common.machine.multiblock.water.WaterPurificationPlantMachine;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.machine.multiblock.NoEnergyCustomParallelMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.GTOUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
abstract class WaterPurificationUnitMachine
extends NoEnergyCustomParallelMultiblockMachine
implements IIWirelessInteractor<WaterPurificationPlantMachine> {
    private WaterPurificationPlantMachine netMachineCache;
    Recipe recipe;
    @Persisted
    long eut;
    public final long multiple;
    private final ConditionalSubscriptionHandler tickSubs;

    abstract long before();

    WaterPurificationUnitMachine(MetaMachineBlockEntity holder, long multiple) {
        super(holder, false, m -> 0x1FFFFFFFFFFFFFL);
        this.multiple = multiple;
        this.tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::tickUpdate, 80, () -> ((WaterPurificationUnitMachine)this).isFormed());
        this.customParallelTrait.setDefaultMax(false);
    }

    private void tickUpdate() {
        WaterPurificationPlantMachine machine = (WaterPurificationPlantMachine)((Object)this.getNetMachine());
        if (machine == null) {
            this.getRecipeLogic().resetRecipeLogic();
        }
        this.tickSubs.updateSubscription();
    }

    void calculateVoltage(long input) {
        this.eut = input * this.multiple / 2L;
    }

    long parallel() {
        WaterPurificationPlantMachine machine = (WaterPurificationPlantMachine)((Object)this.getNetMachine());
        if (machine != null) {
            long p = super.getParallel();
            if (p < 1000L) {
                p = 1000L;
                super.setParallel(p);
            }
            return (p = Math.min(p, (machine.availableEu << 1) / this.multiple)) >= 1000L ? p : 0L;
        }
        return 0L;
    }

    void setWorking(boolean isWorkingAllowed) {
        super.setWorkingEnabled(isWorkingAllowed);
    }

    public void onContentChanges(RecipeHandlerList handlerList) {
        WaterPurificationPlantMachine machine;
        if (this.getRecipeLogic().isIdle() && (machine = (WaterPurificationPlantMachine)((Object)this.getNetMachine())) != null && machine.getRecipeLogic().isIdle()) {
            machine.getRecipeLogic().updateTickSubscription();
        }
    }

    public Class<WaterPurificationPlantMachine> getProviderClass() {
        return WaterPurificationPlantMachine.class;
    }

    public boolean firstTestMachine(WaterPurificationPlantMachine machine) {
        Level level = machine.getLevel();
        if (level != null && this.isFormed() && machine.isFormed() && GTOUtils.calculateDistance((BlockPos)machine.getPos(), (BlockPos)this.getPos()) < 32.0) {
            machine.waterPurificationUnitMachineMap.put((Object)this, this.getRecipeLogic().isWorking());
            return true;
        }
        return false;
    }

    public boolean testMachine(WaterPurificationPlantMachine machine) {
        return this.isFormed() && machine.isFormed();
    }

    public void removeNetMachineCache() {
        if (this.netMachineCache != null) {
            this.netMachineCache.waterPurificationUnitMachineMap.removeBoolean((Object)this);
            this.netMachineCache = null;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        if (!this.isRemote()) {
            this.getNetMachine();
            this.tickSubs.initialize(this.getLevel());
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.removeNetMachineCache();
    }

    public void onUnload() {
        super.onUnload();
        this.tickSubs.unsubscribe();
        this.removeNetMachineCache();
    }

    public SoundEntry getSound() {
        return GTSoundEntries.COOLING;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
    }

    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomLogic(this);
    }

    public void setNetMachineCache(WaterPurificationPlantMachine netMachineCache) {
        this.netMachineCache = netMachineCache;
    }

    public WaterPurificationPlantMachine getNetMachineCache() {
        return this.netMachineCache;
    }

    private static final class CustomLogic
    extends CustomRecipeLogic {
        private CustomLogic(WaterPurificationUnitMachine machine) {
            super((IRecipeLogicMachine)machine, () -> null);
        }

        public void updateTickSubscription() {
        }

        public void serverTick() {
        }

        public void onRecipeFinish() {
            super.onRecipeFinish();
            this.lastRecipe = null;
        }
    }
}

