/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gtolib.api.machine.SimpleNoEnergyMachine;
import com.gtolib.api.machine.feature.IReceiveHeatMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoilWaterMachine
extends SimpleNoEnergyMachine
implements IReceiveHeatMachine {
    public static final int DrawWaterExplosionLine = 400;
    @Persisted
    private int temperature = 293;
    private TickableSubscription tickSubs;

    public BoilWaterMachine(MetaMachineBlockEntity holder) {
        super(holder, 0, i -> 16000, new Object[0]);
    }

    public int getOutputSignal(@Nullable Direction side) {
        return this.getSignal(side);
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        return true;
    }

    @NotNull
    public GTRecipeType getRecipeType() {
        return GTRecipeTypes.STEAM_TURBINE_FUELS;
    }

    @Nullable
    private Recipe getRecipe() {
        if (this.temperature < 360) {
            return null;
        }
        Recipe recipe = this.getRecipeBuilder().duration(20).inputFluids(new FluidStack((Fluid)Fluids.f_76193_, 6)).outputFluids(GTMaterials.Steam.getFluid(960 * this.temperature / 600)).buildRawRecipe();
        if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        if (this.temperature > 400 && this.inputFluid((Fluid)Fluids.f_76193_, 1L)) {
            this.doExplosion(6.0f);
        }
        return null;
    }

    @NotNull
    public RecipeLogic createRecipeLogic() {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, () -> ((BoilWaterMachine)this).tickUpdate(), 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.getOffsetTimer() % 15 == 0) {
                return this.reduceTemperature(1) == 1;
            }
            return true;
        }
        return false;
    }

    public int getHeatCapacity() {
        return 12;
    }

    public int getMaxTemperature() {
        return 600;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

