/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gtolib.api.machine.SimpleNoEnergyMachine;
import com.gtolib.api.machine.feature.IHeaterMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeaterMachine
extends SimpleNoEnergyMachine
implements IHeaterMachine {
    public static final int MaxTemperature = 800;
    @Persisted
    @DescSynced
    @RequireRerender
    private int temperature = 293;
    private TickableSubscription tickSubs;

    public HeaterMachine(MetaMachineBlockEntity holder) {
        super(holder, 0, i -> 8000, new Object[0]);
    }

    public int getOutputSignal(@Nullable Direction side) {
        return this.getSignal(side);
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        return true;
    }

    @NotNull
    public GTRecipeType getRecipeType() {
        return GTRecipeTypes.STEAM_BOILER_RECIPES;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
    }

    private void setEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed && this.getRecipeLogic().isWorking()) {
            this.getRecipeLogic().interruptRecipe();
        }
        super.setWorkingEnabled(isWorkingAllowed);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, () -> {
                Level level = this.getLevel();
                if (level == null) {
                    return;
                }
                this.tickUpdate();
                this.requestSync();
                this.setEnabled(level.m_8055_(this.getPos().m_121945_(this.getFrontFacing())).m_60795_());
            }, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.getOffsetTimer() % 10 == 0) {
                this.raiseTemperature(1);
            }
            return true;
        }
        return false;
    }

    public int getHeatCapacity() {
        return 4;
    }

    public int getMaxTemperature() {
        return 800;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

