/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy.PlatformDeployment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.gtolib.GTOCore;
import com.gtolib.utils.RLUtils;
import it.unimi.dsi.fastutil.chars.Char2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2CharLinkedOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

class PlatformCreators {
    private static final CharOpenHashSet ILLEGAL_CHARS = new CharOpenHashSet();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS");
    private static final long PROGRESS_THRESHOLD = 10000000L;
    private static volatile boolean isExporting = false;
    private static final ThreadFactory VIRTUAL_THREAD_FACTORY = Thread.ofVirtual().name("structure-export-", 0L).factory();
    private static final ExecutorService EXPORT_EXECUTOR = Executors.newThreadPerTaskExecutor(VIRTUAL_THREAD_FACTORY);

    PlatformCreators() {
    }

    static void PlatformCreationAsync(ServerLevel level, BlockPos startPos, BlockPos endPos, boolean xMirror, boolean zMirror, int rotation) {
        if (isExporting) {
            return;
        }
        isExporting = true;
        CompletableFuture.runAsync(() -> {
            try {
                PlatformCreators.exportStructure(level, startPos, endPos, xMirror, zMirror, rotation);
            }
            catch (Exception e) {
                GTOCore.LOGGER.error("Structure export failed", (Throwable)e);
            }
            finally {
                isExporting = false;
            }
        }, EXPORT_EXECUTOR);
    }

    private static void exportStructure(ServerLevel level, BlockPos pos1, BlockPos pos2, boolean xMirror, boolean zMirror, int rotation) {
        boolean swapXZ;
        Path outputDir = Paths.get("logs", "platform");
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        catch (IOException e2) {
            GTOCore.LOGGER.error("Failed to create output directory", (Throwable)e2);
            return;
        }
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
        Path structurePath = outputDir.resolve(timestamp);
        Path mappingPath = outputDir.resolve(timestamp + ".json");
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        int dx = maxX - minX + 1;
        int dy = maxY - minY + 1;
        int dz = maxZ - minZ + 1;
        boolean bl = swapXZ = rotation == 90 || rotation == 270;
        if (swapXZ) {
            int temp = dx;
            dx = dz;
            dz = temp;
        }
        Reference2CharLinkedOpenHashMap stateToChar = new Reference2CharLinkedOpenHashMap();
        char nextChar = PlatformCreators.getNextValidChar('A');
        BlockState air = Blocks.f_50016_.m_49966_();
        stateToChar.put((Object)air, ' ');
        long totalBlocks = (long)dx * (long)dy * (long)dz;
        long[] progress = new long[]{0L};
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap<ChunkPos, LevelChunk>();
        try (BufferedWriter writer = Files.newBufferedWriter(structurePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            GTOCore.LOGGER.info("Starting structure export");
            writer.write(String.format(".size(%d, %d, %d)", dx, dy, dz));
            writer.newLine();
            writer.flush();
            for (int outZ = 0; outZ < dz; ++outZ) {
                ArrayList<String> ySlices = new ArrayList<String>(dy);
                for (int outY = 0; outY < dy; ++outY) {
                    StringBuilder xChars = new StringBuilder(dx);
                    for (int outX = 0; outX < dx; ++outX) {
                        int[] transformed = PlatformCreators.transformCoords(outX, outZ, dx, dz, rotation, xMirror, zMirror);
                        int rx = transformed[0];
                        int rz = transformed[1];
                        int worldX = minX + rx;
                        int worldY = minY + outY;
                        int worldZ = minZ + rz;
                        mutablePos.m_122178_(worldX, worldY, worldZ);
                        BlockState originalState = PlatformCreators.getCachedBlockState(level, mutablePos, chunkCache);
                        BlockState transformedState = PlatformCreators.transformBlockState(originalState, rotation, xMirror, zMirror);
                        if (!stateToChar.containsKey((Object)transformedState)) {
                            stateToChar.put((Object)transformedState, nextChar);
                            nextChar = PlatformCreators.getNextValidChar((char)(nextChar + '\u0001'));
                        }
                        xChars.append(stateToChar.get((Object)transformedState));
                        progress[0] = progress[0] + 1L;
                        if (progress[0] % 10000000L != 0L && progress[0] != totalBlocks) continue;
                        double percent = (double)progress[0] / (double)totalBlocks * 100.0;
                        GTOCore.LOGGER.info(String.format("Export progress: %d / %d blocks (%.2f%%)", progress[0], totalBlocks, percent));
                    }
                    ySlices.add(String.format("\"%s\"", xChars));
                }
                writer.write(String.format(".aisle(%s)", String.join((CharSequence)", ", ySlices)));
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException e3) {
            GTOCore.LOGGER.error("Failed to write structure file", (Throwable)e3);
        }
        Char2ReferenceLinkedOpenHashMap charToState = new Char2ReferenceLinkedOpenHashMap();
        stateToChar.reference2CharEntrySet().fastForEach(e -> charToState.put(e.getCharValue(), (Object)((BlockState)e.getKey())));
        PlatformCreators.saveMappingToJson((Map<Character, BlockState>)charToState, mappingPath);
        GTOCore.LOGGER.info("Exported files:");
        GTOCore.LOGGER.info(" - Structure: {}", (Object)structurePath);
        GTOCore.LOGGER.info(" - Mapping: {}", (Object)mappingPath);
    }

    private static BlockState getCachedBlockState(ServerLevel level, BlockPos.MutableBlockPos pos, Map<ChunkPos, LevelChunk> chunkCache) {
        ChunkPos chunkPos = new ChunkPos((BlockPos)pos);
        LevelChunk chunk = chunkCache.computeIfAbsent(chunkPos, cp -> level.m_6325_(cp.f_45578_, cp.f_45579_));
        return chunk.m_8055_((BlockPos)pos);
    }

    private static int[] transformCoords(int outX, int outZ, int dx, int dz, int rotation, boolean xMirror, boolean zMirror) {
        int rx = outX;
        int rz = outZ;
        switch (rotation) {
            case 90: {
                int t = rx;
                rx = dz - 1 - rz;
                rz = t;
                int n = rx;
                break;
            }
            case 180: {
                int n = dx - 1 - rx;
                break;
            }
            case 270: {
                int t = rx;
                rx = rz;
                rz = dx - 1 - t;
                int n = rx;
                break;
            }
            default: {
                int n = rx = rx;
            }
        }
        if (xMirror) {
            rx = dx - 1 - rx;
        }
        if (zMirror) {
            rz = dz - 1 - rz;
        }
        return new int[]{rx, rz};
    }

    private static BlockState transformBlockState(BlockState original, int rotation, boolean xMirror, boolean zMirror) {
        Rotation rotationEnum = switch (rotation) {
            case 90 -> Rotation.COUNTERCLOCKWISE_90;
            case 180 -> Rotation.CLOCKWISE_180;
            case 270 -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        BlockState state = original.m_60717_(rotationEnum);
        if (xMirror && zMirror) {
            state = state.m_60715_(Mirror.LEFT_RIGHT).m_60715_(Mirror.FRONT_BACK);
        } else if (xMirror) {
            state = state.m_60715_(Mirror.FRONT_BACK);
        } else if (zMirror) {
            state = state.m_60715_(Mirror.LEFT_RIGHT);
        }
        return state;
    }

    private static char getNextValidChar(char start) {
        char ch = start;
        while (ILLEGAL_CHARS.contains(ch)) {
            ch = (char)(ch + '\u0001');
        }
        return ch;
    }

    private static void saveMappingToJson(Map<Character, BlockState> mapping, Path path) {
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(BlockState.class, (Object)new BlockStateTypeAdapter()).setPrettyPrinting().create();
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson(mapping, (Appendable)writer);
            }
        }
        catch (IOException e) {
            GTOCore.LOGGER.error("Failed to save mapping to {}", (Object)path, (Object)e);
        }
    }

    static Char2ReferenceOpenHashMap<BlockState> loadMappingFromJson(ResourceLocation resLoc) {
        Char2ReferenceOpenHashMap char2ReferenceOpenHashMap;
        String resourcePath = String.format("assets/%s/%s", resLoc.m_135827_(), resLoc.m_135815_());
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(PlatformCreators.class.getClassLoader().getResourceAsStream(resourcePath)), StandardCharsets.UTF_8));
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(BlockState.class, (Object)new BlockStateTypeAdapter()).create();
            Type type = new TypeToken<Char2ReferenceOpenHashMap<BlockState>>(){}.getType();
            char2ReferenceOpenHashMap = (Char2ReferenceOpenHashMap)gson.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                GTOCore.LOGGER.error("Failed to load mapping from {}", (Object)resLoc, (Object)e);
                return new Char2ReferenceOpenHashMap();
            }
        }
        reader.close();
        return char2ReferenceOpenHashMap;
    }

    static {
        for (char c : new char[]{'.', '(', ')', ',', '/', '\\', '\"', '\'', '`'}) {
            ILLEGAL_CHARS.add(c);
        }
        for (int i = 0; i <= 65535; ++i) {
            char c = (char)i;
            if (!Character.isISOControl(c)) continue;
            ILLEGAL_CHARS.add(c);
        }
        for (char c : "\u200b\u200c\u200d\u200e\u200f\u2028\u2029\u2060\n\u2061\u2062\u2063\u2064\ufff9\ufffa\ufffb\ufeff\n\u00a0\u2002\u2003\u2009\u200a\u00ad\u1680\u180e\n\u3000\u202f".replace("\n", "").toCharArray()) {
            ILLEGAL_CHARS.add(c);
        }
    }

    private static class BlockStateTypeAdapter
    implements JsonSerializer<BlockState>,
    JsonDeserializer<BlockState> {
        private BlockStateTypeAdapter() {
        }

        public JsonElement serialize(BlockState src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)src.m_60734_());
            obj.addProperty("id", id.toString());
            JsonObject props = new JsonObject();
            src.m_61147_().forEach(prop -> props.addProperty(prop.m_61708_(), BlockStateTypeAdapter.getPropertyValue(src, prop)));
            obj.add("properties", (JsonElement)props);
            return obj;
        }

        public BlockState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(RLUtils.parse((String)obj.get("id").getAsString()));
            if (block == Blocks.f_50016_) {
                return Blocks.f_50016_.m_49966_();
            }
            BlockState[] state = new BlockState[]{block.m_49966_()};
            JsonObject props = obj.getAsJsonObject("properties");
            props.entrySet().forEach(entry -> {
                Optional valueOpt;
                Property prop = block.m_49965_().m_61081_((String)entry.getKey());
                if (prop != null && (valueOpt = prop.m_6215_(((JsonElement)entry.getValue()).getAsString())).isPresent()) {
                    BlockState newState;
                    Object value = valueOpt.get();
                    state[0] = newState = (BlockState)state[0].m_61124_(prop, (Comparable)value);
                }
            });
            return state[0];
        }

        private static <T extends Comparable<T>> String getPropertyValue(BlockState state, Property<T> prop) {
            return state.m_61143_(prop).toString();
        }
    }
}

