/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy.PlatformDeployment;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.translation.GTOMachineTooltips;
import com.gtocore.common.item.CoordinateCardBehavior;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformBlockType;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformCreators;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformStructurePlacer;
import com.gtocore.common.machine.noenergy.PlatformDeployment.PlatformTemplateStorage;
import com.gtolib.GTOCore;
import com.gtolib.api.network.NetworkPack;
import com.gtolib.utils.ServerUtils;
import com.gtolib.utils.holder.IntObjectHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlatformDeploymentMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife {
    private static final NetworkPack HIGHLIGHT_REGION = NetworkPack.registerS2C((String)"platformDeploymentMachineHighlight", (p, b2) -> {
        ResourceKey dimension = b2.m_236801_(Registries.f_256858_);
        BlockPos start = b2.m_130135_();
        BlockPos end = b2.m_130135_();
        int color = b2.readInt();
        int durationTicks = b2.readInt();
        ForgeClientEvent.highlightRegion((ResourceKey<Level>)dimension, start, end, color, durationTicks);
    });
    private static final NetworkPack STOP_HIGHLIGHT = NetworkPack.registerS2C((String)"platformDeploymentMachineStopHighlight", (p, b2) -> {
        BlockPos start = b2.m_130135_();
        BlockPos end = b2.m_130135_();
        ForgeClientEvent.stopHighlight(start, end);
    });
    @Persisted
    private final NotifiableItemStackHandler inventory;
    private final List<PlatformBlockType.PlatformPreset> presets = PlatformTemplateStorage.initializePresets();
    private final int maxGroup;
    private int step = 0;
    private static final int totalStep = 3;
    private static final int Introduction = 0;
    private static final int PresetSelection = 1;
    private static final int ConfirmConsumables = 2;
    private static final int AdjustSettings = 3;
    @Persisted
    private boolean presetConfirm = false;
    @Persisted
    private int checkGroup = 0;
    @Persisted
    private int checkId = 0;
    @Persisted
    private int saveGroup = 0;
    @Persisted
    private int saveId = 0;
    @Persisted
    private boolean preview = false;
    @Persisted
    private boolean highlight = false;
    @Persisted
    private int offsetX = 0;
    @Persisted
    private int offsetZ = 0;
    @Persisted
    private int offsetY = -1;
    @Persisted
    private int adjustX = 0;
    @Persisted
    private int adjustZ = 0;
    @Persisted
    private int adjustY = 0;
    @Persisted
    private BlockPos pos1 = new BlockPos(0, 0, 0);
    @Persisted
    private BlockPos pos2 = new BlockPos(0, 0, 0);
    @Persisted
    private final int[] materialInventory = new int[]{0, 0, 0};
    @Persisted
    private boolean insufficient = false;
    private static final List<List<IntObjectHolder<Item>>> ITEM_VALUE_HOLDERS = List.of(List.of(new IntObjectHolder(5000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[0][2].m_5456_()), new IntObjectHolder(1000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[0][1].m_5456_()), new IntObjectHolder(200, (Object)GTOItems.INDUSTRIAL_COMPONENTS[0][0].m_5456_())), List.of(new IntObjectHolder(5000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[1][2].m_5456_()), new IntObjectHolder(1000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[1][1].m_5456_()), new IntObjectHolder(200, (Object)GTOItems.INDUSTRIAL_COMPONENTS[1][0].m_5456_())), List.of(new IntObjectHolder(5000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[2][2].m_5456_()), new IntObjectHolder(1000, (Object)GTOItems.INDUSTRIAL_COMPONENTS[2][1].m_5456_()), new IntObjectHolder(200, (Object)GTOItems.INDUSTRIAL_COMPONENTS[2][0].m_5456_())));
    @Persisted
    private boolean taskCompleted = true;
    @Persisted
    private boolean skipAir = true;
    @Persisted
    private boolean updateLight = true;
    @Persisted
    private int speed = 50;
    @Persisted
    private boolean xMirror = false;
    @Persisted
    private boolean zMirror = false;
    @Persisted
    private int rotation = 0;
    @Persisted
    private boolean canExport = false;
    private int progress = 0;
    private static final int langWidth = 274;
    private static final Component empty = Component.m_237119_();
    private static final int charWidth = 6;

    public static void highlightRegion(ResourceKey<Level> dimension, BlockPos start, BlockPos end, int color, int durationTicks) {
        HIGHLIGHT_REGION.send(buf -> {
            buf.m_236858_(dimension);
            buf.m_130064_(start);
            buf.m_130064_(end);
            buf.writeInt(color);
            buf.writeInt(durationTicks);
        }, new Object[]{ServerUtils.getServer()});
    }

    public static void stopHighlight(BlockPos start, BlockPos end) {
        STOP_HIGHLIGHT.send(buf -> {
            buf.m_130064_(start);
            buf.m_130064_(end);
        }, new Object[]{ServerUtils.getServer()});
    }

    public PlatformDeploymentMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.inventory = new NotifiableItemStackHandler((MetaMachine)this, 27, IO.NONE, IO.BOTH);
        this.inventory.addChangedListener(this::examineMaterial);
        this.maxGroup = this.presets.size();
    }

    public void onLoad() {
        super.onLoad();
        this.inventory.notifyListeners();
        this.posChanged();
    }

    public void onUnload() {
        super.onUnload();
    }

    public void onMachineRemoved() {
        this.unloadingMaterial();
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    public Widget createUIWidget() {
        int width = 336;
        int height = 160;
        WidgetGroup group = new WidgetGroup(0, 0, width + 8, height + 8);
        int totalLangWidth = 282;
        DraggableScrollableWidgetGroup group_title = new DraggableScrollableWidgetGroup(4, 4, totalLangWidth, height).setBackground((IGuiTexture)GuiTextures.DISPLAY);
        group_title.addWidget((Widget)new ComponentPanelWidget(4, 5, this::addDisplayTextTitle));
        group.addWidget((Widget)group_title);
        DraggableScrollableWidgetGroup mainContentGroup = new DraggableScrollableWidgetGroup(4, 20, totalLangWidth, height - 16);
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(4, 0, this::addDisplayText).clickHandler(this::handleDisplayClick).setMaxWidthLimit(274));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(141, 0, this::addDisplayText2).clickHandler(this::handleDisplayClick).setMaxWidthLimit(137));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(72, 0, this::addDisplayText3).clickHandler(this::handleDisplayClick).setMaxWidthLimit(204));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(208, 0, this::addDisplayText4).clickHandler(this::handleDisplayClick).setMaxWidthLimit(68));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(92, 0, this::addDisplayText5).clickHandler(this::handleDisplayClick).setMaxWidthLimit(137));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(141, 0, this::addDisplayText6).clickHandler(this::handleDisplayClick).setMaxWidthLimit(137));
        mainContentGroup.addWidget((Widget)new ComponentPanelWidget(216, 0, this::addDisplayText7).clickHandler(this::handleDisplayClick).setMaxWidthLimit(68));
        mainContentGroup.addWidget((Widget)new ImageWidget(totalLangWidth - 100, 46, 100, 100, this::getIGuiTexture));
        group.addWidget((Widget)mainContentGroup);
        DraggableScrollableWidgetGroup group_start = new DraggableScrollableWidgetGroup(width - 49, 4, 54, 105).setBackground((IGuiTexture)GuiTextures.CLIPBOARD_PAPER_BACKGROUND);
        group_start.addWidget((Widget)new ComponentPanelWidget(8, 4, this::addDisplayTextStep).clickHandler((a2, b2) -> this.handleDisplayClickStep((String)a2, mainContentGroup)));
        group_start.addWidget((Widget)new ComponentPanelWidget(8, 20, this::addDisplayTextStart).clickHandler(this::handleDisplayClickStart).setMaxWidthLimit(38));
        group.addWidget((Widget)group_start);
        DraggableScrollableWidgetGroup group_slot = new DraggableScrollableWidgetGroup(width - 49, 110, 54, 54);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotIndex = y * 3 + x;
                group_slot.addWidget(new SlotWidget((IItemHandlerModifiable)this.inventory, slotIndex, x * 18, y * 18, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
            }
        }
        group.addWidget((Widget)group_slot);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private void addDisplayTextTitle(List<Component> textList) {
        textList.add((Component)Component.m_237115_((String)("gtocore.machine.industrial_platform_deployment_tools.title." + this.step)));
    }

    private void addDisplayTextStep(List<Component> textList) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i <= 3; ++i) {
            if (this.step == i) {
                result.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"\u00a7b\u2b55\u00a7r"), (String)("step_" + i)));
                continue;
            }
            result.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"\u00a71\u2b55\u00a7r"), (String)("step_" + i)));
        }
        textList.add((Component)result);
    }

    private void handleDisplayClickStep(String componentData, DraggableScrollableWidgetGroup group) {
        String[] parts = componentData.split("_", 2);
        if (parts[0].equals("step")) {
            group.setScrollYOffset(0);
            this.step = Mth.m_14045_((int)Integer.parseInt(parts[1]), (int)0, (int)3);
        }
    }

    private void addDisplayText(List<Component> textList) {
        switch (this.step) {
            case 0: {
                GTOMachineTooltips.INSTANCE.getIndustrialPlatformDeploymentToolsIntroduction().apply(textList);
                break;
            }
            case 1: {
                PlatformBlockType.PlatformPreset group = this.getPlatformPreset(this.checkGroup);
                PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.checkGroup, this.checkId);
                Component leftBtn1 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_group_plas");
                Component leftBtn2 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_group");
                MutableComponent empty1 = Component.m_237113_((String)" ".repeat(15 - ((this.checkGroup + 1) / 10 + this.maxGroup / 10 + 5) / 2));
                textList.add((Component)Component.m_237119_().m_7220_(leftBtn1).m_7220_(leftBtn2).m_7220_((Component)empty1).m_7220_((Component)Component.m_237113_((String)("<" + (this.checkGroup + 1) + "/" + this.maxGroup + ">"))));
                int totalIds = this.getPlatformPreset(this.checkGroup).structures().size();
                Component leftBtn3 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_id_plas");
                Component leftBtn4 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)"previous_id");
                MutableComponent empty2 = Component.m_237113_((String)" ".repeat(15 - ((this.checkId + 1) / 10 + totalIds / 10 + 5) / 2));
                textList.add((Component)Component.m_237119_().m_7220_(leftBtn3).m_7220_(leftBtn4).m_7220_((Component)empty2).m_7220_((Component)Component.m_237113_((String)("<" + (this.checkId + 1) + "/" + totalIds + ">"))));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.choose_this").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[\u00a7b\u2b55\u00a7r]"), (String)"choose_this")));
                textList.add((Component)(structure.preview() ? Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.preview").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[\u00a7b\ud83d\uddbc\u00a7r]"), (String)"preview")) : empty));
                textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.text.size", (Object[])new Object[]{structure.xSize(), structure.ySize(), structure.zSize(), structure.xSize() >> 4, structure.zSize() >> 4}));
                String displayName = group.displayName();
                String description = group.description();
                String source = group.source();
                if (displayName != null) {
                    textList.add((Component)Component.m_237115_((String)displayName));
                }
                if (description != null) {
                    textList.add((Component)Component.m_237115_((String)description));
                }
                if (source != null) {
                    textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.text.source", (Object[])new Object[]{source}));
                }
                String structDisplayName = structure.displayName();
                String type = structure.type();
                String structDescription = structure.description();
                String structSource = structure.source();
                if (structDisplayName != null) {
                    textList.add((Component)Component.m_237115_((String)structDisplayName));
                }
                if (type != null) {
                    textList.add((Component)Component.m_237115_((String)type));
                }
                if (structDescription != null) {
                    textList.add((Component)Component.m_237115_((String)structDescription));
                }
                if (structSource == null) break;
                textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.text.source", (Object[])new Object[]{structSource}));
                break;
            }
            case 2: {
                textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.loading"), (String)"loading"));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.reserves"));
                textList.add(empty);
                if (!this.presetConfirm) {
                    textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.unselected"));
                    break;
                }
                PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.demand"));
                textList.add(empty);
                List<IntObjectHolder<ItemStack>> extraMaterials = structure.extraMaterials();
                if (!extraMaterials.isEmpty()) {
                    textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.extra_demand"));
                    extraMaterials.forEach(e -> textList.add((Component)Component.m_237113_((String)"[").m_7220_(((ItemStack)e.obj).m_41611_()).m_130946_("\u00d7").m_130946_(String.valueOf(e.number)).m_130946_("]")));
                }
                if (!this.insufficient) {
                    textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.insufficient"));
                    break;
                }
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.adequate"));
                break;
            }
            case 3: {
                MutableComponent x_offset = Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.x", (Object[])new Object[]{this.offsetX});
                MutableComponent y_offset = Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.y", (Object[])new Object[]{this.offsetY});
                MutableComponent z_offset = Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.z", (Object[])new Object[]{this.offsetZ});
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.offset"));
                textList.add((Component)x_offset);
                textList.add((Component)y_offset);
                textList.add((Component)z_offset);
                textList.add(empty);
                if (!this.presetConfirm) {
                    textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.unselected"));
                } else {
                    textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.boundary"));
                    textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.x", (Object[])new Object[]{this.pos2.m_123341_()}));
                    textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.y", (Object[])new Object[]{this.pos2.m_123342_()}));
                    textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.offset.z", (Object[])new Object[]{this.pos2.m_123343_()}));
                }
                textList.add(empty);
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.skipAir").m_7220_(ComponentPanelWidget.withButton((Component)(this.skipAir ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off")), (String)"skipAir")));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.xMirror").m_7220_(ComponentPanelWidget.withButton((Component)(this.xMirror ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off")), (String)"xMirror")));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.rotation").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)String.valueOf(this.rotation)), (String)"rotation")));
            }
        }
    }

    private void addDisplayText2(List<Component> textList) {
        switch (this.step) {
            case 1: {
                textList.add(empty);
                textList.add(empty);
                textList.add((Component)(this.presetConfirm ? Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.text.selected", (Object[])new Object[]{this.saveGroup + 1, this.saveId + 1}) : Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.unselected")));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.highlight").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[\u00a7b\ud83d\udd06\u00a7r]"), (String)"highlight")));
                break;
            }
            case 2: {
                textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.unloading"), (String)"unloading"));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.1"));
                textList.add((Component)Component.m_237113_((String)String.valueOf(this.materialInventory[1])));
                if (!this.presetConfirm) {
                    textList.add(empty);
                    break;
                }
                PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
                int[] costMaterial = structure.materials();
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.1"));
                textList.add((Component)Component.m_237113_((String)String.valueOf(costMaterial[1])));
                break;
            }
            case 3: {
                textList.add(empty);
                textList.add(empty);
                textList.add(empty);
                textList.add(empty);
                textList.add(empty);
                if (!this.presetConfirm) {
                    textList.add(empty);
                } else {
                    textList.add(empty);
                    textList.add((Component)Component.m_237113_((String)String.valueOf(this.pos1.m_123341_())));
                    textList.add((Component)Component.m_237113_((String)String.valueOf(this.pos1.m_123342_())));
                    textList.add((Component)Component.m_237113_((String)String.valueOf(this.pos1.m_123343_())));
                }
                textList.add(empty);
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.updateLight").m_7220_(ComponentPanelWidget.withButton((Component)(this.updateLight ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off")), (String)"updateLight")));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.zMirror").m_7220_(ComponentPanelWidget.withButton((Component)(this.zMirror ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off")), (String)"zMirror")));
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.speed").m_130946_(String.valueOf(this.speed)).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"+speed")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"-speed")));
            }
        }
    }

    private void addDisplayText3(List<Component> textList) {
        if (this.step == 2) {
            textList.add(empty);
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.0"));
            textList.add((Component)Component.m_237113_((String)String.valueOf(this.materialInventory[0])));
            if (!this.presetConfirm) {
                textList.add(empty);
            } else {
                PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
                int[] costMaterial = structure.materials();
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.0"));
                textList.add((Component)Component.m_237113_((String)String.valueOf(costMaterial[0])));
            }
        }
    }

    private void addDisplayText4(List<Component> textList) {
        if (this.step == 2) {
            textList.add(empty);
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.2"));
            textList.add((Component)Component.m_237113_((String)String.valueOf(this.materialInventory[2])));
            if (!this.presetConfirm) {
                textList.add(empty);
            } else {
                PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
                int[] costMaterial = structure.materials();
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.2"));
                textList.add((Component)Component.m_237113_((String)String.valueOf(costMaterial[2])));
            }
        }
    }

    private void addDisplayText5(List<Component> textList) {
        if (this.step == 3) {
            textList.add(empty);
            MutableComponent X_change_1 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"x_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"x_add"));
            MutableComponent Y_change_1 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"y_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"y_add"));
            MutableComponent Z_change_1 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"z_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"z_add"));
            textList.add((Component)X_change_1);
            textList.add((Component)Y_change_1);
            textList.add((Component)Z_change_1);
        }
    }

    private void addDisplayText6(List<Component> textList) {
        if (this.step == 3) {
            textList.add(empty);
            MutableComponent X_change_2 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"adjust_x_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[-" + this.adjustX + "]")), (String)"x_minus_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[+" + this.adjustX + "]")), (String)"x_add_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"adjust_x_add"));
            MutableComponent Y_change_2 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"adjust_y_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[-" + this.adjustY + "]")), (String)"y_minus_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[+" + this.adjustY + "]")), (String)"y_add_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"adjust_y_add"));
            MutableComponent Z_change_2 = Component.m_237119_().m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"adjust_z_minus")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[-" + this.adjustZ + "]")), (String)"z_minus_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[+" + this.adjustZ + "]")), (String)"z_add_plas")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"adjust_z_add"));
            textList.add((Component)X_change_2);
            textList.add((Component)Y_change_2);
            textList.add((Component)Z_change_2);
        }
    }

    private void addDisplayText7(List<Component> textList) {
        if (this.step == 1) {
            Component rightBtn1 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_group");
            Component rightBtn2 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_group_plas");
            textList.add((Component)Component.m_237119_().m_7220_(rightBtn1).m_7220_(rightBtn2));
            Component rightBtn3 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_id");
            Component rightBtn4 = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)"next_id_plas");
            textList.add((Component)Component.m_237119_().m_7220_(rightBtn3).m_7220_(rightBtn4));
        }
    }

    private void handleDisplayClick(String componentData, ClickData clickData) {
        block0 : switch (this.step) {
            case 1: {
                int maxId = this.getPlatformPreset(this.checkGroup).structures().size() - 1;
                switch (componentData) {
                    case "next_group": {
                        this.checkGroup = Mth.m_14045_((int)(this.checkGroup + 1), (int)0, (int)(this.maxGroup - 1));
                        this.checkId = 0;
                        break;
                    }
                    case "previous_group": {
                        this.checkGroup = Mth.m_14045_((int)(this.checkGroup - 1), (int)0, (int)(this.maxGroup - 1));
                        this.checkId = 0;
                        break;
                    }
                    case "next_group_plas": {
                        this.checkGroup = Mth.m_14045_((int)(this.checkGroup + 10), (int)0, (int)(this.maxGroup - 1));
                        this.checkId = 0;
                        break;
                    }
                    case "previous_group_plas": {
                        this.checkGroup = Mth.m_14045_((int)(this.checkGroup - 10), (int)0, (int)(this.maxGroup - 1));
                        this.checkId = 0;
                        break;
                    }
                    case "next_id": {
                        this.checkId = Mth.m_14045_((int)(this.checkId + 1), (int)0, (int)maxId);
                        break;
                    }
                    case "previous_id": {
                        this.checkId = Mth.m_14045_((int)(this.checkId - 1), (int)0, (int)maxId);
                        break;
                    }
                    case "next_id_plas": {
                        this.checkId = Mth.m_14045_((int)(this.checkId + 5), (int)0, (int)maxId);
                        break;
                    }
                    case "previous_id_plas": {
                        this.checkId = Mth.m_14045_((int)(this.checkId - 5), (int)0, (int)maxId);
                        break;
                    }
                    case "choose_this": {
                        this.saveGroup = this.checkGroup;
                        this.saveId = this.checkId;
                        this.presetConfirm = true;
                        this.examineMaterial();
                        this.posChanged();
                        break;
                    }
                    case "preview": {
                        this.preview = !this.preview;
                        break;
                    }
                    case "highlight": {
                        this.highlight = !this.highlight;
                        this.highlightArea(this.highlight);
                    }
                }
                break;
            }
            case 2: {
                if (componentData.equals("loading")) {
                    this.loadingMaterial();
                    this.examineMaterial();
                    break;
                }
                if (!componentData.equals("unloading")) break;
                this.unloadingMaterial();
                this.examineMaterial();
                break;
            }
            case 3: {
                switch (componentData) {
                    case "x_add": {
                        ++this.offsetX;
                        this.posChanged();
                        break block0;
                    }
                    case "x_minus": {
                        --this.offsetX;
                        this.posChanged();
                        break block0;
                    }
                    case "z_add": {
                        ++this.offsetZ;
                        this.posChanged();
                        break block0;
                    }
                    case "z_minus": {
                        --this.offsetZ;
                        this.posChanged();
                        break block0;
                    }
                    case "y_add": {
                        ++this.offsetY;
                        this.posChanged();
                        break block0;
                    }
                    case "y_minus": {
                        --this.offsetY;
                        this.posChanged();
                        break block0;
                    }
                    case "x_add_plas": {
                        this.offsetX += this.adjustX;
                        this.posChanged();
                        break block0;
                    }
                    case "x_minus_plas": {
                        this.offsetX -= this.adjustX;
                        this.posChanged();
                        break block0;
                    }
                    case "adjust_x_add": {
                        this.adjustX = Math.max(0, this.adjustX + 1);
                        break block0;
                    }
                    case "adjust_x_minus": {
                        this.adjustX = Math.max(0, this.adjustX - 1);
                        break block0;
                    }
                    case "z_add_plas": {
                        this.offsetZ += this.adjustZ;
                        this.posChanged();
                        break block0;
                    }
                    case "z_minus_plas": {
                        this.offsetZ -= this.adjustZ;
                        this.posChanged();
                        break block0;
                    }
                    case "adjust_z_add": {
                        this.adjustZ = Math.max(0, this.adjustZ + 1);
                        break block0;
                    }
                    case "adjust_z_minus": {
                        this.adjustZ = Math.max(0, this.adjustZ - 1);
                        break block0;
                    }
                    case "y_add_plas": {
                        this.offsetY += this.adjustY;
                        this.posChanged();
                        break block0;
                    }
                    case "y_minus_plas": {
                        this.offsetY -= this.adjustY;
                        this.posChanged();
                        break block0;
                    }
                    case "adjust_y_add": {
                        this.adjustY = Math.max(0, this.adjustY + 1);
                        break block0;
                    }
                    case "adjust_y_minus": {
                        this.adjustY = Math.max(0, this.adjustY - 1);
                        break block0;
                    }
                    case "skipAir": {
                        this.skipAir = !this.skipAir;
                        break block0;
                    }
                    case "updateLight": {
                        this.updateLight = !this.updateLight;
                        break block0;
                    }
                    case "xMirror": {
                        this.xMirror = !this.xMirror;
                        break block0;
                    }
                    case "zMirror": {
                        this.zMirror = !this.zMirror;
                        break block0;
                    }
                    case "rotation": {
                        this.rotation = (this.rotation + 90) % 360;
                        break block0;
                    }
                    case "+speed": {
                        this.speed = Mth.m_14045_((int)(this.speed + 5), (int)10, (int)100);
                        break block0;
                    }
                    case "-speed": {
                        this.speed = Mth.m_14045_((int)(this.speed - 5), (int)10, (int)100);
                    }
                }
            }
        }
    }

    private IGuiTexture getIGuiTexture() {
        if (this.step == 1 && this.preview) {
            PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.checkGroup, this.checkId);
            if (!structure.preview()) {
                return IGuiTexture.EMPTY;
            }
            String pngs = structure.name() + ".png";
            ResourceLocation imageLocation = GTOCore.id((String)("textures/gui/industrial_platform_deployment_tools/" + pngs));
            return new ResourceTexture(imageLocation);
        }
        return IGuiTexture.EMPTY;
    }

    private void addDisplayTextStart(List<Component> textList) {
        if (this.canExport) {
            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.export"), (String)"export"));
        } else if (!this.presetConfirm) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.text.unselected"));
        } else if (!this.insufficient) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.material.insufficient"));
        } else if (!this.taskCompleted) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.industrial_platform_deployment_tools.doing", (Object[])new Object[]{this.progress}));
        } else {
            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.industrial_platform_deployment_tools.start"), (String)"start"));
        }
    }

    private void handleDisplayClickStart(String componentData, ClickData clickData) {
        if (componentData.equals("start")) {
            this.start();
        } else if (componentData.equals("export")) {
            this.getPlatform();
        }
    }

    private static Component createPageNavigation(int totalWidth, Component titleComp, String string) {
        Component leftBtn = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2190 ] "), (String)("previous_" + string));
        Component rightBtn = ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [ \u2192 ] "), (String)("next_" + string));
        int middleSpace = totalWidth - 60 - PlatformDeploymentMachine.widthOfString(titleComp);
        if (middleSpace <= 0) {
            return Component.m_237119_().m_7220_(leftBtn).m_7220_(titleComp).m_7220_(rightBtn);
        }
        int leftSpace = middleSpace / 2;
        int rightSpace = middleSpace - leftSpace;
        int spacePixel = 6;
        MutableComponent leftPad = Component.m_237113_((String)" ".repeat(leftSpace / spacePixel));
        MutableComponent rightPad = Component.m_237113_((String)" ".repeat(rightSpace / spacePixel));
        return Component.m_237119_().m_7220_(leftBtn).m_7220_((Component)leftPad).m_7220_(titleComp).m_7220_((Component)rightPad).m_7220_(rightBtn);
    }

    private static Component createEqualColumns(int totalWidth, Component ... components) {
        if (components.length == 0) {
            return Component.m_237119_();
        }
        int columnCount = components.length;
        int baseColWidth = totalWidth / columnCount;
        int remainder = totalWidth % columnCount;
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < columnCount; ++i) {
            Component col = components[i];
            int spacePixel = 6;
            int padPixels = baseColWidth + (i == columnCount - 1 ? remainder : 0) - PlatformDeploymentMachine.widthOfString(col);
            result = result.m_7220_(col);
            if (padPixels <= 0 || spacePixel <= 0) continue;
            result = result.m_7220_((Component)Component.m_237113_((String)" ".repeat(padPixels / spacePixel)));
        }
        return result;
    }

    private static int widthOfString(Component component) {
        return component.getString().length() * 6;
    }

    private static Component centerComponent(int totalWidth, Component component) {
        int contentWidth = 6;
        if (contentWidth >= totalWidth) {
            return component;
        }
        int leftSpace = (totalWidth - contentWidth) / 2;
        int rightSpace = totalWidth - contentWidth - leftSpace;
        MutableComponent leftPad = Component.m_237113_((String)" ".repeat(leftSpace / 6));
        MutableComponent rightPad = Component.m_237113_((String)" ".repeat(rightSpace / 6));
        return Component.m_237119_().m_7220_((Component)leftPad).m_7220_(component).m_7220_((Component)rightPad);
    }

    private PlatformBlockType.PlatformPreset getPlatformPreset(int group) {
        try {
            return this.presets.get(group);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            this.checkGroup = 0;
            this.saveGroup = 0;
            return this.presets.getFirst();
        }
    }

    private PlatformBlockType.PlatformBlockStructure getPlatformBlockStructure(int group, int id) {
        try {
            return this.getPlatformPreset(group).structures().get(id);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            this.checkId = 0;
            this.saveId = 0;
            return this.getPlatformPreset(group).structures().getFirst();
        }
    }

    private void loadingMaterial() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            block1: for (int k = 0; k < ITEM_VALUE_HOLDERS.size(); ++k) {
                for (IntObjectHolder<Item> holder : ITEM_VALUE_HOLDERS.get(k)) {
                    if (!((Item)holder.obj).equals(stack.m_41720_())) continue;
                    int n = k;
                    this.materialInventory[n] = this.materialInventory[n] + holder.number * stack.m_41613_();
                    this.inventory.setStackInSlot(i, ItemStack.f_41583_);
                    continue block1;
                }
            }
        }
    }

    private void unloadingMaterial() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            boolean filled = false;
            block1: for (int k = 0; k < ITEM_VALUE_HOLDERS.size() && !filled; ++k) {
                for (IntObjectHolder<Item> holder : ITEM_VALUE_HOLDERS.get(k)) {
                    int count = Math.min(this.materialInventory[k] / holder.number, 64);
                    if (count <= 0) continue;
                    this.inventory.setStackInSlot(i, new ItemStack((ItemLike)holder.obj, count));
                    int n = k;
                    this.materialInventory[n] = this.materialInventory[n] - holder.number * count;
                    filled = true;
                    continue block1;
                }
            }
        }
    }

    private void posChanged() {
        BlockPos pos = this.getPos();
        if (this.highlight) {
            this.highlight = false;
            this.highlightArea(false);
        }
        PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
        int sizeX = structure.xSize();
        int sizeZ = structure.zSize();
        int sizeY = structure.ySize();
        int chunkMinX = pos.m_123341_() >> 4 << 4;
        int chunkMinZ = pos.m_123343_() >> 4 << 4;
        int centerOffsetX = (sizeX - 1) / 32;
        int centerOffsetZ = (sizeZ - 1) / 32;
        int startX = chunkMinX - centerOffsetX * 16 + this.offsetX * 16;
        int startZ = chunkMinZ - centerOffsetZ * 16 + this.offsetZ * 16;
        int startY = pos.m_123342_() + this.offsetY;
        int maxX = startX + sizeX - 1;
        int maxZ = startZ + sizeZ - 1;
        int maxY = startY + sizeY - 1;
        this.pos1 = new BlockPos(startX, startY, startZ);
        this.pos2 = new BlockPos(maxX, maxY, maxZ);
    }

    private void examineMaterial() {
        if (!this.presetConfirm) {
            this.insufficient = false;
            return;
        }
        PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
        int[] costMaterial = structure.materials();
        boolean materialsSufficient = true;
        this.canExport = false;
        for (int i = 0; i < this.materialInventory.length; ++i) {
            if (this.materialInventory[i] >= costMaterial[i]) continue;
            materialsSufficient = false;
            break;
        }
        List<IntObjectHolder<ItemStack>> extraMaterials = structure.extraMaterials();
        HashMap<Item, Integer> inventoryCount = new HashMap<Item, Integer>();
        int coordinateCards = 0;
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inventoryCount.put(stack.m_41720_(), inventoryCount.getOrDefault(stack.m_41720_(), 0) + stack.m_41613_());
            if (stack.m_41720_() != GTOItems.COORDINATE_CARD.m_5456_()) continue;
            if (coordinateCards == 0) {
                this.pos1 = CoordinateCardBehavior.getStoredCoordinates(stack);
            } else {
                this.pos2 = CoordinateCardBehavior.getStoredCoordinates(stack);
            }
            ++coordinateCards;
        }
        for (IntObjectHolder<ItemStack> holder : extraMaterials) {
            Item item = ((ItemStack)holder.obj).m_41720_();
            int required = holder.number;
            int available = inventoryCount.getOrDefault(item, 0);
            if (available >= required) continue;
            materialsSufficient = false;
            break;
        }
        this.canExport = coordinateCards > 1;
        this.insufficient = materialsSufficient;
    }

    private boolean consumeResources() {
        if (!this.presetConfirm || !this.insufficient) {
            return false;
        }
        PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
        int[] costMaterial = structure.materials();
        for (int i = 0; i < this.materialInventory.length; ++i) {
            int n = i;
            this.materialInventory[n] = this.materialInventory[n] - costMaterial[i];
        }
        List<IntObjectHolder<ItemStack>> extraMaterials = structure.extraMaterials();
        for (IntObjectHolder<ItemStack> holder : extraMaterials) {
            Item item = ((ItemStack)holder.obj).m_41720_();
            int remaining = holder.number;
            for (int i = 0; i < this.inventory.getSize() && remaining > 0; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41720_() != item) continue;
                int take = Math.min(stack.m_41613_(), remaining);
                stack.m_41774_(take);
                remaining -= take;
            }
            if (remaining <= 0) continue;
            GTOCore.LOGGER.error("Failed to consume all required resources for platform deployment");
            return false;
        }
        return true;
    }

    private static int[] transform(int lx, int ly, int lz, int sx, int sz, int rot, boolean zMir, boolean xMir) {
        int rx = lx;
        int rz = lz;
        switch (rot) {
            case 90: {
                int t = rx;
                rx = sz - 1 - rz;
                rz = t;
                break;
            }
            case 180: {
                rx = sx - 1 - rx;
                rz = sz - 1 - rz;
                break;
            }
            case 270: {
                int t = rx;
                rx = rz;
                rz = sx - 1 - t;
            }
        }
        if (xMir) {
            rx = sx - 1 - rx;
        }
        if (zMir) {
            rz = sz - 1 - rz;
        }
        return new int[]{rx, ly, rz};
    }

    private static int[] calcOffsetsBy8Points(int sx, int sy, int sz, int rot, boolean zMir, boolean xMir) {
        int[][] corners = new int[][]{{0, 0, 0}, {sx - 1, 0, 0}, {0, sy - 1, 0}, {sx - 1, sy - 1, 0}, {0, 0, sz - 1}, {sx - 1, 0, sz - 1}, {0, sy - 1, sz - 1}, {sx - 1, sy - 1, sz - 1}};
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (int[] c : corners) {
            int[] t = PlatformDeploymentMachine.transform(c[0], c[1], c[2], sx, sz, rot, zMir, xMir);
            minX = Math.min(minX, t[0]);
            minY = Math.min(minY, t[1]);
            minZ = Math.min(minZ, t[2]);
        }
        return new int[]{-minX, -minY, -minZ};
    }

    private void highlightArea(boolean light) {
        if (!(this.getLevel() instanceof ServerLevel)) {
            return;
        }
        ResourceKey dimension = this.getLevel().m_46472_();
        if (this.canExport) {
            BlockPos p1 = null;
            BlockPos p2 = null;
            for (int i = 0; i < this.inventory.getSize() && (p1 == null || p2 == null); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (!stack.m_150930_(GTOItems.COORDINATE_CARD.m_5456_())) continue;
                if (p1 == null) {
                    p1 = CoordinateCardBehavior.getStoredCoordinates(stack);
                    continue;
                }
                p2 = CoordinateCardBehavior.getStoredCoordinates(stack);
            }
            if (p1 != null && p2 != null) {
                BlockPos min = new BlockPos(Math.min(p1.m_123341_(), p2.m_123341_()), Math.min(p1.m_123342_(), p2.m_123342_()), Math.min(p1.m_123343_(), p2.m_123343_()));
                BlockPos max = new BlockPos(Math.max(p1.m_123341_(), p2.m_123341_()), Math.max(p1.m_123342_(), p2.m_123342_()), Math.max(p1.m_123343_(), p2.m_123343_()));
                if (light) {
                    PlatformDeploymentMachine.highlightRegion((ResourceKey<Level>)dimension, min, max, 1711315404, 1200);
                } else {
                    PlatformDeploymentMachine.stopHighlight(min, max);
                }
            }
            return;
        }
        if (!this.presetConfirm) {
            return;
        }
        PlatformBlockType.PlatformBlockStructure struct = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
        int sx = struct.xSize();
        int sy = struct.ySize();
        int sz = struct.zSize();
        BlockPos start = this.pos1;
        boolean zMir = this.xMirror;
        boolean xMir = this.zMirror;
        int rot = this.rotation;
        int[] offsets = PlatformDeploymentMachine.calcOffsetsBy8Points(sx, sy, sz, rot, zMir, xMir);
        int ox = offsets[0];
        int oy = offsets[1];
        int oz = offsets[2];
        int[][] corners = new int[][]{{0, 0, 0}, {sx - 1, 0, 0}, {0, sy - 1, 0}, {sx - 1, sy - 1, 0}, {0, 0, sz - 1}, {sx - 1, 0, sz - 1}, {0, sy - 1, sz - 1}, {sx - 1, sy - 1, sz - 1}};
        int minWX = Integer.MAX_VALUE;
        int minWY = Integer.MAX_VALUE;
        int minWZ = Integer.MAX_VALUE;
        int maxWX = Integer.MIN_VALUE;
        int maxWY = Integer.MIN_VALUE;
        int maxWZ = Integer.MIN_VALUE;
        for (int[] c : corners) {
            int[] t = PlatformDeploymentMachine.transform(c[0], c[1], c[2], sx, sz, rot, zMir, xMir);
            int wx = start.m_123341_() + t[0] + ox;
            int wy = start.m_123342_() + t[1] + oy;
            int wz = start.m_123343_() + t[2] + oz;
            minWX = Math.min(minWX, wx);
            maxWX = Math.max(maxWX, wx);
            minWY = Math.min(minWY, wy);
            maxWY = Math.max(maxWY, wy);
            minWZ = Math.min(minWZ, wz);
            maxWZ = Math.max(maxWZ, wz);
        }
        BlockPos minPos = new BlockPos(minWX, minWY, minWZ);
        BlockPos maxPos = new BlockPos(maxWX, maxWY, maxWZ);
        if (light) {
            PlatformDeploymentMachine.highlightRegion((ResourceKey<Level>)dimension, minPos, maxPos, 0x2277FF77, 600);
        } else {
            PlatformDeploymentMachine.stopHighlight(minPos, maxPos);
        }
    }

    private void start() {
        if (!this.taskCompleted) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.consumeResources()) {
            return;
        }
        this.posChanged();
        PlatformBlockType.PlatformBlockStructure structure = this.getPlatformBlockStructure(this.saveGroup, this.saveId);
        this.progress = 0;
        this.taskCompleted = false;
        try {
            PlatformStructurePlacer.placeStructureAsync((Level)serverLevel, this.pos1, structure, this.speed * 1000, true, this.skipAir, this.updateLight, this.zMirror, this.xMirror, this.rotation, progress -> {
                this.progress = progress;
            }, () -> {
                this.taskCompleted = true;
            });
        }
        catch (IOException e) {
            GTOCore.LOGGER.error("The industrial platform deployment tool cannot deploy the platform, platform error {} {}, file location {}", new Object[]{this.getPlatformPreset(this.saveGroup).name(), structure.name(), structure.resource()});
            this.taskCompleted = true;
        }
        this.examineMaterial();
    }

    private void getPlatform() {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos1 = null;
        BlockPos pos2 = null;
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41720_() != GTOItems.COORDINATE_CARD.m_5456_()) continue;
            if (pos1 == null) {
                pos1 = CoordinateCardBehavior.getStoredCoordinates(stack);
                continue;
            }
            pos2 = CoordinateCardBehavior.getStoredCoordinates(stack);
        }
        if (pos1 != null && pos2 != null) {
            PlatformCreators.PlatformCreationAsync(serverLevel, pos1, pos2, this.xMirror, this.zMirror, this.rotation);
        }
    }
}

