/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.eio_travel.ITravelTarget;
import com.gtocore.eio_travel.api.TravelSavedData;
import com.gtocore.eio_travel.implementations.AnchorTravelTarget;
import com.gtolib.utils.holder.ObjectHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class TravelAnchorMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife {
    @Persisted
    private final ItemStackTransfer itemTransfer = new ItemStackTransfer();

    public TravelAnchorMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.itemTransfer.setOnContentsChanged(this::onInventoryContentsChanged);
    }

    public void onMachineRemoved() {
        super.onMachineRemoved();
        if (this.getLevel() != null) {
            TravelSavedData.getTravelData(this.getLevel()).removeTravelTargetAt(this.getLevel(), this.getPos());
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 140, 100);
        LabelWidget setNameLabel = new LabelWidget(14, 8, "ftblibrary.select_item.display_name");
        group.addWidget((Widget)setNameLabel);
        TextFieldWidget textInputWidget = new TextFieldWidget().setTextSupplier(this::getName).setTextResponder(this::setName);
        textInputWidget.setSelfPosition(14, 20);
        group.addWidget((Widget)textInputWidget);
        ToggleButtonWidget toggleButton = this.createToggleButton();
        toggleButton.setSelfPosition(110, 20);
        group.addWidget((Widget)toggleButton);
        Size size = group.getSize();
        LabelWidget setIconLabel = new LabelWidget(14, size.height - 30, "ftbquests.icon");
        group.addWidget((Widget)setIconLabel);
        PhantomSlotWidget slot = new PhantomSlotWidget((IItemTransfer)this.itemTransfer, 0, size.width - 30, size.height - 30);
        slot.setMaxStackSize(1);
        slot.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
        group.addWidget((Widget)slot);
        return group;
    }

    private void onInventoryContentsChanged() {
        ItemStack stack = this.itemTransfer.getStackInSlot(0);
        this.setIcon(stack.m_41720_());
    }

    @Nullable
    public String getName() {
        return this.getOrCreateTravelTarget().getName();
    }

    public void setName(String name) {
        this.getOrCreateTravelTarget().setName(name);
    }

    public Item getIcon() {
        return this.getOrCreateTravelTarget().getIcon();
    }

    public void setIcon(Item icon) {
        this.getOrCreateTravelTarget().setIcon(icon);
    }

    public boolean getVisibility() {
        return this.getOrCreateTravelTarget().getVisibility();
    }

    public void setVisibility(boolean visible) {
        this.getOrCreateTravelTarget().setVisibility(visible);
    }

    private AnchorTravelTarget getOrCreateTravelTarget() {
        ITravelTarget iTravelTarget;
        BlockPos worldPosition = this.getPos();
        Optional<ITravelTarget> travelTarget = this.getTravelData().getTravelTarget(worldPosition);
        if (travelTarget.isPresent() && (iTravelTarget = travelTarget.get()) instanceof AnchorTravelTarget) {
            AnchorTravelTarget anchorTravelTarget = (AnchorTravelTarget)iTravelTarget;
            return anchorTravelTarget;
        }
        AnchorTravelTarget anchorTravelTarget = new AnchorTravelTarget(worldPosition, "", Items.f_41852_, false);
        this.getTravelData().addTravelTarget(this.getLevel(), anchorTravelTarget);
        return anchorTravelTarget;
    }

    public TravelSavedData getTravelData() {
        return TravelSavedData.getTravelData(this.getLevel());
    }

    private ToggleButtonWidget createToggleButton() {
        ObjectHolder toggleHolder = new ObjectHolder(null);
        ToggleButtonWidget toggleButton = new ToggleButtonWidget(0, 40, 16, 16, this::getVisibility, pressed -> {
            this.setVisibility(pressed);
            if (LDLib.isRemote()) {
                ((ToggleButtonWidget)toggleHolder.value).setHoverTooltips(new Component[]{this.getConfigureLevelsOrPointsTooltip(pressed)});
            }
        });
        toggleHolder.value = toggleButton;
        toggleButton.setPressed(this.getVisibility());
        toggleButton.setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GTOGuiTextures.SMALL_XP_ORB}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GTOGuiTextures.LARGE_XP_ORB.scale(0.8f)}));
        toggleButton.setHoverTooltips(new Component[]{this.getConfigureLevelsOrPointsTooltip(this.getVisibility())});
        return toggleButton;
    }

    private Component getConfigureLevelsOrPointsTooltip(boolean pressed) {
        return Component.m_237115_((String)("emi.header." + (pressed ? "visible" : "invisible")));
    }
}

