/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CombinedDirectionalFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.translation.GTOMachineTooltips;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VillageTradingStationMachine
extends MetaMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineLife {
    private TickableSubscription tickSubs;
    @Nullable
    private TickableSubscription autoOutputSubs;
    @Nullable
    private ISubscription exportItemSubs;
    @Persisted
    private final NotifiableItemStackHandler input;
    @Persisted
    private final NotifiableItemStackHandler output;
    @Persisted
    @DescSynced
    private final VillageHolder villagers;
    @Persisted
    @DescSynced
    private final boolean[] isLocked = new boolean[10];
    @Persisted
    @DescSynced
    private final int[] selected = new int[10];
    @Persisted
    @DescSynced
    private final boolean[] startUp = new boolean[10];
    private final VillagerRecipe[][] villagersDataset = new VillagerRecipe[10][];
    private final ItemStackHandler RecipesHandler = new ItemStackHandler(30);
    @Persisted
    private final CustomItemStackHandler upgrade;
    @Persisted
    private final CustomItemStackHandler enhance;
    private static final Item[] FIELD_GENERATOR = new Item[]{GTItems.FIELD_GENERATOR_LV.m_5456_(), GTItems.FIELD_GENERATOR_MV.m_5456_(), GTItems.FIELD_GENERATOR_HV.m_5456_(), GTItems.FIELD_GENERATOR_EV.m_5456_(), GTItems.FIELD_GENERATOR_IV.m_5456_(), GTItems.FIELD_GENERATOR_LuV.m_5456_(), GTItems.FIELD_GENERATOR_ZPM.m_5456_(), GTItems.FIELD_GENERATOR_UV.m_5456_()};
    @Persisted
    private int replenishmentInterval = 2400;
    @Persisted
    private int tradingMultiple = 1;
    @Persisted
    private int tire = 0;
    private static final Map<Item, Integer> ENHANCE_INDEX_MAP = Map.ofEntries(Map.entry(GTMachines.WORLD_ACCELERATOR[1].asItem(), 1), Map.entry(GTMachines.WORLD_ACCELERATOR[2].asItem(), 2), Map.entry(GTMachines.WORLD_ACCELERATOR[3].asItem(), 3), Map.entry(GTMachines.WORLD_ACCELERATOR[4].asItem(), 4), Map.entry(GTMachines.WORLD_ACCELERATOR[5].asItem(), 5), Map.entry(GTMachines.WORLD_ACCELERATOR[6].asItem(), 6), Map.entry(GTMachines.WORLD_ACCELERATOR[7].asItem(), 7), Map.entry(GTMachines.WORLD_ACCELERATOR[8].asItem(), 8), Map.entry(GTOItems.INTEGRATED_CONTROL_CORE_UV.m_5456_(), 9), Map.entry(GTOItems.INTEGRATED_CONTROL_CORE_UHV.m_5456_(), 10), Map.entry(GTOItems.INTEGRATED_CONTROL_CORE_UEV.m_5456_(), 11), Map.entry(GTOItems.INTEGRATED_CONTROL_CORE_UIV.m_5456_(), 12));
    private static final Item[] ENHANCE_ITEMS = new Item[]{Items.f_41852_, GTMachines.WORLD_ACCELERATOR[1].asItem(), GTMachines.WORLD_ACCELERATOR[2].asItem(), GTMachines.WORLD_ACCELERATOR[3].asItem(), GTMachines.WORLD_ACCELERATOR[4].asItem(), GTMachines.WORLD_ACCELERATOR[5].asItem(), GTMachines.WORLD_ACCELERATOR[6].asItem(), GTMachines.WORLD_ACCELERATOR[7].asItem(), GTMachines.WORLD_ACCELERATOR[8].asItem(), GTOItems.INTEGRATED_CONTROL_CORE_UV.m_5456_(), GTOItems.INTEGRATED_CONTROL_CORE_UHV.m_5456_(), GTOItems.INTEGRATED_CONTROL_CORE_UEV.m_5456_(), GTOItems.INTEGRATED_CONTROL_CORE_UIV.m_5456_()};
    private static final Item VILLAGER_ITEM = RegistriesUtils.getItem((String)"easy_villagers:villager");
    private int replenishment;
    private int executeTrades;
    @Persisted
    @DescSynced
    @RequireRerender
    private Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean autoOutputItems;
    @Persisted
    private boolean allowInputFromOutputSideItems;

    public VillageTradingStationMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.input = new NotifiableItemStackHandler((MetaMachine)this, 256, IO.IN, IO.IN);
        this.output = new NotifiableItemStackHandler((MetaMachine)this, 256, IO.OUT, IO.OUT);
        this.villagers = new VillageHolder(this);
        this.upgrade = new CustomItemStackHandler();
        this.enhance = new CustomItemStackHandler();
        this.enhance.setOnContentsChanged(() -> {
            this.tire = ENHANCE_INDEX_MAP.getOrDefault(this.enhance.getStackInSlot(0).m_41720_(), 0);
            if (this.tire < 9) {
                this.replenishmentInterval = 2400 - 225 * this.tire;
                this.tradingMultiple = 1;
            } else {
                this.replenishmentInterval = 600;
                this.tradingMultiple = (this.tire - 8) * 4;
            }
        });
        this.outputFacingItems = this.hasFrontFacing() ? this.getFrontFacing().m_122424_() : Direction.DOWN;
    }

    public void onLoad() {
        super.onLoad();
        this.input.notifyListeners();
        this.output.notifyListeners();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 100);
            this.exportItemSubs = this.output.addChangedListener(this::updateAutoOutputSubscription);
        }
        for (int i = 0; i < 10; ++i) {
            this.incomingVillagersDataset(i);
            this.selectedRecipes(i);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
        }
        if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
        }
    }

    private void tickUpdate() {
        if (this.tickSubs.lastTick > this.replenishment) {
            this.villagersRestock();
            this.replenishment = this.tickSubs.lastTick + this.replenishmentInterval;
        }
        if (this.tickSubs.lastTick > this.executeTrades) {
            this.executeTrades = this.tickSubs.lastTick + 200;
            for (int slot = 0; slot < 9; ++slot) {
                this.executeTrades(slot);
            }
        }
    }

    private void executeTrades(int slot) {
        if (!this.isLocked(slot) || !this.isStartUp(slot) || this.villagersDataset[slot] == null || this.villagersDataset[slot].length == 0) {
            return;
        }
        VillagerRecipe[] recipes = this.villagersDataset[slot];
        if (this.selected[slot] >= recipes.length) {
            return;
        }
        VillagerRecipe trade = recipes[this.selected[slot]];
        int remainingUses = trade.maxUses - trade.uses;
        if (remainingUses <= 0) {
            return;
        }
        int maxPossibleTrades = this.getMaxPossibleTrades((IItemHandlerModifiable)this.input, trade.buy, trade.buyB);
        if (maxPossibleTrades <= 0) {
            return;
        }
        int actualTrades = Math.min(maxPossibleTrades / this.tradingMultiple, remainingUses) * this.tradingMultiple;
        if (actualTrades <= 0) {
            return;
        }
        this.deductItems((IItemHandlerModifiable)this.input, trade.buy, actualTrades);
        if (!trade.buyB.m_41619_()) {
            this.deductItems((IItemHandlerModifiable)this.input, trade.buyB, actualTrades);
        }
        ItemStack outputStack = trade.sell.m_41777_();
        outputStack.m_41764_(trade.sell.m_41613_() * actualTrades);
        this.addItems((IItemHandlerModifiable)this.output, outputStack);
        this.villagersDataset[slot][this.selected[slot]].uses += actualTrades / this.tradingMultiple;
        this.syncUsesAndMaxUsesToVillagerItem(slot);
    }

    private int getMaxPossibleTrades(IItemHandlerModifiable input, ItemStack buy, ItemStack buyB) {
        int totalBuy = 0;
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack stack = input.getStackInSlot(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)buy)) continue;
            totalBuy += stack.m_41613_();
        }
        int maxByBuy = buy.m_41613_() > 0 ? totalBuy / buy.m_41613_() : Integer.MAX_VALUE;
        int maxByBuyB = Integer.MAX_VALUE;
        if (!buyB.m_41619_() && buyB.m_41613_() > 0) {
            int totalBuyB = 0;
            for (int i = 0; i < input.getSlots(); ++i) {
                ItemStack stack = input.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)buyB)) continue;
                totalBuyB += stack.m_41613_();
            }
            maxByBuyB = totalBuyB / buyB.m_41613_();
        }
        return Math.min(Math.min(maxByBuy, maxByBuyB), 128);
    }

    private void deductItems(IItemHandlerModifiable handler, ItemStack target, int count) {
        if (target.m_41619_() || count <= 0) {
            return;
        }
        int remaining = target.m_41613_() * count;
        for (int i = 0; i < handler.getSlots() && remaining > 0; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)target)) continue;
            int take = Math.min(stack.m_41613_(), remaining);
            stack.m_41774_(take);
            if (stack.m_41619_()) {
                handler.setStackInSlot(i, ItemStack.f_41583_);
            }
            remaining -= take;
        }
    }

    private void addItems(IItemHandlerModifiable handler, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemStack remaining = stack.m_41777_();
        int maxStackSize = remaining.m_41741_();
        for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
            ItemStack existing = handler.getStackInSlot(i);
            if (existing.m_41619_() || !ItemStack.m_150942_((ItemStack)existing, (ItemStack)remaining) || existing.m_41613_() >= maxStackSize) continue;
            int addAmount = Math.min(remaining.m_41613_(), maxStackSize - existing.m_41613_());
            existing.m_41769_(addAmount);
            remaining.m_41774_(addAmount);
        }
        while (!remaining.m_41619_()) {
            boolean foundSlot = false;
            for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                if (!handler.getStackInSlot(i).m_41619_()) continue;
                int putAmount = Math.min(remaining.m_41613_(), maxStackSize);
                ItemStack toPut = remaining.m_41777_();
                toPut.m_41764_(putAmount);
                handler.setStackInSlot(i, toPut);
                remaining.m_41774_(putAmount);
                foundSlot = true;
            }
            if (foundSlot) continue;
            break;
        }
    }

    private boolean isLocked(int slot) {
        return this.isLocked[slot];
    }

    public void setLocked(int slot) {
        this.isLocked[slot] = !this.isLocked[slot];
        this.selected[slot] = 0;
        if (this.isLocked[slot]) {
            this.incomingVillagersDataset(slot);
        } else {
            this.syncUsesAndMaxUsesToVillagerItem(slot);
            this.villagersDataset[slot] = null;
            this.setStartUp(slot);
        }
        this.selectedRecipes(slot);
    }

    private void selectedNext(int slot) {
        if (!this.isLocked(slot) || this.isStartUp(slot)) {
            return;
        }
        VillagerRecipe[] recipes = this.villagersDataset[slot];
        if (recipes != null && recipes.length > 0) {
            this.selected[slot] = (this.selected[slot] + 1) % recipes.length;
            this.selectedRecipes(slot);
        } else {
            this.isLocked[slot] = false;
        }
    }

    private boolean isStartUp(int slot) {
        return this.startUp[slot];
    }

    private void setStartUp(int slot) {
        if (this.isLocked(slot)) {
            this.startUp[slot] = !this.startUp[slot];
            VillagerRecipe[] recipes = this.villagersDataset[slot];
            if (recipes == null || recipes.length == 0) {
                this.startUp[slot] = false;
            }
            if (this.startUp[slot]) {
                this.executeTrades(slot);
            }
        } else {
            this.startUp[slot] = false;
        }
    }

    private void incomingVillagersDataset(int slot) {
        ItemStack villager = this.villagers.getStackInSlot(slot);
        if (!villager.m_41619_() && this.isLocked[slot]) {
            List<VillagerRecipe> recipeList = this.parseTradeData(villager.m_41784_());
            CompoundTag villagerCoreNbt = villager.m_41784_().m_128469_("villager");
            CompoundTag offersTag = villagerCoreNbt.m_128469_("Offers");
            ListTag nbtRecipes = offersTag.m_128437_("Recipes", 10);
            if (recipeList.size() != nbtRecipes.size()) {
                recipeList = recipeList.subList(0, Math.min(recipeList.size(), nbtRecipes.size()));
            }
            this.villagersDataset[slot] = recipeList.toArray(new VillagerRecipe[0]);
        } else {
            this.villagersDataset[slot] = null;
            this.isLocked[slot] = false;
        }
    }

    private void selectedRecipes(int slot) {
        VillagerRecipe[] recipes = this.villagersDataset[slot];
        if (recipes != null && this.isLocked(slot) && recipes.length > 0 && this.selected[slot] < recipes.length) {
            VillagerRecipe recipe = recipes[this.selected[slot]];
            this.RecipesHandler.setStackInSlot(slot * 3, recipe.buy.m_41777_());
            this.RecipesHandler.setStackInSlot(slot * 3 + 1, recipe.buyB.m_41777_());
            this.RecipesHandler.setStackInSlot(slot * 3 + 2, recipe.sell.m_41777_());
        } else {
            this.clearRecipeSlots(slot);
        }
    }

    private void clearRecipeSlots(int slot) {
        this.RecipesHandler.setStackInSlot(slot * 3, ItemStack.f_41583_);
        this.RecipesHandler.setStackInSlot(slot * 3 + 1, ItemStack.f_41583_);
        this.RecipesHandler.setStackInSlot(slot * 3 + 2, ItemStack.f_41583_);
    }

    public Widget createUIWidget() {
        int width = 336;
        int height = 144;
        WidgetGroup group = new WidgetGroup(0, 0, 344, 152);
        DraggableScrollableWidgetGroup groupTitle = new DraggableScrollableWidgetGroup(4, 4, 336, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
        groupTitle.addWidget((Widget)new ComponentPanelWidget(4, 5, textList -> GTOMachineTooltips.INSTANCE.getVillageTradingStationIntroduction().apply((List<Component>)textList)).setMaxWidthLimit(328));
        group.addWidget((Widget)groupTitle);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setMainTab((IFancyUIProvider)this);
        sideTabs.attachSubTab(new IFancyUIProvider(){
            static final int width = 192;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return new ItemStackTexture(new Item[]{VILLAGER_ITEM});
            }

            public Component getTitle() {
                return Component.m_237115_((String)VillageTradingStationMachine.this.getDefinition().getDescriptionId());
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                WidgetGroup group = new WidgetGroup(0, 0, 200, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 192, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                mainGroup.addWidget((Widget)this.getVillagerGroups());
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }

            @NotNull
            private WidgetGroup getVillagerGroups() {
                int xSize = 18;
                int groupXSize = xSize * 9;
                int startX = (192 - groupXSize) / 2;
                int startY = 16;
                WidgetGroup group = new WidgetGroup(startX, startY, groupXSize, 128);
                for (int i = 0; i < 9; ++i) {
                    group.addWidget((Widget)VillageTradingStationMachine.this.VillagerGroup(i, i * xSize));
                }
                return group;
            }
        });
        sideTabs.attachSubTab(new IFancyUIProvider(){
            static final int width = 192;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return new ItemStackTexture(new Item[]{VILLAGER_ITEM});
            }

            public Component getTitle() {
                return Component.m_237119_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                WidgetGroup group = new WidgetGroup(0, 0, 200, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 192, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                WidgetGroup villagerGroups = new WidgetGroup(15, 16, 162, 128);
                villagerGroups.addWidget((Widget)VillageTradingStationMachine.this.VillagerGroup(9, 0));
                mainGroup.addWidget((Widget)villagerGroups);
                mainGroup.addWidget((Widget)this.getUpgradeGroup());
                mainGroup.addWidget((Widget)this.getEnhanceGroup());
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }

            @NotNull
            private WidgetGroup getUpgradeGroup() {
                WidgetGroup villagerGroup = new WidgetGroup(37, 97, 150, 50);
                VillagerRecipe[] recipes = VillageTradingStationMachine.this.villagersDataset[9];
                villagerGroup.addWidget((Widget)new ComponentPanelWidget(20, 0, textList -> {
                    if (recipes != null && VillageTradingStationMachine.this.isLocked(9) && recipes.length > 0 && VillageTradingStationMachine.this.selected[9] < recipes.length) {
                        int upGread = recipes[VillageTradingStationMachine.this.selected[9]].maxUses / 32;
                        if (recipes[VillageTradingStationMachine.this.selected[9]].maxUses < 256) {
                            ItemStack item = FIELD_GENERATOR[upGread].m_7968_();
                            int count = Math.min(VillageTradingStationMachine.this.getMaxPossibleTrades((IItemHandlerModifiable)VillageTradingStationMachine.this.upgrade, item, ItemStack.f_41583_), (upGread + 1) * 32 - recipes[VillageTradingStationMachine.this.selected[9]].maxUses);
                            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("[ + " + count + " \u2192 " + (recipes[VillageTradingStationMachine.this.selected[9]].maxUses + count) + " ]")), (String)"add_max_uses"));
                            textList.add(Component.m_237110_((String)"gtocore.machine.village_trading_station.increase", (Object[])new Object[]{item.m_41611_()}));
                        } else {
                            textList.add(Component.m_237119_());
                            textList.add(Component.m_237115_((String)"gtocore.machine.village_trading_station.upper_limit"));
                        }
                    }
                }).clickHandler((a2, b2) -> {
                    if (recipes != null && VillageTradingStationMachine.this.isLocked(9) && recipes.length > 0 && VillageTradingStationMachine.this.selected[9] < recipes.length) {
                        ItemStack item;
                        int count;
                        int upGread = recipes[VillageTradingStationMachine.this.selected[9]].maxUses / 32;
                        if (recipes[VillageTradingStationMachine.this.selected[9]].maxUses < 256 && (count = Math.min(VillageTradingStationMachine.this.getMaxPossibleTrades((IItemHandlerModifiable)VillageTradingStationMachine.this.upgrade, item = FIELD_GENERATOR[upGread].m_7968_(), ItemStack.f_41583_), (upGread + 1) * 32 - recipes[VillageTradingStationMachine.this.selected[9]].maxUses)) > 0) {
                            VillageTradingStationMachine.this.deductItems((IItemHandlerModifiable)VillageTradingStationMachine.this.upgrade, item, count);
                            VillageTradingStationMachine.this.villagersDataset[9][VillageTradingStationMachine.this.selected[9]].maxUses += count;
                            VillageTradingStationMachine.this.syncUsesAndMaxUsesToVillagerItem(9);
                        }
                    }
                }).setMaxWidthLimit(120));
                villagerGroup.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)VillageTradingStationMachine.this.upgrade, 0, 0, 0).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
                return villagerGroup;
            }

            @NotNull
            private WidgetGroup getEnhanceGroup() {
                WidgetGroup villagerGroup = new WidgetGroup(37, 25, 150, 100);
                villagerGroup.addWidget((Widget)new ComponentPanelWidget(0, 9, textList -> {
                    if (VillageTradingStationMachine.this.tire < 12) {
                        textList.add(Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237110_((String)"gtocore.machine.village_trading_station.enhance", (Object[])new Object[]{ENHANCE_ITEMS[VillageTradingStationMachine.this.tire + 1].m_7968_().m_41611_()})));
                    } else {
                        textList.add(Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237115_((String)"gtocore.machine.village_trading_station.upper_limit")));
                    }
                    textList.add(Component.m_237110_((String)"gtocore.machine.village_trading_station.replenishment_interval", (Object[])new Object[]{VillageTradingStationMachine.this.replenishmentInterval}));
                    textList.add(Component.m_237110_((String)"gtocore.machine.village_trading_station.trading_multiple", (Object[])new Object[]{VillageTradingStationMachine.this.tradingMultiple}));
                }).setMaxWidthLimit(120));
                villagerGroup.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)VillageTradingStationMachine.this.enhance, 0, 0, 0).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
                return villagerGroup;
            }
        });
        sideTabs.attachSubTab((IFancyUIProvider)CombinedDirectionalFancyConfigurator.of((MetaMachine)this, (MetaMachine)this));
    }

    @NotNull
    private WidgetGroup VillagerGroup(int slot, int X) {
        WidgetGroup villagerGroup = new WidgetGroup(X, 0, 18, 128);
        villagerGroup.setLayout(Layout.VERTICAL_CENTER);
        villagerGroup.addWidget((Widget)new ComponentPanelWidget(0, 2, textList -> textList.add(ComponentPanelWidget.withButton((Component)(this.isLocked(slot) ? Component.m_237113_((String)"\ud83d\udd12") : Component.m_237113_((String)"\ud83d\udd13")), (String)String.valueOf(slot)))).clickHandler((a2, b2) -> this.setLocked(Integer.parseInt(a2))));
        villagerGroup.addWidget(new SlotWidget((IItemHandlerModifiable)this.villagers, slot, 0, 12, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
        for (int j = 0; j < 3; ++j) {
            SlotWidget itemWidget = new SlotWidget((IItemHandlerModifiable)this.RecipesHandler, 3 * slot + j, 0, 18 * (j + 2) - 6).setCanPutItems(false).setCanTakeItems(false).setBackgroundTexture((IGuiTexture)GTOGuiTextures.VILLAGER_RECIPE_SLOTS[j]);
            villagerGroup.addWidget((Widget)itemWidget);
        }
        villagerGroup.addWidget((Widget)new ComponentPanelWidget(0, 86, textList -> textList.add(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"\ud83d\udd01"), (String)String.valueOf(slot)))).clickHandler((a2, b2) -> this.selectedNext(Integer.parseInt(a2))));
        villagerGroup.addWidget((Widget)new ComponentPanelWidget(0, 98, textList -> textList.add(ComponentPanelWidget.withButton((Component)(this.isStartUp(slot) ? Component.m_237113_((String)"\ud83d\udd12") : Component.m_237113_((String)"\ud83d\udd13")), (String)String.valueOf(slot)))).clickHandler((a2, b2) -> this.setStartUp(Integer.parseInt(a2))));
        villagerGroup.addWidget((Widget)new ComponentPanelWidget(0, 110, textList -> {
            VillagerRecipe[] recipes = this.villagersDataset[slot];
            if (recipes != null && this.isLocked(slot) && recipes.length > 0 && this.selected[slot] < recipes.length) {
                VillagerRecipe recipe = recipes[this.selected[slot]];
                textList.add(Component.m_237113_((String)String.valueOf(recipe.uses)));
                textList.add(Component.m_237113_((String)String.valueOf(recipe.maxUses)));
            } else {
                textList.add(Component.m_237113_((String)"0"));
                textList.add(Component.m_237113_((String)"0"));
            }
        }));
        return villagerGroup;
    }

    private List<VillagerRecipe> parseTradeData(CompoundTag originalOuterNbt) {
        ArrayList<VillagerRecipe> recipes = new ArrayList<VillagerRecipe>();
        if (!originalOuterNbt.m_128425_("villager", 10)) {
            return recipes;
        }
        CompoundTag villagerCoreNbt = originalOuterNbt.m_128469_("villager");
        if (!villagerCoreNbt.m_128425_("Offers", 10)) {
            return recipes;
        }
        CompoundTag offersTag = villagerCoreNbt.m_128469_("Offers");
        if (!offersTag.m_128425_("Recipes", 9)) {
            return recipes;
        }
        ListTag recipesList = offersTag.m_128437_("Recipes", 10);
        for (int i = 0; i < recipesList.size(); ++i) {
            CompoundTag recipeTag = recipesList.m_128728_(i);
            ItemStack buy = VillageTradingStationMachine.parseItemStack(recipeTag.m_128469_("buy"));
            ItemStack buyB = VillageTradingStationMachine.parseItemStack(recipeTag.m_128469_("buyB"));
            ItemStack sell = VillageTradingStationMachine.parseItemStack(recipeTag.m_128469_("sell"));
            int maxUses = recipeTag.m_128451_("maxUses");
            int uses = recipeTag.m_128451_("uses");
            recipes.add(new VillagerRecipe(buy, buyB, sell, maxUses, uses));
        }
        return recipes;
    }

    private static ItemStack parseItemStack(CompoundTag itemTag) {
        String itemId = itemTag.m_128461_("id");
        ItemStack item = RegistriesUtils.getItemStack((String)itemId);
        if (item.m_41720_().equals(Items.f_41852_)) {
            return ItemStack.f_41583_;
        }
        int count = Math.max(1, itemTag.m_128445_("Count"));
        item.m_41764_(count);
        return item;
    }

    private void villagersRestock() {
        for (int slot = 0; slot < 10; ++slot) {
            VillagerRecipe[] recipes = this.villagersDataset[slot];
            if (recipes == null) continue;
            for (VillagerRecipe recipe : recipes) {
                if (recipe == null) continue;
                recipe.uses = 0;
            }
        }
    }

    private void syncUsesAndMaxUsesToVillagerItem(int slot) {
        VillagerRecipe[] datasetRecipes = this.villagersDataset[slot];
        ItemStack villagerStack = this.villagers.getStackInSlot(slot);
        if (villagerStack.m_41619_() || !villagerStack.m_41720_().equals(VILLAGER_ITEM) || datasetRecipes == null || datasetRecipes.length == 0) {
            return;
        }
        CompoundTag outerNbt = VillageTradingStationMachine.getCompoundTag(villagerStack, datasetRecipes);
        villagerStack.m_41751_(outerNbt);
        boolean wasLocked = this.isLocked[slot];
        if (wasLocked) {
            this.isLocked[slot] = false;
        }
        this.villagers.setStackInSlot(slot, villagerStack);
        if (wasLocked) {
            this.isLocked[slot] = true;
        }
    }

    @NotNull
    private static CompoundTag getCompoundTag(ItemStack villagerStack, VillagerRecipe[] datasetRecipes) {
        CompoundTag outerNbt = villagerStack.m_41784_();
        CompoundTag villagerCoreNbt = outerNbt.m_128469_("villager");
        CompoundTag offersTag = villagerCoreNbt.m_128469_("Offers");
        ListTag recipesList = offersTag.m_128437_("Recipes", 10);
        int syncCount = Math.min(datasetRecipes.length, recipesList.size());
        for (int i = 0; i < syncCount; ++i) {
            VillagerRecipe datasetRecipe = datasetRecipes[i];
            CompoundTag nbtRecipe = recipesList.m_128728_(i);
            nbtRecipe.m_128405_("uses", datasetRecipe.uses);
            nbtRecipe.m_128405_("maxUses", datasetRecipe.maxUses);
            recipesList.set(i, (Tag)nbtRecipe);
        }
        offersTag.m_128365_("Recipes", (Tag)recipesList);
        villagerCoreNbt.m_128365_("Offers", (Tag)offersTag);
        outerNbt.m_128365_("villager", (Tag)villagerCoreNbt);
        return outerNbt;
    }

    @Nullable
    public Direction getOutputFacingItems() {
        if (this.hasAutoOutputItem()) {
            return this.outputFacingItems;
        }
        return null;
    }

    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        if (this.hasAutoOutputItem()) {
            this.clearDirectionCache();
            this.outputFacingItems = outputFacing;
            this.updateAutoOutputSubscription();
        }
    }

    public void setAutoOutputItems(boolean allow) {
        if (this.hasAutoOutputItem()) {
            this.autoOutputItems = allow;
            this.updateAutoOutputSubscription();
        }
    }

    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.clearDirectionCache();
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    private void updateAutoOutputSubscription() {
        if (this.getLevel() == null) {
            return;
        }
        Direction outputFacing = this.getOutputFacingItems();
        if (this.autoOutputItems && !this.output.isEmpty() && outputFacing != null && this.blockEntityDirectionCache.hasAdjacentItemHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput, 20);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    private void autoOutput() {
        if (this.autoOutputItems && this.getOutputFacingItems() != null) {
            this.output.exportToNearby(new Direction[]{this.getOutputFacingItems()});
        }
        this.updateAutoOutputSubscription();
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.input.storage);
        this.clearInventory((IItemHandlerModifiable)this.output.storage);
        this.clearInventory((IItemHandlerModifiable)this.villagers);
        this.clearInventory((IItemHandlerModifiable)this.upgrade);
        this.clearInventory((IItemHandlerModifiable)this.enhance);
    }

    private static class VillagerRecipe {
        private final ItemStack buy;
        private final ItemStack buyB;
        private final ItemStack sell;
        private int maxUses;
        private int uses;

        private VillagerRecipe(ItemStack buy, ItemStack buyB, ItemStack sell, int maxUses, int uses) {
            this.buy = buy;
            this.buyB = buyB;
            this.sell = sell;
            this.maxUses = maxUses;
            this.uses = uses;
        }
    }

    private static class VillageHolder
    extends CustomItemStackHandler {
        private final VillageTradingStationMachine machine;

        private VillageHolder(VillageTradingStationMachine machine) {
            super(10);
            this.machine = machine;
            this.setFilter(i -> i.m_41720_().equals(VILLAGER_ITEM));
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.machine.isLocked(slot)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (this.machine.isLocked(slot)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

