/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.ExternalStorageFacade;
import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gtocore.common.machine.tesseract.IMultiTesseract;
import com.gtocore.common.machine.tesseract.TesseractDirectedTarget;
import com.gtolib.api.ae2.AEKeyTypeMap;
import com.gtolib.api.ae2.IPatternProviderLogic;
import com.gtolib.api.ae2.PatternProviderTargetCache;
import com.gtolib.api.ae2.machine.ICustomCraftingMachine;
import com.gtolib.utils.ServerUtils;
import com.gtolib.utils.holder.BooleanHolder;
import com.gtolib.utils.holder.ObjectHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DirectedTesseractMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife,
ICustomCraftingMachine,
IMultiTesseract {
    public static final Multiset<ImmutableList<TesseractDirectedTarget>> HIGHLIGHTS = HashMultiset.create();
    private final List<IItemHandler> itemHandlers = new ArrayList<IItemHandler>(20);
    private final List<IFluidHandler> fluidHandlers = new ArrayList<IFluidHandler>(20);
    private boolean called;
    @Persisted
    @DescSynced
    public final List<TesseractDirectedTarget> targets;
    @Persisted
    private final UnfinishedPushList unfinishedPushLists = new UnfinishedPushList(this);
    private WeakReference<BlockEntity>[] blockEntityReference;
    private final ConditionalSubscriptionHandler task;

    public DirectedTesseractMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.targets = new ArrayList<TesseractDirectedTarget>();
        this.task = new ConditionalSubscriptionHandler((ITickSubscription)this, this.unfinishedPushLists::push, 20, this.unfinishedPushLists::hasWorkToDo);
    }

    public boolean customPush() {
        return true;
    }

    public void setTargets(Collection<TesseractDirectedTarget> newTargets) {
        this.targets.clear();
        this.targets.addAll(newTargets);
        this.targets.sort(TesseractDirectedTarget.SORTER);
        this.blockEntityReference = new WeakReference[this.targets.size()];
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_ON, () -> false, (clickData, pressed) -> {
            if (clickData.isRemote && this.getLevel() != null) {
                HIGHLIGHTS.add((Object)ImmutableList.copyOf(this.targets), 200);
            }
        }).setTooltipsSupplier(pressed -> Collections.singletonList(Component.m_237115_((String)"gui.gtceu.machine.tesseract.highlight_targets")))});
    }

    @Override
    public BlockEntity getBlockEntity(int index) {
        BlockEntity be;
        if (this.blockEntityReference == null) {
            if (this.targets.isEmpty()) {
                return null;
            }
            this.blockEntityReference = new WeakReference[this.targets.size()];
        }
        if (this.blockEntityReference[index] != null && (be = (BlockEntity)this.blockEntityReference[index].get()) != null) {
            return be.m_58901_() ? null : be;
        }
        TesseractDirectedTarget target = this.targets.get(index);
        ServerLevel dim = ServerUtils.getServer().m_129880_(target.pos().m_122640_());
        if (dim == null) {
            return null;
        }
        BlockEntity be2 = dim.m_7702_(target.pos().m_122646_());
        this.blockEntityReference[index] = new WeakReference<BlockEntity>(be2);
        if (be2 != null) {
            return be2.m_58901_() ? null : be2;
        }
        return null;
    }

    public IPatternProviderLogic.PushResult pushPattern(IPatternProviderLogic logic, IActionSource actionSource, BooleanHolder success, ICustomCraftingMachine.Operate operate, Set<AEKey> patternInputs, IPatternDetails patternDetails, ObjectHolder<KeyCounter[]> inputHolder, Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess, BooleanSupplier canPush, Direction direction, Direction adjBeSide) {
        if (!(patternDetails instanceof AEProcessingPattern)) {
            return IPatternProviderLogic.PushResult.REJECTED;
        }
        AEProcessingPattern processingPattern = (AEProcessingPattern)patternDetails;
        GenericStack[] sparseInputs = processingPattern.getSparseInputs();
        if (this.unfinishedPushLists.hasWorkToDo() || this.targets.isEmpty() || sparseInputs.length > this.targets.size()) {
            return IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
        }
        O2OOpenCacheHashMap remainingStacks = new O2OOpenCacheHashMap(sparseInputs.length);
        O2OOpenCacheHashMap readyToPushStacks = new O2OOpenCacheHashMap(sparseInputs.length);
        for (int i = 0; i < sparseInputs.length; ++i) {
            boolean haveEnoughSpace;
            TesseractDirectedTarget targetAt = this.targets.get(i);
            BlockEntity be = this.getBlockEntity(i);
            GenericStack subPushStack = sparseInputs[i];
            if (be == null) {
                return IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
            }
            PatternProviderTarget toPush2 = PatternProviderTargetCache.find((BlockEntity)be, (IPatternProviderLogic)logic, (Direction)targetAt.face(), (IActionSource)actionSource, (long)targetAt.pos().m_122646_().m_121878_());
            if (toPush2 == null) {
                return IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
            }
            boolean blocked = toPush2.containsPatternInput(patternInputs);
            if (blocked) {
                return IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
            }
            boolean bl = haveEnoughSpace = toPush2.insert(subPushStack.what(), subPushStack.amount(), Actionable.SIMULATE) == subPushStack.amount();
            if (!haveEnoughSpace) {
                remainingStacks.put(targetAt, subPushStack);
                continue;
            }
            readyToPushStacks.put(toPush2, subPushStack);
        }
        remainingStacks.forEach(this.unfinishedPushLists::addTask);
        readyToPushStacks.forEach((toPush, stack) -> toPush.insert(stack.what(), stack.amount(), Actionable.MODULATE));
        this.unfinishedPushLists.push();
        return pushPatternSuccess.get();
    }

    @Override
    public int getTotalBlockEntities() {
        return this.targets.size();
    }

    @Override
    public Direction getSideForBlockEntity(int i, @Nullable Direction side) {
        return this.targets.get(i).face();
    }

    @Override
    public boolean onMarkerInteract(Player player, List<TesseractDirectedTarget> targets) {
        if (targets.isEmpty()) {
            return false;
        }
        if (this.getLevel() == null || this.getLevel().m_5776_()) {
            return true;
        }
        this.setTargets(targets);
        player.m_5661_((Component)Component.m_237115_((String)"gui.gtceu.machine.tesseract.write_targets_success"), true);
        return true;
    }

    public void onMachineRemoved() {
        this.unfinishedPushLists.unfinishedStacks.forEach(stack -> {
            AEKey patt0$temp;
            if (this.getLevel() != null && (patt0$temp = stack.what()) instanceof AEItemKey) {
                AEItemKey item = (AEItemKey)patt0$temp;
                Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getHolder().m_58899_(), (ItemStack)item.toStack(Math.toIntExact(stack.amount())));
            }
        });
    }

    private static MEStorage getMEStorage(TesseractDirectedTarget target, MinecraftServer levelGetter) {
        IGridConnectedBlockEntity gbe;
        ServerLevel dim = levelGetter.m_129880_(target.pos().m_122640_());
        if (dim == null) {
            return null;
        }
        BlockEntity be = dim.m_7702_(target.pos().m_122646_());
        if (be == null) {
            return null;
        }
        if (be instanceof IGridConnectedBlockEntity && (gbe = (IGridConnectedBlockEntity)be).getGridNode() != null) {
            return gbe.getGridNode().getGrid().getStorageService().getInventory();
        }
        ExternalStorageFacade item = be.getCapability(ForgeCapabilities.ITEM_HANDLER, target.face()).map(ExternalStorageFacade::of).orElse(null);
        ExternalStorageFacade fluid = be.getCapability(ForgeCapabilities.FLUID_HANDLER, target.face()).map(ExternalStorageFacade::of).orElse(null);
        if (item != null && fluid != null) {
            return new CompositeStorage((Map)new AEKeyTypeMap((Object)item, (Object)fluid));
        }
        if (item != null) {
            return item;
        }
        return fluid;
    }

    @Override
    @Generated
    public List<IItemHandler> getItemHandlers() {
        return this.itemHandlers;
    }

    @Override
    @Generated
    public List<IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    @Override
    @Generated
    public boolean isCalled() {
        return this.called;
    }

    @Override
    @Generated
    public void setCalled(boolean called) {
        this.called = called;
    }

    @Generated
    public List<TesseractDirectedTarget> getTargets() {
        return this.targets;
    }

    private static class UnfinishedPushList
    implements IManaged {
        final DirectedTesseractMachine machine;
        @Persisted
        final List<TesseractDirectedTarget> unfinishedPushes = new ArrayList<TesseractDirectedTarget>();
        @Persisted
        final List<GenericStack> unfinishedStacks = new ArrayList<GenericStack>();
        public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(UnfinishedPushList.class);
        private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);

        private UnfinishedPushList(DirectedTesseractMachine machine) {
            this.machine = machine;
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        public void onChanged() {
            this.machine.onChanged();
            this.machine.task.updateSubscription();
        }

        void push() {
            Level level = this.machine.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.machine.task.updateSubscription();
                MinecraftServer server = level2.m_7654_();
                for (int i = 0; i < this.unfinishedPushes.size(); ++i) {
                    TesseractDirectedTarget target = this.unfinishedPushes.get(i);
                    GenericStack stack = this.unfinishedStacks.get(i);
                    MEStorage meStorage = DirectedTesseractMachine.getMEStorage(target, server);
                    if (meStorage == null) continue;
                    long inserted = meStorage.insert(stack.what(), stack.amount(), Actionable.MODULATE, IActionSource.empty());
                    if (inserted == stack.amount()) {
                        this.unfinishedPushes.remove(i);
                        this.unfinishedStacks.remove(i);
                        --i;
                        continue;
                    }
                    this.unfinishedStacks.set(i, new GenericStack(stack.what(), stack.amount() - inserted));
                }
            }
        }

        boolean hasWorkToDo() {
            return !this.unfinishedPushes.isEmpty();
        }

        void addTask(TesseractDirectedTarget target, GenericStack stack) {
            this.unfinishedPushes.add(target);
            this.unfinishedStacks.add(stack);
            this.machine.onChanged();
            this.machine.task.updateSubscription();
        }

        @Generated
        public FieldManagedStorage getSyncStorage() {
            return this.syncStorage;
        }
    }
}

