/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.tesseract;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.tesseract.ITesseractMarkerInteractable;
import com.gtocore.common.machine.tesseract.TesseractDirectedTarget;
import com.gtolib.api.machine.part.ItemPartMachine;
import com.gtolib.api.player.IEnhancedPlayer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TesseractMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife,
ITesseractMarkerInteractable {
    private static final Set<Capability<?>> CAPABILITIES = Set.of(ForgeCapabilities.ITEM_HANDLER, ForgeCapabilities.FLUID_HANDLER);
    private WeakReference<BlockEntity> blockEntityReference;
    @Persisted
    public BlockPos pos;
    @Persisted
    protected NotifiableItemStackHandler inventory = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.NONE);
    private boolean call;

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    public TesseractMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.inventory.storage.setOnContentsChangedAndfreeze(() -> {
            this.call = false;
            this.pos = null;
            this.blockEntityReference = null;
            ItemStack card = this.inventory.storage.getStackInSlot(0);
            if (card.m_41619_()) {
                return;
            }
            CompoundTag posTags = card.m_41783_();
            if (!(posTags != null && posTags.m_128441_("x") && posTags.m_128441_("y") && posTags.m_128441_("z"))) {
                return;
            }
            BlockPos pos = new BlockPos(posTags.m_128451_("x"), posTags.m_128451_("y"), posTags.m_128451_("z"));
            if (pos.equals((Object)this.getPos())) {
                return;
            }
            this.pos = pos;
        });
    }

    public Widget createUIWidget() {
        return ItemPartMachine.createSLOTWidget((NotifiableItemStackHandler)this.inventory);
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IItemHandlerModifiable m;
        Object object;
        LazyOptional cap = this.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        IItemHandlerModifiable iItemHandlerModifiable = cap != null ? ((object = cap.orElse(null)) instanceof IItemHandlerModifiable ? (m = (IItemHandlerModifiable)object) : null) : null;
        return iItemHandlerModifiable;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IFluidHandlerModifiable m;
        Object object;
        LazyOptional cap = this.getCapability(ForgeCapabilities.FLUID_HANDLER, side);
        IFluidHandlerModifiable iFluidHandlerModifiable = cap != null ? ((object = cap.orElse(null)) instanceof IFluidHandlerModifiable ? (m = (IFluidHandlerModifiable)object) : null) : null;
        return iFluidHandlerModifiable;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.call) {
            return null;
        }
        if (this.pos != null && CAPABILITIES.contains(cap)) {
            LazyOptional result = null;
            this.call = true;
            if (this.blockEntityReference == null) {
                BlockEntity be = this.getLevel().m_7702_(this.pos);
                if (be != null) {
                    this.blockEntityReference = new WeakReference<BlockEntity>(be);
                    result = be.getCapability(cap, side);
                } else {
                    this.pos = null;
                }
            } else {
                BlockEntity blockEntity = (BlockEntity)this.blockEntityReference.get();
                if (blockEntity == null || blockEntity.m_58901_()) {
                    blockEntity = this.getLevel().m_7702_(this.pos);
                    if (blockEntity != null) {
                        this.blockEntityReference = new WeakReference<BlockEntity>(blockEntity);
                        result = blockEntity.getCapability(cap, side);
                    } else {
                        this.pos = null;
                    }
                } else {
                    result = blockEntity.getCapability(cap, side);
                }
            }
            this.call = false;
            if (side != null && result != null) {
                Object handler = result.orElse(null);
                if (handler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                    CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
                    return cover != null ? ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> cover.getItemHandlerCap(modifiable))) : result;
                }
                if (handler instanceof IFluidHandlerModifiable) {
                    IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)handler;
                    CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
                    return cover != null ? ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> cover.getFluidHandlerCap(modifiable))) : result;
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public boolean onMarkerInteract(Player player, List<TesseractDirectedTarget> targets) {
        ItemStack card = GTOItems.COORDINATE_CARD.m_5456_().m_7968_();
        if (this.inventory.storage.getStackInSlot(0).m_41619_()) {
            long cardNum;
            IStorageService meStorage;
            int idx;
            card = ItemStack.f_41583_;
            if (card.m_41619_() && (idx = player.m_150109_().m_36030_(GTOItems.COORDINATE_CARD.m_5456_().m_7968_())) >= 0) {
                card = player.m_150109_().m_7407_(idx, 1);
            }
            if (card.m_41619_() && (meStorage = IEnhancedPlayer.getMEStorageService((ServerPlayer)((ServerPlayer)player))) != null && (cardNum = meStorage.getInventory().extract((AEKey)AEItemKey.of((ItemLike)GTOItems.COORDINATE_CARD.m_5456_()), 1L, Actionable.MODULATE, IActionSource.ofPlayer((Player)player))) > 0L) {
                card = GTOItems.COORDINATE_CARD.m_5456_().m_7968_();
            }
            if (card.m_41619_()) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.gtceu.machine.tesseract.write_targets_fail"), true);
                return true;
            }
        }
        BlockPos pos = targets.getFirst().pos().m_122646_();
        CompoundTag posTags = card.m_41784_();
        posTags.m_128405_("x", pos.m_123341_());
        posTags.m_128405_("y", pos.m_123342_());
        posTags.m_128405_("z", pos.m_123343_());
        this.inventory.storage.setStackInSlot(0, card);
        player.m_5661_((Component)Component.m_237115_((String)"gui.gtceu.machine.tesseract.write_targets_success"), true);
        return true;
    }
}

