/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gtocore.common.machine.multiblock.electric.voidseries.AdvancedInfiniteDrillMachine;
import com.gtolib.api.machine.impl.DrillingControlCenterMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.machine.trait.IFluidDrillLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import lombok.Generated;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdvancedInfiniteDrillLogic
extends RecipeLogic
implements IEnhancedRecipeLogic,
IFluidDrillLogic {
    private static final int MAX_PROGRESS = 20;
    private final Reference2IntOpenHashMap<Fluid> veinFluids = new Reference2IntOpenHashMap();
    private int range;
    private DrillingControlCenterMachine cache;

    public AdvancedInfiniteDrillLogic(IRecipeLogicMachine machine, int range) {
        super(machine);
        this.range = range;
    }

    public AdvancedInfiniteDrillMachine getMachine() {
        return (AdvancedInfiniteDrillMachine)super.getMachine();
    }

    public void findAndHandleRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            Recipe match;
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastRecipe = null;
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate((ServerLevel)serverLevel);
            if (this.veinFluids.isEmpty()) {
                this.getGridFluid(data);
                if (this.veinFluids.isEmpty() && this.subscription != null) {
                    this.subscription.unsubscribe();
                    this.subscription = null;
                }
            }
            if ((match = this.getFluidDrillRecipe()) != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match)) {
                this.setupRecipe((GTRecipe)match);
            }
        }
    }

    @Nullable
    private Recipe getFluidDrillRecipe() {
        if (this.getMachine().isEmpty() || !this.getMachine().canRunnable()) {
            return null;
        }
        if (!this.veinFluids.isEmpty()) {
            RecipeBuilder builder = this.gtolib$getRecipeBuilder().duration(20).EUt(20000L);
            this.veinFluids.reference2IntEntrySet().fastForEach(e -> builder.outputFluids((Fluid)e.getKey(), (long)e.getIntValue()));
            Recipe recipe = builder.buildRawRecipe();
            recipe.modifier(new ContentModifier((double)(this.getParallel() * (long)AdvancedInfiniteDrillLogic.efficiency(this.getMachine().getRate() * 500)), 0.0), true);
            RecipeModifierFunction.overclocking((MetaMachine)this.getMachine(), (Recipe)recipe);
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe)) {
                return recipe;
            }
        }
        return null;
    }

    private long getParallel() {
        AdvancedInfiniteDrillMachine drill = this.getMachine();
        int currentHeat = drill.getCurrentHeat();
        int heat = drill.getRate();
        int efficiency = AdvancedInfiniteDrillLogic.efficiency(currentHeat);
        long produced = (long)efficiency * (long)heat;
        DrillingControlCenterMachine machine = (DrillingControlCenterMachine)this.getNetMachine();
        if (machine != null) {
            produced = (long)((double)produced * machine.getMultiplier());
        }
        return produced;
    }

    private static int efficiency(int heat) {
        if (heat < 6000) {
            return 2;
        }
        if (heat < 8000) {
            return 4;
        }
        return 8;
    }

    private static int getFluidToProduce(FluidVeinWorldEntry entry) {
        BedrockFluidDefinition definition = entry.getDefinition();
        if (definition != null) {
            int depletedYield = definition.getDepletedYield();
            int regularYield = entry.getFluidYield();
            int remainingOperations = entry.getOperationsRemaining();
            return Math.max(depletedYield, regularYield * remainingOperations / 100000);
        }
        return 0;
    }

    private void getGridFluid(BedrockFluidVeinSavedData data) {
        int x = this.getChunkX();
        int z = this.getChunkZ();
        int mid = this.range / 2;
        for (int i = -mid; i <= mid; ++i) {
            for (int j = -mid; j <= mid; ++j) {
                int produced;
                Fluid fluid = data.getFluidInChunk(x + i, z + j);
                if (fluid == null || (produced = AdvancedInfiniteDrillLogic.getFluidToProduce(data.getFluidVeinWorldEntry(x + i, z + j))) <= 0) continue;
                int value = this.veinFluids.getOrDefault((Object)fluid, 0) + produced * 10;
                this.veinFluids.put((Object)fluid, value);
            }
        }
    }

    @NotNull
    public Reference2IntOpenHashMap<Fluid> getVeinFluids() {
        return this.veinFluids;
    }

    public void onRecipeFinish() {
        Recipe match;
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.handleRecipeIO(this.lastRecipe, IO.OUT);
        }
        if ((match = this.getFluidDrillRecipe()) != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)match)) {
            this.setupRecipe((GTRecipe)match);
            return;
        }
        this.setStatus(0);
        this.progress = 0;
        this.duration = 0;
    }

    private int getChunkX() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123341_());
    }

    private int getChunkZ() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123343_());
    }

    public DrillingControlCenterMachine getNetMachineCache() {
        return this.cache;
    }

    public void setNetMachineCache(DrillingControlCenterMachine cache) {
        this.cache = cache;
    }

    public void onMachineUnLoad() {
        super.onMachineUnLoad();
        this.cache = null;
    }

    @Generated
    public void setRange(int range) {
        this.range = range;
    }

    @Generated
    public int getRange() {
        return this.range;
    }
}

