/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.data.Galaxy;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class GalaxyCondition
extends DimensionCondition {
    private Galaxy galaxy;
    private DimensionMarker[] dimensions;

    public GalaxyCondition(Galaxy galaxy) {
        this.galaxy = galaxy;
    }

    public GalaxyCondition() {
        this.galaxy = Galaxy.NONE;
    }

    public RecipeConditionType<?> getType() {
        return AbstractRecipeCondition.GALAXY;
    }

    public Component getTooltips() {
        return Component.m_237110_((String)"gtocore.condition.within_galaxy", (Object[])new Object[]{Component.m_237115_((String)("gtolib.galaxy.name." + this.galaxy.name()))});
    }

    public RecipeCondition createTemplate() {
        return new GalaxyCondition();
    }

    public SlotWidget setupDimensionMarkers(int xOffset, int yOffset) {
        final Supplier<DimensionMarker> dimSupplier = () -> this.getDimensions()[Math.toIntExact(System.currentTimeMillis() / 1000L % (long)this.getDimensions().length)];
        final CustomItemStackHandler handler = new CustomItemStackHandler(1);
        return new SlotWidget(this, (IItemHandlerModifiable)handler, 0, xOffset, yOffset, false, false){

            public void drawOverlay(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                if (ConfigHolder.INSTANCE.compat.showDimensionTier) {
                    this.overlay = new TextTexture("T" + String.valueOf(((DimensionMarker)dimSupplier.get()).tier >= 99 ? "?" : Integer.valueOf(((DimensionMarker)dimSupplier.get()).tier))).scale(0.75f).transform(-3.0f, 5.0f);
                }
                super.drawOverlay(graphics, mouseX, mouseY, partialTicks);
            }

            public ItemStack getRealStack(ItemStack itemStack) {
                handler.setStackInSlot(0, ((DimensionMarker)dimSupplier.get()).getIcon());
                return ((DimensionMarker)dimSupplier.get()).getIcon();
            }

            public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
            }
        }.setIngredientIO(IngredientIO.INPUT);
    }

    public DimensionMarker[] getDimensions() {
        if (this.dimensions != null && this.dimensions.length > 0) {
            return this.dimensions;
        }
        this.dimensions = (DimensionMarker[])Stream.of(Dimension.values()).filter(d -> d.getGalaxy() == this.galaxy).map(Dimension::getLocation).map(arg_0 -> ((GTRegistry.RL)GTRegistries.DIMENSION_MARKERS).get(arg_0)).filter(Objects::nonNull).toArray(DimensionMarker[]::new);
        return this.dimensions;
    }

    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.self().getLevel();
        return level != null && GTODimensions.getGalaxy((ResourceLocation)level.m_46472_().m_135782_()) == this.galaxy;
    }

    @NotNull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("galaxy", this.galaxy.name());
        return config;
    }

    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.galaxy = Galaxy.valueOf((String)GsonHelper.m_13906_((JsonObject)config, (String)"galaxy"));
        this.dimensions = null;
        return this;
    }

    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.galaxy = Galaxy.valueOf((String)buf.m_130277_());
        this.dimensions = null;
        return this;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.galaxy.name());
    }
}

