/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.ICoilMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtolib.api.machine.feature.IHeaterMachine;
import com.gtolib.api.machine.feature.ITemperatureMachine;
import com.gtolib.api.recipe.Recipe;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class HeatCondition
extends AbstractRecipeCondition {
    private final int temperature;

    public HeatCondition(int temperature) {
        this.temperature = temperature;
    }

    public RecipeConditionType<?> getType() {
        return HEAT;
    }

    public Component getTooltips() {
        return Component.m_237110_((String)"gtocore.recipe.heat.temperature", (Object[])new Object[]{this.temperature});
    }

    @Override
    public boolean test(@NotNull Recipe recipe, @NotNull RecipeLogic recipeLogic) {
        MetaMachine machine = recipeLogic.getMachine();
        if (machine instanceof MultiblockControllerMachine) {
            ICoilMachine coilMachine;
            MultiblockControllerMachine controllerMachine = (MultiblockControllerMachine)machine;
            if (machine instanceof ICoilMachine && (coilMachine = (ICoilMachine)machine).getTemperature() >= this.temperature) {
                return true;
            }
            IMultiPart[] iMultiPartArray = controllerMachine.getParts();
            int n = iMultiPartArray.length;
            for (int i = 0; i < n; ++i) {
                ITemperatureMachine t;
                IMultiPart p = iMultiPartArray[i];
                if (!(p instanceof ITemperatureMachine) || (t = (ITemperatureMachine)p).getTemperature() < this.temperature) continue;
                return true;
            }
        }
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!this.checkNeighborHeat(machine, side)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNeighborHeat(MetaMachine machine, Direction side) {
        MetaMachine metaMachine = machine.getNeighborMachine(side);
        if (metaMachine instanceof IHeaterMachine) {
            IHeaterMachine heaterMachine = (IHeaterMachine)metaMachine;
            return heaterMachine.getTemperature() >= this.temperature && heaterMachine.reduceTemperature(4) == 4;
        }
        return false;
    }
}

