/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtocore.common.saved.RecipeRunLimitSavaedData;
import com.gtolib.api.recipe.Recipe;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class RunLimitCondition
extends AbstractRecipeCondition {
    private final int count;

    public RunLimitCondition(int count) {
        this.count = count;
    }

    public RecipeConditionType<?> getType() {
        return RUN_LIMIT;
    }

    public Component getTooltips() {
        return Component.m_237110_((String)"gtocore.recipe.runlimit.count", (Object[])new Object[]{this.count});
    }

    @Override
    public boolean test(@NotNull Recipe recipe, @NotNull RecipeLogic recipeLogic) {
        MetaMachine machine = recipeLogic.getMachine();
        UUID owner = machine.getOwnerUUID();
        if (owner == null) {
            return false;
        }
        int runLimit = RecipeRunLimitSavaedData.get(owner, recipe.id);
        if (runLimit < this.count) {
            RecipeRunLimitSavaedData.set(owner, recipe.id, runLimit + 1);
            return true;
        }
        return false;
    }
}

