/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.recipe.condition.AbstractRecipeCondition;
import com.gtolib.api.machine.feature.IVacuumMachine;
import com.gtolib.api.recipe.Recipe;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class VacuumCondition
extends AbstractRecipeCondition {
    private final int tier;

    public VacuumCondition(int tier) {
        this.tier = tier;
    }

    public RecipeConditionType<?> getType() {
        return VACUUM;
    }

    public Component getTooltips() {
        return Component.m_237110_((String)"gtocore.recipe.vacuum.tier", (Object[])new Object[]{this.tier});
    }

    @Override
    public boolean test(@NotNull Recipe recipe, @NotNull RecipeLogic recipeLogic) {
        MultiblockControllerMachine controllerMachine;
        MetaMachine machine = recipeLogic.getMachine();
        if (machine instanceof MultiblockControllerMachine && this.checkVacuumTier((controllerMachine = (MultiblockControllerMachine)machine).getParts())) {
            return true;
        }
        for (MultiblockControllerMachine side : GTUtil.DIRECTIONS) {
            if (side.m_122434_() == Direction.Axis.Y || !this.checkNeighborVacuumTier(machine, (Direction)side)) continue;
            return true;
        }
        Level level = machine.getLevel();
        return !OxygenApi.API.hasOxygen(level, machine.getPos()) && PlanetApi.API.isSpace(level);
    }

    private boolean checkVacuumTier(IMultiPart[] parts) {
        for (IMultiPart part : parts) {
            IVacuumMachine vacuumMachine;
            if (!(part instanceof IVacuumMachine) || (vacuumMachine = (IVacuumMachine)part).getVacuumTier() < this.tier) continue;
            return true;
        }
        return false;
    }

    private boolean checkNeighborVacuumTier(MetaMachine machine, Direction side) {
        MetaMachine metaMachine = machine.getNeighborMachine(side);
        if (metaMachine instanceof IVacuumMachine) {
            IVacuumMachine vacuumMachine = (IVacuumMachine)metaMachine;
            return vacuumMachine.getVacuumTier() >= this.tier;
        }
        return false;
    }
}

