/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.syncdata;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class GTORecipePayload
extends ObjectTypedPayload<GTRecipe> {
    public Tag serializeNBT() {
        return Recipe.of((GTRecipe)((GTRecipe)this.payload)).serializeNBT();
    }

    public void deserializeNBT(Tag tag) {
        this.payload = Recipe.deserializeNBT((Tag)tag);
    }

    public void writePayload(FriendlyByteBuf buf) {
        Recipe recipe = (Recipe)this.payload;
        buf.m_130085_(recipe.id);
        if (recipe.root) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            Recipe.SERIALIZER.toNetwork(buf, recipe);
            buf.writeInt(recipe.ocLevel);
            buf.writeLong(recipe.parallels);
            if (recipe.rootRecipe != null) {
                buf.m_130085_(recipe.rootRecipe.id);
            }
        }
    }

    public void readPayload(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        if (buf.readBoolean()) {
            this.payload = RecipeBuilder.RECIPE_MAP.get(id);
        } else if (buf.isReadable()) {
            Recipe recipe = Recipe.SERIALIZER.fromNetwork(id, buf);
            if (buf.isReadable()) {
                recipe.ocLevel = buf.readInt();
                recipe.setParallels(buf.readLong());
                if (buf.isReadable()) {
                    recipe.rootRecipe = (Recipe)RecipeBuilder.RECIPE_MAP.get(buf.m_130281_());
                }
            }
            this.payload = recipe;
        }
    }
}

