/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.data.recipe.MaterialInfoLoader;
import com.gregtechceu.gtceu.data.recipe.misc.RecyclingRecipes;
import com.gregtechceu.gtceu.data.recipe.misc.StoneMachineRecipes;
import com.gregtechceu.gtceu.data.recipe.misc.WoodMachineRecipes;
import com.gregtechceu.gtceu.integration.emi.recipe.GTRecipeEMICategory;
import com.gtocore.common.data.GTOLoots;
import com.gtocore.common.data.GTOOres;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.data.GTORecipes;
import com.gtocore.data.CraftingComponents;
import com.gtocore.data.MaterialInfo;
import com.gtocore.data.recipe.EasyModeRecipe;
import com.gtocore.data.recipe.FuelRecipe;
import com.gtocore.data.recipe.GCYRecipes;
import com.gtocore.data.recipe.GTMTRecipe;
import com.gtocore.data.recipe.MachineRecipe;
import com.gtocore.data.recipe.MiscRecipe;
import com.gtocore.data.recipe.OrganRecipes;
import com.gtocore.data.recipe.RecipeFilter;
import com.gtocore.data.recipe.Temporary;
import com.gtocore.data.recipe.ae2.AE2;
import com.gtocore.data.recipe.ae2.Ae2wtlibRecipes;
import com.gtocore.data.recipe.classified.$ClassifiedRecipe;
import com.gtocore.data.recipe.generated.DyeRecipes;
import com.gtocore.data.recipe.generated.ElementCopying;
import com.gtocore.data.recipe.generated.ForEachMaterial;
import com.gtocore.data.recipe.generated.GenerateDisassembly;
import com.gtocore.data.recipe.generated.GlassRecipe;
import com.gtocore.data.recipe.generated.PetrochemRecipes;
import com.gtocore.data.recipe.generated.RadiationHatchRecipes;
import com.gtocore.data.recipe.generated.WoodRecipes;
import com.gtocore.data.recipe.gtm.chemistry.ChemistryRecipes;
import com.gtocore.data.recipe.gtm.configurable.RecipeAddition;
import com.gtocore.data.recipe.gtm.misc.AssemblerRecipeLoader;
import com.gtocore.data.recipe.gtm.misc.BatteryRecipes;
import com.gtocore.data.recipe.gtm.misc.CircuitRecipes;
import com.gtocore.data.recipe.gtm.misc.CraftingRecipeLoader;
import com.gtocore.data.recipe.gtm.misc.CustomToolRecipes;
import com.gtocore.data.recipe.gtm.misc.DecorationRecipes;
import com.gtocore.data.recipe.gtm.misc.FusionLoader;
import com.gtocore.data.recipe.gtm.misc.GCYMRecipes;
import com.gtocore.data.recipe.gtm.misc.MachineRecipeLoader;
import com.gtocore.data.recipe.gtm.misc.MetaTileEntityLoader;
import com.gtocore.data.recipe.gtm.misc.MetaTileEntityMachineRecipeLoader;
import com.gtocore.data.recipe.gtm.misc.MiscRecipeLoader;
import com.gtocore.data.recipe.gtm.misc.VanillaStandardRecipes;
import com.gtocore.data.recipe.magic.ArsNouveauRecipes;
import com.gtocore.data.recipe.magic.BotaniaRecipes;
import com.gtocore.data.recipe.magic.MagicRecipesA;
import com.gtocore.data.recipe.magic.MagicRecipesB;
import com.gtocore.data.recipe.misc.ComponentRecipes;
import com.gtocore.data.recipe.misc.SpaceStationRecipes;
import com.gtocore.data.recipe.mod.ComputerCraft;
import com.gtocore.data.recipe.mod.FunctionalStorage;
import com.gtocore.data.recipe.mod.ImmersiveAircraft;
import com.gtocore.data.recipe.mod.MeteoriteRecipe;
import com.gtocore.data.recipe.mod.ModularRouters;
import com.gtocore.data.recipe.mod.Pipez;
import com.gtocore.data.recipe.mod.Sophisticated;
import com.gtocore.data.recipe.mod.SuperFactoryManager;
import com.gtocore.data.recipe.processing.BrineRecipes;
import com.gtocore.data.recipe.processing.CompositeMaterialsProcessing;
import com.gtocore.data.recipe.processing.Lanthanidetreatment;
import com.gtocore.data.recipe.processing.NaquadahProcess;
import com.gtocore.data.recipe.processing.NewResearchSystem;
import com.gtocore.data.recipe.processing.PlatGroupMetals;
import com.gtocore.data.recipe.processing.StoneDustProcess;
import com.gtocore.data.recipe.research.ResearchRecipes;
import com.gtocore.data.transaction.data.GTOTrade;
import com.gtocore.integration.emi.GTEMIRecipe;
import com.gtocore.integration.emi.multipage.MultiblockInfoEmiRecipe;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.MultiblockDefinition;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.RegistriesUtils;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.SidebarSide;
import dev.emi.emi.recipe.special.EmiRepairItemRecipe;
import dev.shadowsoffire.placebo.loot.LootSystem;
import java.util.Collections;
import lombok.Generated;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public final class Data {
    private static Throwable throwable;

    public static void init() {
        if (GTCEu.isClientSide()) {
            GTOUtils.startThread(Data::clientInit);
        } else {
            Data.commonInit();
        }
    }

    private static void commonInit() {
        long time = System.currentTimeMillis();
        GTOOres.init();
        MeteoriteRecipe.init();
        ItemMaterialData.reinitializeMaterialData();
        CraftingComponents.init();
        MaterialInfoLoader.init();
        MaterialInfo.init();
        RecipeBuilder.initialization();
        RecipeFilter.init();
        BlastProperty.GasTier.LOW.setFluid(() -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Nitrogen.getFluid(1000)}));
        BlastProperty.GasTier.MID.setFluid(() -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Helium.getFluid(100)}));
        BlastProperty.GasTier.HIGH.setFluid(() -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Argon.getFluid(100)}));
        BlastProperty.GasTier.HIGHER.setFluid(() -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Neon.getFluid(100)}));
        BlastProperty.GasTier.HIGHEST.setFluid(() -> FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.Krypton.getFluid(100)}));
        ResearchRecipes.init();
        ComponentRecipes.init();
        WoodMachineRecipes.init();
        StoneMachineRecipes.init();
        CustomToolRecipes.init();
        ChemistryRecipes.init();
        MetaTileEntityMachineRecipeLoader.init();
        MiscRecipeLoader.init();
        VanillaStandardRecipes.init();
        CraftingRecipeLoader.init();
        FusionLoader.init();
        MachineRecipeLoader.init();
        AssemblerRecipeLoader.init();
        BatteryRecipes.init();
        DecorationRecipes.init();
        CircuitRecipes.init();
        MetaTileEntityLoader.init();
        GCYMRecipes.init();
        RecipeAddition.init();
        ForEachMaterial.init();
        GTMTRecipe.init();
        GCYRecipes.init();
        MachineRecipe.init();
        MiscRecipe.init();
        SpaceStationRecipes.init();
        OrganRecipes.INSTANCE.init();
        BotaniaRecipes.init();
        ArsNouveauRecipes.init();
        MagicRecipesA.init();
        MagicRecipesB.init();
        FuelRecipe.init();
        BrineRecipes.init();
        NaquadahProcess.init();
        PlatGroupMetals.init();
        CompositeMaterialsProcessing.init();
        ElementCopying.init();
        StoneDustProcess.init();
        Lanthanidetreatment.init();
        NewResearchSystem.init();
        RadiationHatchRecipes.init();
        PetrochemRecipes.init();
        GlassRecipe.init();
        DyeRecipes.init();
        WoodRecipes.init();
        AE2.init();
        Ae2wtlibRecipes.init();
        ImmersiveAircraft.init();
        FunctionalStorage.init();
        ComputerCraft.init();
        ModularRouters.init();
        SuperFactoryManager.init();
        Pipez.init();
        Sophisticated.init();
        $ClassifiedRecipe.init();
        Temporary.init();
        if (GTCEu.isDev() || GTOCore.isEasy()) {
            EasyModeRecipe.init();
        }
        GenerateDisassembly.DISASSEMBLY_RECORD.clear();
        GenerateDisassembly.DISASSEMBLY_BLACKLIST.clear();
        RecyclingRecipes.init();
        ItemMaterialData.ITEM_MATERIAL_INFO.clear();
        RecipeBuilder.clean();
        LootSystem.defaultBlockTable((Block)RegistriesUtils.getBlock((String)"farmersrespite:kettle"));
        GTOLoots.BLOCKS.forEach(b2 -> LootSystem.defaultBlockTable((Block)((Block)b2)));
        GTOLoots.BLOCKS = null;
        GTOLoots.init();
        MixinHelpers.registryGTDynamicTags();
        GTOTrade.init();
        GTOCore.LOGGER.info("Data loading took {}ms", (Object)(System.currentTimeMillis() - time));
    }

    private static void clientInit() {
        try {
            Data.commonInit();
        }
        catch (Throwable t) {
            throwable = t;
        }
        RecipeBuilder.RECIPE_MAP.values().forEach(recipe -> recipe.recipeCategory.addRecipe((GTRecipe)recipe));
        if (GTCEu.Mods.isEMILoaded()) {
            MultiblockDefinition.init();
            long time = System.currentTimeMillis();
            EmiConfig.logUntranslatedTags = false;
            EmiConfig.workstationLocation = SidebarSide.LEFT;
            EmiRepairItemRecipe.TOOLS.clear();
            ImmutableSet.Builder recipes = ImmutableSet.builder();
            for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
                if (!category.shouldRegisterDisplays()) continue;
                GTRecipeType type = category.getRecipeType();
                if (category == type.getCategory()) {
                    type.buildRepresentativeRecipes();
                }
                EmiRecipeCategory emiCategory = (EmiRecipeCategory)GTRecipeEMICategory.CATEGORIES.apply(category);
                type.getRecipesInCategory(category).stream().map(recipe -> new GTEMIRecipe((Recipe)recipe, emiCategory)).forEach(arg_0 -> ((ImmutableSet.Builder)recipes).add(arg_0));
            }
            for (MachineDefinition machine : GTRegistries.MACHINES.values()) {
                MultiblockMachineDefinition definition;
                if (!(machine instanceof MultiblockMachineDefinition) || !(definition = (MultiblockMachineDefinition)machine).isRenderXEIPreview()) continue;
                recipes.add((Object)new MultiblockInfoEmiRecipe(definition));
            }
            GTORecipes.EMI_RECIPES = recipes.build();
            for (GTRecipeType type : GTRegistries.RECIPE_TYPES) {
                if (type == GTORecipeTypes.FURNACE_RECIPES) {
                    type.getCategoryMap().putIfAbsent(GTRecipeTypes.FURNACE_RECIPES.getCategory(), Collections.emptySet());
                    continue;
                }
                type.getCategoryMap().replaceAll((k, v) -> Collections.emptySet());
            }
            GTOCore.LOGGER.info("Pre initialization EMI GTRecipe took {}ms", (Object)(System.currentTimeMillis() - time));
        }
    }

    @Generated
    public static Throwable getThrowable() {
        return throwable;
    }
}

