/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.lootTables;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gtocore.common.data.GTOLoots;
import com.gtolib.utils.RLUtils;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Map;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class GTDynamicLoot {
    private static VanillaBlockLoot BLOCK_LOOT = new VanillaBlockLoot();

    public static void init() {
        GTMaterialBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> {
            if (TagPrefix.ORES.containsKey(prefix)) {
                TagPrefix.OreType type = (TagPrefix.OreType)TagPrefix.ORES.get(prefix);
                map.forEach((material, blockEntry) -> {
                    ItemStack dropItem;
                    ResourceLocation lootTableId = RLUtils.fromNamespaceAndPath((String)blockEntry.getId().m_135827_(), (String)("blocks/" + blockEntry.getId().m_135815_()));
                    Block block = (Block)blockEntry.get();
                    if (!type.shouldDropAsItem() && !ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes) {
                        TagPrefix orePrefix = type.isDoubleDrops() ? TagPrefix.oreNetherrack : TagPrefix.ore;
                        block = ChemicalHelper.getBlock((TagPrefix)orePrefix, (Material)material);
                    }
                    if ((dropItem = ChemicalHelper.get((TagPrefix)TagPrefix.rawOre, (Material)material)).m_41619_()) {
                        dropItem = ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)material);
                    }
                    if (dropItem.m_41619_()) {
                        dropItem = ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material);
                    }
                    int oreMultiplier = type.isDoubleDrops() ? 2 : 1;
                    LootTable.Builder builder = BlockLootSubProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)BLOCK_LOOT.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)dropItem.m_41720_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)oreMultiplier))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)))));
                    LootPool.Builder pool = LootPool.m_79043_();
                    boolean isEmpty = true;
                    for (MaterialStack secondaryMaterial : prefix.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        ItemStack dustStack = ChemicalHelper.getGem((MaterialStack)secondaryMaterial);
                        pool.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)dustStack.m_41720_()).m_79080_(BlockLootSubProvider.f_244217_)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165011_((int)0, (int)2))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()));
                        isEmpty = false;
                    }
                    if (!isEmpty) {
                        builder.m_79161_(pool);
                    }
                    GTOLoots.addToot(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
                    ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
                });
            } else {
                GTDynamicLoot.addMaterialBlockLootTables(map);
            }
        });
        GTMaterialBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> GTDynamicLoot.addMaterialBlockLootTables(map));
        GTMaterialBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> GTDynamicLoot.addMaterialBlockLootTables(map));
        GTMaterialBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> GTDynamicLoot.addMaterialBlockLootTables(map));
        GTMaterialBlocks.SURFACE_ROCK_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = RLUtils.fromNamespaceAndPath((String)blockEntry.getId().m_135827_(), (String)("blocks/" + blockEntry.getId().m_135815_()));
            LootTable.Builder builder = BLOCK_LOOT.m_245765_((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.dustTiny, (Material)material).m_41720_(), (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_));
            GTOLoots.addToot(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
        GTRegistries.MACHINES.forEach(machine -> {
            MetaMachineBlock block = machine.get();
            ResourceLocation id = machine.getId();
            ResourceLocation lootTableId = RLUtils.fromNamespaceAndPath((String)id.m_135827_(), (String)("blocks/" + id.m_135815_()));
            ((BlockBehaviourAccessor)block).setDrops(lootTableId);
            GTOLoots.addToot(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)block).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
        BLOCK_LOOT = null;
    }

    private static void addMaterialBlockLootTables(Map<Material, ? extends BlockEntry<? extends Block>> map) {
        map.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = RLUtils.fromNamespaceAndPath((String)blockEntry.getId().m_135827_(), (String)("blocks/" + blockEntry.getId().m_135815_()));
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
            GTOLoots.addToot(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)blockEntry.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }
}

