/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.lootTables;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOLoots;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.data.lootTables.GTOLootTool.CustomLogicFunction;
import com.gtocore.data.lootTables.GTOLootTool.CustomLogicNumberProvider;
import com.gtocore.data.lootTables.GTOLootTool.LootRegistrationTool;
import com.gtolib.GTOCore;
import mythicbotany.register.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;

public final class RewardBagLoot {
    public static CustomLogicNumberProvider getEfficiencyLuckLevel = new CustomLogicNumberProvider.Builder((thisEntity, lastDamagePlayer, damageSource, killerEntity, directKiller, origin, blockState, blockEntity, tool, explosionRadius, level) -> {
        int result = tool.getEnchantmentLevel(Enchantments.f_44984_);
        return UniformGenerator.m_165780_((float)Mth.m_14045_((int)(result - 2), (int)1, (int)18), (float)Mth.m_14045_((int)(result + 4), (int)1, (int)18));
    }).build();
    public static final ResourceLocation LV_REWARD_BAG_LOOT = GTOCore.id((String)"reward_bags/lv_reward_bag_loot");
    public static final ResourceLocation RUNE_REWARD_BAG1_LOOT = GTOCore.id((String)"reward_bags/rune_reward_bag1_loot");
    public static final ResourceLocation RUNE_REWARD_BAG2_LOOT = GTOCore.id((String)"reward_bags/rune_reward_bag2_loot");
    public static final ResourceLocation RUNE_REWARD_BAG3_LOOT = GTOCore.id((String)"reward_bags/rune_reward_bag3_loot");
    public static final ResourceLocation RUNE_REWARD_BAG4_LOOT = GTOCore.id((String)"reward_bags/rune_reward_bag4_loot");
    private static final Lazy<Item[]> rune1 = Lazy.of(() -> new Item[]{BotaniaItems.runeMana, BotaniaItems.runeWater, BotaniaItems.runeFire, BotaniaItems.runeAir, BotaniaItems.runeEarth});
    private static final Lazy<Item[]> rune2 = Lazy.of(() -> new Item[]{BotaniaItems.runeSpring, BotaniaItems.runeSummer, BotaniaItems.runeAutumn, BotaniaItems.runeWinter});
    private static final Lazy<Item[]> rune3 = Lazy.of(() -> new Item[]{BotaniaItems.runeLust, BotaniaItems.runeGluttony, BotaniaItems.runeGreed, BotaniaItems.runeSloth, BotaniaItems.runeWrath, BotaniaItems.runeEnvy, BotaniaItems.runePride});
    private static final Lazy<Item[]> rune4 = Lazy.of(() -> new Item[]{ModItems.asgardRune, ModItems.vanaheimRune, ModItems.alfheimRune, ModItems.midgardRune, ModItems.joetunheimRune, ModItems.muspelheimRune, ModItems.niflheimRune, ModItems.nidavellirRune, ModItems.helheimRune});

    public static void init() {
        GTOLoots.addToot(LV_REWARD_BAG_LOOT, RewardBagLoot.create_LV_REWARD_BAG_LOOT());
        GTOLoots.addToot(RUNE_REWARD_BAG1_LOOT, RewardBagLoot.create_RUNE_REWARD_BAG_LOOT((Item[])rune1.get()));
        GTOLoots.addToot(RUNE_REWARD_BAG2_LOOT, RewardBagLoot.create_RUNE_REWARD_BAG_LOOT((Item[])rune2.get()));
        GTOLoots.addToot(RUNE_REWARD_BAG3_LOOT, RewardBagLoot.create_RUNE_REWARD_BAG_LOOT((Item[])rune3.get()));
        GTOLoots.addToot(RUNE_REWARD_BAG4_LOOT, RewardBagLoot.create_RUNE_REWARD_BAG_LOOT((Item[])rune4.get()));
        getEfficiencyLuckLevel = null;
    }

    @NotNull
    public static LootPoolSingletonContainer.Builder<?> getLootItemRelyFortune(Item item, int weight, int count) {
        return LootItem.m_79579_((ItemLike)Items.f_41852_).m_79707_(weight).m_79078_((LootItemFunction.Builder)new CustomLogicFunction.Builder((level, thisEntity, lastDamagePlayer, damageSource, killerEntity, directKiller, origin, blockState, blockEntity, tool, explosionRadius, stack) -> {
            float probability;
            if (origin != null && ((probability = 0.2f * (float)(1 + tool.getEnchantmentLevel(Enchantments.f_44987_))) >= 1.0f || level.f_46441_.m_188501_() < probability)) {
                ItemEntity itemEntity = new ItemEntity((Level)level, origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), new ItemStack((ItemLike)item, count));
                itemEntity.m_32061_();
                level.m_7967_((Entity)itemEntity);
            }
        }));
    }

    private static LootTable create_LV_REWARD_BAG_LOOT() {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)getEfficiencyLuckLevel).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f)).m_79076_(LootRegistrationTool.getLootItem("farmersrespite:black_cod", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersrespite:tea_curry", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersrespite:blazing_chili", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersrespite:coffee_cake", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersrespite:rose_hip_pie", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersdelight:beef_patty", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersdelight:hamburger", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersdelight:roasted_mutton_chops", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("farmersdelight:hot_cocoa", 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.Iron), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.Copper), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.BismuthBronze), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.RedAlloy), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTOMaterials.RedstoneAlloy), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.Steel), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(ChemicalHelper.getItem((TagPrefix)TagPrefix.ingot, (Material)GTMaterials.Aluminium), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(Items.f_42451_, 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(Items.f_42413_, 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(Items.f_42584_, 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("functionalstorage:copper_upgrade", 60, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.FLUID_CELL_LARGE_STEEL.m_5456_(), 60, (NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)16.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:steel_wrench", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:steel_wire_cutter", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:steel_hammer", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:steel_screwdriver", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:steel_file", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("gtceu:silicone_rubber_mallet", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.ELECTRIC_MOTOR_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.CONVEYOR_MODULE_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.ELECTRIC_PUMP_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.FLUID_REGULATOR_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.ELECTRIC_PISTON_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.ROBOT_ARM_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(RewardBagLoot.getLootItemRelyFortune(GTItems.EMITTER_LV.m_5456_(), 80, 1)).m_79076_(RewardBagLoot.getLootItemRelyFortune(GTItems.SENSOR_LV.m_5456_(), 80, 1)).m_79076_(RewardBagLoot.getLootItemRelyFortune(GTItems.FIELD_GENERATOR_LV.m_5456_(), 5, 1)).m_79076_(LootRegistrationTool.getLootItem(GTItems.VOLTAGE_COIL_LV.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.RESISTOR.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.DIODE.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTOItems.UNIVERSAL_CIRCUIT[0].m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTOItems.UNIVERSAL_CIRCUIT[1].m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.GLASS_TUBE.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem(GTItems.COATED_BOARD.m_5456_(), 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("sophisticatedbackpacks:upgrade_base", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79076_(LootRegistrationTool.getLootItem("sophisticatedbackpacks:stack_upgrade_tier_1", 80, (NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        return LootTable.m_79147_().m_79161_(pool).m_79165_(LootContextParamSets.f_81414_).m_79167_();
    }

    private static LootTable create_RUNE_REWARD_BAG_LOOT(Item[] runes) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)getEfficiencyLuckLevel).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f));
        for (Item rune : runes) {
            pool.m_79076_(LootRegistrationTool.getLootItem(rune, 100, (NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)));
        }
        return LootTable.m_79147_().m_79161_(pool).m_79165_(LootContextParamSets.f_81414_).m_79167_();
    }
}

