/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.ars;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ImbuementRecipeBuilder {
    private final ResourceLocation id;
    private Ingredient input;
    private ItemStack output;
    private int source;
    private final List<Ingredient> pedestalItems = new ArrayList<Ingredient>();

    public static ImbuementRecipeBuilder builder(String name) {
        return new ImbuementRecipeBuilder(GTOCore.id((String)("imbuement/" + name)));
    }

    private ImbuementRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ImbuementRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public ImbuementRecipeBuilder input(ItemLike item) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ImbuementRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.m_204132_(tag));
    }

    public ImbuementRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public ImbuementRecipeBuilder output(ItemLike item) {
        return this.output(new ItemStack(item));
    }

    public ImbuementRecipeBuilder output(ItemLike item, int count) {
        return this.output(new ItemStack(item, count));
    }

    public ImbuementRecipeBuilder source(int source) {
        if (source != 0) {
            this.source = source;
        }
        return this;
    }

    public ImbuementRecipeBuilder addPedestalItem(Ingredient ingredient) {
        if (ingredient != null) {
            this.pedestalItems.add(ingredient);
        }
        return this;
    }

    public ImbuementRecipeBuilder addPedestalItem(ItemLike item) {
        return this.addPedestalItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ImbuementRecipeBuilder addPedestalItem(TagKey<Item> tag) {
        return this.addPedestalItem(Ingredient.m_204132_(tag));
    }

    public void save() {
        if (this.input == null) {
            throw new IllegalStateException("No input specified for imbuement recipe");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output specified for imbuement recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new ImbuementRecipe(this.id, this.input, this.output, this.source, this.pedestalItems));
    }
}

