/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.crafting.ElvenTradeRecipe;

public final class ElvenTradeRecipeBuilder {
    private final ResourceLocation id;
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();

    public static ElvenTradeRecipeBuilder builder(String name) {
        return new ElvenTradeRecipeBuilder(GTOCore.id((String)("elven_trade/" + name)));
    }

    private ElvenTradeRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    private ElvenTradeRecipeBuilder addInput(Ingredient input) {
        if (input != null) {
            this.inputs.add(input);
        }
        return this;
    }

    public ElvenTradeRecipeBuilder addInput(ItemLike item) {
        return this.addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ElvenTradeRecipeBuilder addInput(TagKey<Item> tag) {
        return this.addInput(Ingredient.m_204132_(tag));
    }

    private ElvenTradeRecipeBuilder addOutput(ItemStack output) {
        if (output != null) {
            this.outputs.add(output);
        }
        return this;
    }

    public ElvenTradeRecipeBuilder addOutput(ItemLike output) {
        return this.addOutput(new ItemStack(output));
    }

    public ElvenTradeRecipeBuilder addOutput(ItemLike output, int count) {
        return this.addOutput(new ItemStack(output, count));
    }

    public void save() {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("No inputs added to elven trade recipe");
        }
        if (this.outputs.isEmpty()) {
            throw new IllegalStateException("No outputs specified for elven trade recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new ElvenTradeRecipe(this.id, this.outputs.toArray(new ItemStack[0]), this.inputs.toArray(new Ingredient[0])));
    }
}

