/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.ManaInfusionRecipe;
import vazkii.botania.common.crafting.StateIngredientHelper;

public final class ManaInfusionRecipeBuilder {
    private final ResourceLocation id;
    private Ingredient input;
    private ItemStack output;
    private int mana;
    private String group = "";
    @Nullable
    private StateIngredient catalyst;

    public static ManaInfusionRecipeBuilder builder(String name) {
        return new ManaInfusionRecipeBuilder(GTOCore.id((String)("mana_infusion/" + name)));
    }

    private ManaInfusionRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ManaInfusionRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public ManaInfusionRecipeBuilder input(ItemLike item) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ManaInfusionRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.m_204132_(tag));
    }

    public ManaInfusionRecipeBuilder output(ItemLike output) {
        return this.output(new ItemStack(output));
    }

    public ManaInfusionRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public ManaInfusionRecipeBuilder mana(int mana) {
        this.mana = mana;
        return this;
    }

    public ManaInfusionRecipeBuilder group(String group) {
        if (group != null) {
            this.group = group;
        }
        return this;
    }

    public ManaInfusionRecipeBuilder alchemyCatalyst() {
        this.catalyst = StateIngredientHelper.of((Block)BotaniaBlocks.alchemyCatalyst);
        return this;
    }

    public ManaInfusionRecipeBuilder conjurationCatalyst() {
        this.catalyst = StateIngredientHelper.of((Block)BotaniaBlocks.conjurationCatalyst);
        return this;
    }

    public ManaInfusionRecipeBuilder customCatalyst(Block catalyst) {
        if (catalyst != null) {
            this.catalyst = StateIngredientHelper.of((Block)catalyst);
        }
        return this;
    }

    public void save() {
        GTRecipes.RECIPE_MAP.put(this.id, new ManaInfusionRecipe(this.id, this.output, this.input, this.mana, this.group, this.catalyst));
    }
}

