/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import io.github.lounode.extrabotany.common.crafting.PedestalsRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class PedestalRecipeBuilder {
    private final ResourceLocation id;
    private ItemStack output;
    private Ingredient input;
    private Ingredient smashTools;
    private int strike = 1;
    private int exp = 0;

    public static PedestalRecipeBuilder builder(String name) {
        return new PedestalRecipeBuilder(GTOCore.id((String)("pedestal/" + name)));
    }

    private PedestalRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public PedestalRecipeBuilder output(ItemLike output) {
        return this.output(new ItemStack(output));
    }

    public PedestalRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public PedestalRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public PedestalRecipeBuilder input(ItemLike item) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public PedestalRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.m_204132_(tag));
    }

    public PedestalRecipeBuilder smashTools(Ingredient smashTools) {
        this.smashTools = smashTools;
        return this;
    }

    public PedestalRecipeBuilder smashTools(ItemLike item) {
        return this.smashTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public PedestalRecipeBuilder smashTools(TagKey<Item> tag) {
        return this.smashTools(Ingredient.m_204132_(tag));
    }

    public PedestalRecipeBuilder strike(int strike) {
        this.strike = strike;
        return this;
    }

    public PedestalRecipeBuilder exp(int exp) {
        this.exp = exp;
        return this;
    }

    public void save() {
        if (this.output == null) {
            throw new IllegalStateException("No output specified for pedestal recipe");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input specified for pedestal recipe");
        }
        if (this.smashTools == null) {
            throw new IllegalStateException("No smash tools specified for pedestal recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, new PedestalsRecipe(this.id, this.output, this.smashTools, this.input, this.strike, this.exp));
    }
}

