/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.botania;

import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gtolib.GTOCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.crafting.recipe.HeadRecipe;

public final class RunicAltarRecipeBuilder {
    private final ResourceLocation id;
    private ItemStack output;
    private int mana;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private boolean isHeadRecipe = false;

    public static RunicAltarRecipeBuilder builder(String name) {
        return new RunicAltarRecipeBuilder(GTOCore.id((String)("runic_altar/" + name)));
    }

    private RunicAltarRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public RunicAltarRecipeBuilder output(ItemLike output) {
        return this.output(new ItemStack(output));
    }

    public RunicAltarRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public RunicAltarRecipeBuilder mana(int mana) {
        this.mana = mana;
        return this;
    }

    public RunicAltarRecipeBuilder addIngredient(Ingredient ingredient) {
        if (ingredient != null) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public RunicAltarRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RunicAltarRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.m_204132_(tag));
    }

    public RunicAltarRecipeBuilder setHeadRecipe(Boolean setHeadRecipe) {
        this.isHeadRecipe = setHeadRecipe;
        return this;
    }

    public void save() {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients added to runic altar recipe");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output specified for runic altar recipe");
        }
        GTRecipes.RECIPE_MAP.put(this.id, this.isHeadRecipe ? new HeadRecipe(this.id, this.output, this.mana, this.ingredients.toArray(new Ingredient[0])) : new RunicAltarRecipe(this.id, this.output, this.mana, this.ingredients.toArray(new Ingredient[0])));
    }
}

