/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.builder.research.ExResearchManager;
import com.gtolib.api.recipe.RecipeBuilder;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class DataCrystalConstruction {
    private ItemStack itemStack;
    private FluidStack fluidStack;
    private int dataTier;
    private ItemStack dataItem;
    private int dataCrystal;
    private final Boolean recipe;
    private ItemStack catalyst;
    private int duration = 0;
    private long eut = GTValues.VA[6];
    private int cwut = 0;
    private int totalCWU = 0;

    public static DataCrystalConstruction buildDataCrystal(Boolean recipe) {
        return new DataCrystalConstruction(recipe);
    }

    private DataCrystalConstruction(Boolean recipe) {
        this.recipe = recipe;
    }

    public DataCrystalConstruction input(ItemStack itemStack, int dataTier, int dataCrystal) {
        if (this.fluidStack != null) {
            this.fluidStack = null;
        }
        this.itemStack = itemStack;
        this.dataTier = dataTier;
        this.dataCrystal = dataCrystal;
        this.dataItem = ExResearchManager.getDataCrystalItem(dataCrystal);
        return this;
    }

    public DataCrystalConstruction input(FluidStack fluidStack, int dataTier, int dataCrystal) {
        if (this.itemStack != null) {
            this.itemStack = null;
        }
        int amount = (fluidStack.getAmount() + 999) / 1000;
        fluidStack.setAmount(amount * 1000);
        this.fluidStack = fluidStack;
        this.dataTier = dataTier;
        this.dataCrystal = dataCrystal;
        this.dataItem = ExResearchManager.getDataCrystalItem(dataCrystal);
        return this;
    }

    public DataCrystalConstruction catalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public DataCrystalConstruction duration(int duration) {
        this.duration = duration;
        return this;
    }

    public DataCrystalConstruction EUt(long eut) {
        this.eut = eut;
        return this;
    }

    public DataCrystalConstruction CWUt(int cwut) {
        this.cwut = cwut;
        this.totalCWU = cwut * 800;
        return this;
    }

    public DataCrystalConstruction CWUt(int cwut, int totalCWU) {
        this.cwut = cwut;
        this.totalCWU = totalCWU;
        return this;
    }

    public void save() {
        String recipeId;
        if (this.dataItem == null) {
            throw new IllegalStateException("Missing data crystal");
        }
        if (this.dataCrystal < 1 || this.dataCrystal > 5) {
            throw new IllegalStateException("DataCrystal Out of index");
        }
        ItemStack dataStack = this.dataItem;
        if (this.itemStack != null) {
            ExResearchManager.writeScanningResearchToNBT(dataStack.m_41784_(), this.itemStack, this.dataTier, this.dataCrystal);
            recipeId = ExResearchManager.itemStackToString(this.itemStack);
        } else if (this.fluidStack != null) {
            ExResearchManager.writeScanningResearchToNBT(dataStack.m_41784_(), this.fluidStack, this.dataTier, this.dataCrystal);
            recipeId = ExResearchManager.fluidStackToString(this.fluidStack);
        } else {
            throw new IllegalStateException("The scanned item or fluid is missing");
        }
        if (this.recipe == null) {
            return;
        }
        if (!this.recipe.booleanValue()) {
            if (this.itemStack == null) {
                throw new IllegalStateException("The scanned recipe can only use item");
            }
            GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(recipeId).inputItems(ExResearchManager.EmptyDataCrystalList.get(this.dataCrystal)).inputItems(this.itemStack).outputItems(dataStack).duration(this.duration).EUt(this.eut).save();
        } else {
            if (this.cwut > this.totalCWU) {
                throw new IllegalStateException("Total CWU cannot be greater than CWU/t!");
            }
            if (this.catalyst == null) {
                throw new IllegalStateException("Catalyst input required");
            }
            RecipeBuilder builder = GTORecipeTypes.CRYSTAL_SCAN_RECIPES.recipeBuilder(recipeId).notConsumable(this.catalyst).inputItems(ExResearchManager.EmptyDataCrystalList.get(this.dataCrystal));
            if (this.itemStack != null) {
                builder.inputItems(this.itemStack);
            } else {
                builder.inputFluids(this.fluidStack);
            }
            builder.outputItems(dataStack).EUt(this.eut).CWUt(this.cwut).totalCWU(this.totalCWU).save();
        }
    }
}

