/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.builder.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.builder.research.ExResearchManager;
import com.gtolib.api.recipe.RecipeBuilder;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class RecipesDataGenerateRecipeBuilder {
    private final GTRecipeType recipeType;
    private Item DataItem;
    private int chance;
    private String researchId;
    private int[] inputAnalyzeData = new int[0];
    private ItemStack catalyst1;
    private ItemStack catalyst2;
    private long eut = GTValues.VA[6];
    private int cwut = 0;
    private int totalCWU = 0;

    public static RecipesDataGenerateRecipeBuilder buildRecipe(GTRecipeType recipeType) {
        return new RecipesDataGenerateRecipeBuilder(recipeType);
    }

    private RecipesDataGenerateRecipeBuilder(GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }

    public RecipesDataGenerateRecipeBuilder catalyst1(ItemStack catalyst) {
        this.catalyst1 = catalyst;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder catalyst2(ItemStack catalyst) {
        this.catalyst2 = catalyst;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder getDataItem(int tire) {
        this.DataItem = ExResearchManager.DataItemList.get(tire);
        return this;
    }

    public RecipesDataGenerateRecipeBuilder getDataItem(Item dataItem) {
        this.DataItem = dataItem;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder inputData(int data) {
        if (this.inputAnalyzeData.length > 8) {
            return this;
        }
        this.inputAnalyzeData = Arrays.copyOf(this.inputAnalyzeData, this.inputAnalyzeData.length + 1);
        this.inputAnalyzeData[this.inputAnalyzeData.length - 1] = data;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder outputSynthetic(ItemStack itemStack, int chance) {
        this.researchId = GTStringUtils.itemStackToString((ItemStack)itemStack);
        this.chance = chance;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder outputSynthetic(FluidStack fluidStack, int chance) {
        this.researchId = GTStringUtils.fluidStackToString((FluidStack)fluidStack);
        this.chance = chance;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder EUt(long eut) {
        this.eut = eut;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder CWUt(int cwut) {
        this.cwut = cwut;
        this.totalCWU = cwut * 800;
        return this;
    }

    public RecipesDataGenerateRecipeBuilder CWUt(int cwut, int totalCWU) {
        this.cwut = cwut;
        this.totalCWU = totalCWU;
        return this;
    }

    public void save() {
        if (this.cwut > this.totalCWU) {
            throw new IllegalStateException("Total CWU cannot be greater than CWU/t!");
        }
        if (this.catalyst1 == null || this.catalyst2 == null) {
            throw new IllegalStateException("Catalyst input required");
        }
        if (this.DataItem == null) {
            throw new IllegalStateException("DataItem input required");
        }
        if (this.researchId == null) {
            throw new IllegalStateException("Output Synthetic required");
        }
        ItemStack dataStack = this.DataItem.m_7968_();
        ResearchManager.writeResearchToNBT((CompoundTag)dataStack.m_41784_(), (String)this.researchId, (GTRecipeType)this.recipeType);
        RecipeBuilder build = GTORecipeTypes.RECIPES_DATA_GENERATE_RECIPES.recipeBuilder(FormattingUtil.toLowerCaseUnderscore((String)this.researchId));
        build.notConsumable(this.catalyst1).notConsumable(this.catalyst2).inputItems(this.DataItem);
        for (int inputAnalyzeDatum : this.inputAnalyzeData) {
            build.notConsumable(ExResearchManager.getDataCrystal(inputAnalyzeDatum));
        }
        build.chancedOutput(dataStack, this.chance, 0).EUt(this.eut).CWUt(this.cwut).totalCWU(this.totalCWU).save();
    }
}

