/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.classified;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import earth.terrarium.adastra.common.registry.ModFluids;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

final class DrillingModule {
    private static final Item[] drones = new Item[]{GTOItems.SPACE_DRONE_MK1.m_5456_(), GTOItems.SPACE_DRONE_MK2.m_5456_(), GTOItems.SPACE_DRONE_MK3.m_5456_(), GTOItems.SPACE_DRONE_MK4.m_5456_(), GTOItems.SPACE_DRONE_MK5.m_5456_(), GTOItems.SPACE_DRONE_MK6.m_5456_()};
    private static final FluidStack[][] fuels = new FluidStack[][]{{GTMaterials.RocketFuel.getFluid(10000), GTOMaterials.RocketFuelRp1.getFluid(6000)}, {GTOMaterials.DenseHydrazineFuelMixture.getFluid(10000), GTOMaterials.RocketFuelCn3h7o3.getFluid(6000)}, {GTOMaterials.RocketFuelH8n4c2o4.getFluid(10000), new FluidStack((Fluid)ModFluids.CRYO_FUEL.get(), 6000)}, new FluidStack[0], new FluidStack[0], new FluidStack[0]};
    private static final int[] baseTime = new int[]{600, 400};

    DrillingModule() {
    }

    private static void buildDrillingModule(int circuit, int minDroneTire, FluidStack fluidStack) {
        for (int i = minDroneTire - 1; i < 6; ++i) {
            for (int j = 0; j < fuels[minDroneTire - 1].length; ++j) {
                GTORecipeTypes.DRILLING_MODULE_RECIPES.recipeBuilder("space_fluid_" + circuit + "_" + i + "_" + j).notConsumable(drones[i], 16).circuitMeta(circuit).inputFluids(fuels[minDroneTire - 1][j]).outputFluids(fluidStack).EUt((long)GTValues.VA[8 + i]).duration(baseTime[j] >> i).save();
            }
        }
    }

    public static void init() {
        DrillingModule.buildDrillingModule(1, 1, GTMaterials.Hydrogen.getFluid(1000000));
        DrillingModule.buildDrillingModule(2, 1, GTMaterials.Helium.getFluid(1000000));
        DrillingModule.buildDrillingModule(3, 1, GTMaterials.Nitrogen.getFluid(1000000));
        DrillingModule.buildDrillingModule(4, 1, GTMaterials.Methane.getFluid(1000000));
        DrillingModule.buildDrillingModule(5, 1, GTMaterials.SulfurDioxide.getFluid(1000000));
        DrillingModule.buildDrillingModule(6, 1, GTMaterials.CarbonDioxide.getFluid(1000000));
        DrillingModule.buildDrillingModule(7, 1, GTMaterials.NitrogenDioxide.getFluid(1000000));
        DrillingModule.buildDrillingModule(8, 1, GTMaterials.Ammonia.getFluid(1000000));
        DrillingModule.buildDrillingModule(9, 1, GTMaterials.Chlorine.getFluid(1000000));
        DrillingModule.buildDrillingModule(10, 1, GTMaterials.Fluorine.getFluid(1000000));
        DrillingModule.buildDrillingModule(11, 1, GTMaterials.CarbonMonoxide.getFluid(1000000));
        DrillingModule.buildDrillingModule(12, 1, GTMaterials.Oxygen.getFluid(1000000));
        DrillingModule.buildDrillingModule(13, 2, GTOMaterials.UnknowWater.getFluid(1000000));
        DrillingModule.buildDrillingModule(14, 2, GTMaterials.Neon.getFluid(1000000));
        DrillingModule.buildDrillingModule(15, 2, GTMaterials.Argon.getFluid(1000000));
        DrillingModule.buildDrillingModule(16, 2, GTMaterials.Krypton.getFluid(1000000));
        DrillingModule.buildDrillingModule(17, 2, GTMaterials.Xenon.getFluid(1000000));
        DrillingModule.buildDrillingModule(18, 2, GTMaterials.Radon.getFluid(1000000));
        DrillingModule.buildDrillingModule(19, 2, GTMaterials.Helium3.getFluid(1000000));
        DrillingModule.buildDrillingModule(20, 3, GTMaterials.Deuterium.getFluid(1000000));
        DrillingModule.buildDrillingModule(21, 3, GTMaterials.Tritium.getFluid(1000000));
        DrillingModule.buildDrillingModule(22, 3, GTMaterials.HeavyFuel.getFluid(1000000));
        DrillingModule.buildDrillingModule(23, 3, GTMaterials.LightFuel.getFluid(1000000));
        DrillingModule.buildDrillingModule(24, 3, GTMaterials.Naphtha.getFluid(1000000));
        DrillingModule.buildDrillingModule(25, 3, GTMaterials.RefineryGas.getFluid(1000000));
        DrillingModule.buildDrillingModule(26, 3, GTMaterials.CoalGas.getFluid(1000000));
        DrillingModule.buildDrillingModule(27, 3, GTMaterials.Bromine.getFluid(1000000));
        DrillingModule.buildDrillingModule(28, 3, GTOMaterials.BarnardaAir.getFluid(1000000));
        GTORecipeTypes.DRILLING_MODULE_RECIPES.recipeBuilder("space_fluid_29").notConsumable(GTOItems.SPACE_DRONE_MK6.m_5456_(), 64).circuitMeta(29).inputFluids(GTOMaterials.StellarEnergyRocketFuel, 10000).outputFluids(GTOMaterials.WhiteDwarfMatter, 100000).EUt(0x1E000000L).duration(750).save();
        GTORecipeTypes.DRILLING_MODULE_RECIPES.recipeBuilder("space_fluid_30").notConsumable(GTOItems.SPACE_DRONE_MK6.m_5456_(), 64).circuitMeta(30).inputFluids(GTOMaterials.StellarEnergyRocketFuel, 10000).outputFluids(GTOMaterials.BlackDwarfMatter, 100000).EUt(0x1E000000L).duration(750).save();
    }
}

