/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.classified;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.recipe.condition.GalaxyCondition;
import com.gtolib.api.data.Galaxy;
import com.gtolib.api.recipe.RecipeBuilder;
import java.util.function.IntFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

final class SpaceDebrisCollection {
    private static Item[] drones = null;
    private static final IntFunction<Object> chargeable = tier -> switch (tier) {
        case 2 -> CustomTags.EV_BATTERIES;
        case 3 -> CustomTags.IV_BATTERIES;
        case 4 -> CustomTags.LuV_BATTERIES;
        case 5 -> CustomTags.ZPM_BATTERIES;
        case 6 -> CustomTags.UV_BATTERIES;
        case 7 -> CustomTags.UHV_BATTERIES;
        case 8 -> GTOItems.REALLY_MAX_BATTERY;
        default -> null;
    };

    SpaceDebrisCollection() {
    }

    public static void init() {
        SpaceDebrisCollection.cosmicPile(Galaxy.SOLAR, 1, 120, SpaceDebrisCollection.output(GTOMaterials.CosmicDust, 2500, 500), SpaceDebrisCollection.output(GTOMaterials.FrozenVolatileIce, 2500, 500), SpaceDebrisCollection.output(GTOMaterials.AerogelPorousParticles, 2500, 500), SpaceDebrisCollection.output(GTOMaterials.MetalCompoundParticles, 2500, 500));
        SpaceDebrisCollection.cosmicPile(Galaxy.PROXIMA_CENTAURI, 2, 300, SpaceDebrisCollection.output(GTOMaterials.CosmicDust, 2300, 600), SpaceDebrisCollection.output(GTOMaterials.FrozenVolatileIce, 2100, 400), SpaceDebrisCollection.output(GTOMaterials.AerogelPorousParticles, 2800, 100), SpaceDebrisCollection.output(GTOMaterials.PlasmaQuenchedBeads, 1500, 300), SpaceDebrisCollection.output(GTOMaterials.DarkMatterBoundNodes, 1300, 200));
        SpaceDebrisCollection.cosmicPile(Galaxy.BARNARDA, 3, 500, SpaceDebrisCollection.output(GTOMaterials.CosmicDust, 1700, 300), SpaceDebrisCollection.output(GTOMaterials.FrozenVolatileIce, 2100, 700), SpaceDebrisCollection.output(GTOMaterials.AerogelPorousParticles, 1200, 100), SpaceDebrisCollection.output(GTOMaterials.PlasmaQuenchedBeads, 2500, 300), SpaceDebrisCollection.output(GTOMaterials.AlienAlgae, 1240, 600), SpaceDebrisCollection.output((ItemLike)GTOItems.NEUTRON_PILE.m_5456_(), 60, 10), SpaceDebrisCollection.output(GTOMaterials.DarkMatterBoundNodes, 800, 200), SpaceDebrisCollection.output(GTOMaterials.StellarMatterRemnantDust, 400, 100));
    }

    private static void cosmicPile(Galaxy galaxy, int circuitMeta, int time, CosmicPileOutput ... outputs) {
        if (drones == null) {
            drones = new Item[]{GTOItems.SMALL_SHUTTLE_MK1.m_5456_(), GTOItems.SMALL_SHUTTLE_MK2.m_5456_(), GTOItems.SPACE_DRONE_MK1.m_5456_(), GTOItems.SPACE_DRONE_MK2.m_5456_(), GTOItems.SPACE_DRONE_MK3.m_5456_(), GTOItems.SPACE_DRONE_MK4.m_5456_(), GTOItems.SPACE_DRONE_MK5.m_5456_(), GTOItems.SPACE_DRONE_MK6.m_5456_()};
        }
        for (int i = 0; i < drones.length; ++i) {
            RecipeBuilder builder = GTORecipeTypes.SPACE_DEBRIS_COLLECTION_RECIPES.builder("cosmic_pile_" + galaxy.name().toLowerCase() + "_drone_mk" + i, new Object[0]).EUt((long)(GTValues.VA[7] / 2)).duration(time * (int)Math.pow(1.5, i)).addCondition((RecipeCondition)new GalaxyCondition(galaxy));
            if (i >= 2) {
                Object battery = chargeable.apply(i);
                if (battery instanceof TagKey) {
                    TagKey tag = (TagKey)battery;
                    builder.inputItems(Ingredient.m_204132_((TagKey)tag));
                } else if (battery instanceof ItemLike) {
                    ItemLike item = (ItemLike)battery;
                    builder.inputItems(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
                }
                builder.notConsumable(drones[i]);
            } else {
                builder.inputItems(drones[i]);
            }
            for (CosmicPileOutput output : outputs) {
                builder.chancedOutput(output.item.m_5456_(), output.baseMultiplier * (1 << i), output.chancePer100Milli, output.chanceBoostPer100Milli);
            }
            builder.circuitMeta(circuitMeta).save();
        }
    }

    private static CosmicPileOutput output(ItemLike item, int chancePer100Milli, int chanceBoostPer100Milli) {
        return new CosmicPileOutput(item, 1, chancePer100Milli, chanceBoostPer100Milli);
    }

    private static CosmicPileOutput output(Material material, int chancePer100Milli, int chanceBoostPer100Milli) {
        return new CosmicPileOutput((ItemLike)ChemicalHelper.get((TagPrefix)TagPrefix.dust, (Material)material).m_41720_(), 1, chancePer100Milli, chanceBoostPer100Milli);
    }

    private record CosmicPileOutput(ItemLike item, int baseMultiplier, int chancePer100Milli, int chanceBoostPer100Milli) {
    }
}

