/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.item.tool.CoatedTurbineRotorBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gtocore.api.data.material.GTOMaterialFlags;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeCategories;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.item.DiscItem;
import com.gtolib.api.data.chemical.material.GTOMaterialBuilder;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.utils.GTOUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

final class GTOPartsRecipeHandler {
    static List<Material> rotors = null;

    GTOPartsRecipeHandler() {
    }

    static void run(@NotNull Material material) {
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.rod, (Material)material)) {
            GTOPartsRecipeHandler.processStick(material);
            if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.rodLong, (Material)material)) {
                GTOPartsRecipeHandler.processLongStick(material);
            }
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.plate, (Material)material)) {
            GTOPartsRecipeHandler.processPlate(material);
            GTOPartsRecipeHandler.processPlateDouble(material);
            GTOPartsRecipeHandler.processPlateDense(material);
        }
        if (rotors == null) {
            rotors = GTCEuAPI.materialManager.getRegisteredMaterials().stream().filter(m -> GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.turbineRotor, (Material)m)).toList();
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.turbineBlade, (Material)material)) {
            GTOPartsRecipeHandler.processTurbine(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.rotor, (Material)material)) {
            GTOPartsRecipeHandler.processRotor(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.bolt, (Material)material)) {
            GTOPartsRecipeHandler.processBolt(material);
            GTOPartsRecipeHandler.processScrew(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.wireFine, (Material)material)) {
            GTOPartsRecipeHandler.processFineWire(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.foil, (Material)material)) {
            GTOPartsRecipeHandler.processFoil(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.lens, (Material)material)) {
            GTOPartsRecipeHandler.processLens(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.gear, (Material)material)) {
            GTOPartsRecipeHandler.processGear(GTOTagPrefix.gear, material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.gearSmall, (Material)material)) {
            GTOPartsRecipeHandler.processGear(GTOTagPrefix.gearSmall, material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.ring, (Material)material)) {
            GTOPartsRecipeHandler.processRing(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.springSmall, (Material)material)) {
            GTOPartsRecipeHandler.processSpringSmall(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.spring, (Material)material)) {
            GTOPartsRecipeHandler.processSpring(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.round, (Material)material)) {
            GTOPartsRecipeHandler.processRound(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.NANITES, (Material)material)) {
            GTOPartsRecipeHandler.processManoswarm(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material)) {
            GTOPartsRecipeHandler.processcurvedPlate(material);
        }
        if (material.hasFlag(GTOMaterialFlags.GENERATE_COMPONENT)) {
            GTOPartsRecipeHandler.processMotorEnclosure(material);
            GTOPartsRecipeHandler.processPumpBarrel(material);
            GTOPartsRecipeHandler.processPistonHousing(material);
            GTOPartsRecipeHandler.processEmitterBases(material);
            GTOPartsRecipeHandler.processSensorCasing(material);
            GTOPartsRecipeHandler.processFieldGeneratorCasing(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.CATALYST, (Material)material)) {
            GTOPartsRecipeHandler.processCatalyst(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.ROUGH_BLANK, (Material)material)) {
            GTOPartsRecipeHandler.processroughBlank(material);
        }
        if (GTOUtils.isGeneration((TagPrefix)GTOTagPrefix.ARTIFICIAL_GEM, (Material)material)) {
            GTOPartsRecipeHandler.processCrystallization(material);
        }
    }

    private static void processScrew(Material material) {
        ItemStack screwStack = ChemicalHelper.get((TagPrefix)TagPrefix.screw, (Material)material);
        if (screwStack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.bolt, (Material)material);
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_bolt_to_screw").inputItems(stack).outputItems(screwStack).duration(Math.max(1, mass / 8)).EUt(4L).save();
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("screw_%s", material.getName()), (ItemStack)screwStack, (Object[])new Object[]{"fX", "X ", Character.valueOf('X'), stack});
        }
    }

    private static void processFoil(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.foil, (Material)material, (int)4);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)TagPrefix.plate, (Material)material);
        if (!material.hasFlag(MaterialFlags.NO_SMASHING) && mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("foil_%s", material.getName()), (ItemStack)stack.m_255036_(2), (Object[])new Object[]{"hP ", Character.valueOf('P'), stack1});
        }
        GTORecipeTypes.CLUSTER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_foil").inputItems(stack1).outputItems(stack).duration(mass).EUt(24L).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_foil").inputItems(GTOTagPrefix.ingot, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
        }
    }

    private static void processLens(@NotNull Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.lens, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_plate_to_lens").inputItems(GTOTagPrefix.plate, material).outputItems(stack).outputItems(GTOTagPrefix.dustSmall, material).duration(1200).EUt(120L).save();
        if (!ChemicalHelper.get((TagPrefix)GTOTagPrefix.gemExquisite, (Material)material).m_41619_()) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_gem_to_lens").inputItems(GTOTagPrefix.gemExquisite, material).outputItems(stack).outputItems(GTOTagPrefix.dust, material, 2).duration(2400).EUt(30L).save();
        }
    }

    private static void processFineWire(Material material) {
        ItemStack fineWireStack = ChemicalHelper.get((TagPrefix)TagPrefix.wireFine, (Material)material);
        if (fineWireStack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (!ChemicalHelper.get((TagPrefix)GTOTagPrefix.foil, (Material)material).m_41619_() && mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapelessRecipe((String)String.format("fine_wire_%s", material.getName()), (ItemStack)fineWireStack, (Object[])new Object[]{Character.valueOf('x'), new MaterialEntry(GTOTagPrefix.foil, material)});
        }
        int voltageMultiplier = GTOUtils.getVoltageMultiplier((Material)material);
        if (material.hasProperty(PropertyKey.WIRE)) {
            GTORecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_to_fine_wire").inputItems(GTOTagPrefix.wireGtSingle, material).outputItems(fineWireStack.m_255036_(4)).duration(mass * 3 / 2).EUt((long)voltageMultiplier).save();
        } else {
            GTORecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "ingot_to_fine_wire").inputItems(GTOTagPrefix.ingot, material).outputItems(fineWireStack.m_255036_(8)).duration(mass * 3).EUt((long)voltageMultiplier).save();
        }
    }

    private static void processGear(TagPrefix gearPrefix, Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)gearPrefix, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (gearPrefix == GTOTagPrefix.gear && material.hasProperty(PropertyKey.INGOT)) {
            int voltageMultiplier = GTOUtils.getVoltageMultiplier((Material)material);
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_gear").inputItems(GTOTagPrefix.ingot, material, 4).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(gearPrefix, material).duration(mass * 5).EUt(8L * (long)voltageMultiplier).save();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_gear").inputItems(GTOTagPrefix.dust, material, 4).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(gearPrefix, material).duration(mass * 5).EUt(8L * (long)voltageMultiplier).save();
            }
        }
        if (material.hasFluid()) {
            boolean isSmall = gearPrefix == GTOTagPrefix.gearSmall;
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_" + gearPrefix.name).notConsumable((Supplier)(isSmall ? GTItems.SHAPE_MOLD_GEAR_SMALL : GTItems.SHAPE_MOLD_GEAR)).inputFluids(material.getFluid(144 * (isSmall ? 1 : 4))).outputItems(stack).duration(mass * (isSmall ? 2 : 8)).EUt((long)GTValues.VA[1]).save();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (gearPrefix == GTOTagPrefix.gearSmall) {
                if (mass < 240 && material.getBlastTemperature() < 3600) {
                    VanillaRecipeHelper.addShapedRecipe((String)String.format("small_gear_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)GTOTagPrefix.gearSmall, (Material)material), (Object[])new Object[]{" R ", "hPx", " R ", Character.valueOf('R'), new MaterialEntry(GTOTagPrefix.rod, material), Character.valueOf('P'), new MaterialEntry(GTOTagPrefix.plate, material)});
                }
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_small_gear").inputItems(GTOTagPrefix.ingot, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_small_gear").inputItems(GTOTagPrefix.dust, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
                }
            } else if (mass < 240 && material.getBlastTemperature() < 3600) {
                VanillaRecipeHelper.addShapedRecipe((String)String.format("gear_%s", material.getName()), (ItemStack)stack, (Object[])new Object[]{"RPR", "PwP", "RPR", Character.valueOf('P'), new MaterialEntry(GTOTagPrefix.plate, material), Character.valueOf('R'), new MaterialEntry(GTOTagPrefix.rod, material)});
            }
        }
    }

    private static void processPlate(Material material) {
        FluidStack fluidStack;
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.plate, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        if (material.hasFluid() && !(fluidStack = ((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom(144)).isEmpty()) {
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_plate").notConsumable((Supplier)GTItems.SHAPE_MOLD_PLATE).inputFluids(fluidStack).outputItems(stack).duration((int)material.getMass()).EUt((long)GTValues.VA[0]).save();
        }
    }

    private static void processPlateDouble(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.plateDouble, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (!material.hasFlag(MaterialFlags.NO_SMASHING) && mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("plate_double_%s", material.getName()), (ItemStack)stack, (Object[])new Object[]{"h", "P", "P", Character.valueOf('P'), new MaterialEntry(GTOTagPrefix.plate, material)});
        }
        GTORecipeTypes.ROLLING_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_double_plate").EUt(96L).duration(mass << 1).inputItems(GTOTagPrefix.ingot, material, 2).outputItems(stack).circuitMeta(2).save();
    }

    private static void processPlateDense(Material material) {
        if (!material.hasFlag(MaterialFlags.GENERATE_DENSE)) {
            return;
        }
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.plateDense, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (material.hasProperty(PropertyKey.INGOT)) {
            GTORecipeTypes.ROLLING_RECIPES.recipeBuilder("rolling_" + material.getName() + "_block_to_dense_plate").inputItems(GTOTagPrefix.block, material).outputItems(stack).duration(mass * 11).circuitMeta(3).EUt(96L).save();
        } else {
            GTORecipeTypes.ROLLING_RECIPES.recipeBuilder("rolling_" + material.getName() + "_plate_to_dense_plate").inputItems(GTOTagPrefix.plate, material, 9).outputItems(stack).duration(mass * 11).circuitMeta(3).EUt(96L).save();
        }
    }

    private static void processRing(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.ring, (Material)material, (int)4);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_ring").inputItems(GTOTagPrefix.ingot, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_RING).outputItems(stack).duration(mass << 1).EUt(6L * (long)GTOUtils.getVoltageMultiplier((Material)material)).save();
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            GTORecipeTypes.BENDER_RECIPES.recipeBuilder("bender_" + material.getName() + "_rod_to_ring").inputItems(GTOTagPrefix.rod, material).outputItems(stack.m_255036_(2)).duration(mass).EUt(16L).circuitMeta(2).save();
        }
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            if (mass < 240 && material.getBlastTemperature() < 3600) {
                VanillaRecipeHelper.addShapedRecipe((String)String.format("ring_%s", material.getName()), (ItemStack)stack.m_255036_(1), (Object[])new Object[]{"h ", " X", Character.valueOf('X'), new MaterialEntry(GTOTagPrefix.rod, material)});
            }
        } else {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_ring").inputItems(GTOTagPrefix.dust, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_RING).outputItems(stack).duration(mass << 1).EUt(6L * (long)GTOUtils.getVoltageMultiplier((Material)material)).save();
        }
    }

    private static void processSpringSmall(Material material) {
        ItemStack springstack = ChemicalHelper.get((TagPrefix)TagPrefix.springSmall, (Material)material);
        if (springstack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rod, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("spring_small_%s", material.getName()), (ItemStack)springstack, (Object[])new Object[]{" s ", "fRx", Character.valueOf('R'), stack});
        }
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_rod_to_small_spring").duration(Math.max(1, mass / 2)).EUt((long)GTValues.VA[0]).inputItems(stack).outputItems(springstack.m_255036_(2)).circuitMeta(1).save();
    }

    private static void processSpring(Material material) {
        ItemStack springstack = ChemicalHelper.get((TagPrefix)TagPrefix.spring, (Material)material);
        if (springstack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rodLong, (Material)material);
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder(material.getName() + "_long_rod_to_spring").inputItems(stack).outputItems(springstack).circuitMeta(1).duration(mass).EUt(16L).save();
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("spring_%s", material.getName()), (ItemStack)springstack, (Object[])new Object[]{" s ", "fRx", " R ", Character.valueOf('R'), stack});
        }
    }

    private static void processRotor(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.rotor, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack ringStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.ring, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("rotor_%s", material.getName()), (ItemStack)stack, (Object[])new Object[]{"ChC", "SRf", "CdC", Character.valueOf('C'), curvedPlateStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material), Character.valueOf('R'), ringStack});
        }
        if (material.hasFluid()) {
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_rotor").notConsumable((Supplier)GTItems.SHAPE_MOLD_ROTOR).inputFluids(material.getFluid(720)).outputItems(stack).duration(mass * 6).EUt((long)GTValues.VA[1]).save();
        }
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_rotor").inputItems(GTOTagPrefix.ingot, material, 5).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(stack).duration(mass << 2).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_to_rotor").inputItems(curvedPlateStack.m_255036_(4)).inputItems(ringStack).circuitMeta(1).outputItems(stack).duration(mass).EUt(30L).save();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_rotor").inputItems(GTOTagPrefix.dust, material, 5).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(stack).duration(mass << 2).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
        }
    }

    private static void processBolt(@NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(GTOTagPrefix.bolt)) {
            return;
        }
        ItemStack boltStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.bolt, (Material)(material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material), (int)8);
        ItemStack ingotStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.ingot, (Material)material);
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_screw_to_bolt").inputItems(GTOTagPrefix.screw, material).outputItems(boltStack.m_255036_(1)).duration(20).EUt(24L).save();
        if (!boltStack.m_41619_() && !ingotStack.m_41619_()) {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_bolt").inputItems(GTOTagPrefix.ingot, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(boltStack).duration(15).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_bolt").inputItems(GTOTagPrefix.dust, material).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(boltStack).duration(15).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
            }
        }
    }

    private static void processStick(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rod, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        if (material.hasProperty(PropertyKey.GEM) || material.hasProperty(PropertyKey.INGOT)) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_to_rod").inputItems(material.hasProperty(PropertyKey.GEM) ? GTOTagPrefix.gem : GTOTagPrefix.ingot, material).outputItems(stack.m_255036_(2)).duration(mass << 1).EUt((long)GTOUtils.getVoltageMultiplier((Material)material)).save();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.bolt, (Material)material, (int)4);
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_rod_to_bolt").inputItems(stack).outputItems(boltStack).duration(mass << 1).EUt(4L).save();
            if (mass < 240 && material.getBlastTemperature() < 3600) {
                VanillaRecipeHelper.addShapedRecipe((String)String.format("bolt_saw_%s", material.getName()), (ItemStack)boltStack.m_255036_(2), (Object[])new Object[]{"s ", " X", Character.valueOf('X'), stack});
            }
        }
    }

    private static void processLongStick(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)TagPrefix.rodLong, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack stickStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rod, (Material)material, (int)2);
        int mass = (int)material.getMass();
        RecipeBuilder builder = GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_long_rod_to_rod").inputItems(stack).duration(mass).EUt(4L);
        if (ConfigHolder.INSTANCE.recipes.harderRods) {
            builder.outputItems(stickStack.m_255036_(1));
            builder.outputItems(GTOTagPrefix.dustSmall, material, 2);
        } else {
            builder.outputItems(stickStack);
        }
        builder.save();
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("stick_long_%s", material.getName()), (ItemStack)stickStack, (Object[])new Object[]{"s", "X", Character.valueOf('X'), stack});
        }
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("stick_long_stick_%s", material.getName()), (ItemStack)stack, (Object[])new Object[]{"ShS", Character.valueOf('S'), stickStack.m_255036_(1)});
        }
        if (!material.hasProperty(PropertyKey.WOOD)) {
            GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_rod_to_long_rod").inputItems(stickStack).circuitMeta(2).outputItems(stack).duration(mass).EUt(16L).save();
            if (material.hasProperty(PropertyKey.INGOT)) {
                GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_long_rod").inputItems(GTOTagPrefix.ingot, material).notConsumable(GTOItems.SHAPE_EXTRUDER_ROD_LONG).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_long_rod").inputItems(GTOTagPrefix.dust, material).notConsumable(GTOItems.SHAPE_EXTRUDER_ROD_LONG).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
                }
            }
        } else {
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_long_rod").inputItems(GTOTagPrefix.dust, material).notConsumable(GTOItems.SHAPE_EXTRUDER_ROD_LONG).outputItems(stack).duration(mass).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 3).save();
        }
    }

    private static void processTurbine(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.turbineBlade, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_turbine_blade").inputItems(stack.m_255036_(8)).inputItems(GTOTagPrefix.rodLong, GTMaterials.Magnalium).outputItems(GTOTagPrefix.turbineRotor, material).duration(200).EUt(400L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_turbine_blade").inputItems(GTOTagPrefix.turbineRotor, material).outputItems(GTOTagPrefix.dustSmall, material, 2).duration(mass << 4).category(GTRecipeCategories.MACERATOR_RECYCLING).EUt(30L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_turbine_blade_coated").inputItems(GTOTagPrefix.turbineRotorCoated, material).outputItems(GTOTagPrefix.dustSmall, material, 2).duration(mass << 4).category(GTRecipeCategories.MACERATOR_RECYCLING).EUt(30L).save();
        GTORecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("press_" + material.getName() + "_turbine_rotor").inputItems(GTOTagPrefix.plateDouble, material, 5).inputItems(GTOTagPrefix.screw, material, 2).outputItems(stack).duration(mass << 4).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 2).save();
        rotors.forEach(plating -> {
            if (plating == material) {
                return;
            }
            ItemStack rotorStack = ChemicalHelper.get((TagPrefix)TagPrefix.turbineRotorCoated, (Material)material);
            CoatedTurbineRotorBehaviour.setCoatMaterial((ItemStack)rotorStack, (Material)plating);
            boolean isMagic = plating.hasFlag(MaterialFlags.MAGICAL);
            Material electrolyteMaterial = isMagic ? GTOMaterials.PhantomicElectrolyteBuffer : GTOMaterials.ChromicAcid;
            Material wasteMaterial = isMagic ? GTOMaterials.Aether : GTOMaterials.ChromicAcidWaste;
            GTORecipeTypes.ELECTROPLATING_RECIPES.recipeBuilder("electroplate_%s_%s_turbine_rotor".formatted(material.getName(), plating.getName())).inputItems(GTOTagPrefix.turbineRotor, material).inputItems(GTOTagPrefix.plateDouble, plating, 5).inputFluids(GTMaterials.DistilledWater, 1000).inputFluids(electrolyteMaterial, 250).outputItems(rotorStack).outputFluids(wasteMaterial.getFluid(1000)).category(GTORecipeCategories.ROTOR_PLATING).duration((int)((plating.getMass() << 4) + (material.getMass() << 4) / 2L)).EUt(480L).save();
        });
    }

    private static void processRound(Material material) {
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)GTOTagPrefix.round, (Material)material);
        if (stack1.m_41619_()) {
            return;
        }
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.nugget, (Material)material);
        if (!material.hasFlag(MaterialFlags.NO_SMASHING) && material.getMass() < 222L && material.getBlastTemperature() < 6000) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("round_%s", material.getName()), (ItemStack)stack1, (Object[])new Object[]{"fN", "Nh", Character.valueOf('N'), stack});
            VanillaRecipeHelper.addShapedRecipe((String)String.format("round_from_ingot_%s", material.getName()), (ItemStack)stack1.m_255036_(4), (Object[])new Object[]{"fIh", Character.valueOf('I'), new MaterialEntry(GTOTagPrefix.ingot, material)});
        }
        GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_nugget_to_round").EUt((long)GTOUtils.getVoltageMultiplier((Material)material)).duration(Math.max(1, (int)material.getMass() / 9)).inputItems(stack).outputItems(stack1).save();
    }

    private static void processManoswarm(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.NANITES, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        GTORecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder(material.getName() + "_nano_bath").inputFluids(GTOMaterials.PiranhaSolution.getFluid((int)(10000.0 * Math.sqrt((double)material.getMass() / (double)GTOMaterials.Eternity.getMass())))).inputItems(GTOTagPrefix.CONTAMINABLE_NANITES, material).outputItems(stack).duration((int)material.getMass() << 4).EUt(480L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processcurvedPlate(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        int mass = (int)material.getMass();
        ItemStack plateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.plate, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("curved_plate_%s", material.getName()), (ItemStack)stack, (Object[])new Object[]{"hI", " h", Character.valueOf('I'), plateStack});
        }
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder(material.getName() + "_curved_plate").inputItems(plateStack).outputItems(stack).circuitMeta(1).duration(mass).EUt(16L).save();
    }

    private static void processMotorEnclosure(Material material) {
        int mass = (int)material.getMass();
        ItemStack motorEnclosureStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.MOTOR_ENCLOSURE, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack ringStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.ring, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("motor_enclosure_%s", material.getName()), (ItemStack)motorEnclosureStack, (Object[])new Object[]{"SwS", "IRI", " h ", Character.valueOf('I'), curvedPlateStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material), Character.valueOf('R'), ringStack});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_motor_enclosure").inputItems(curvedPlateStack.m_255036_(2)).inputItems(ringStack).outputItems(motorEnclosureStack).circuitMeta(3).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(motorEnclosureStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_motor_enclosure").inputItems(GTOItems.DATA_DISC).inputItems(motorEnclosureStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_motor_enclosure").notConsumable(data).inputFluids(material.getFluid(288)).outputItems(motorEnclosureStack).duration(mass << 1).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processPumpBarrel(Material material) {
        int mass = (int)material.getMass();
        ItemStack pumpBarrelStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.PUMP_BARREL, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack ringStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.ring, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("pump_barrel_%s", material.getName()), (ItemStack)pumpBarrelStack, (Object[])new Object[]{"wIw", "ShS", "RIR", Character.valueOf('I'), curvedPlateStack, Character.valueOf('R'), ringStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material)});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_pump_barrel").inputItems(curvedPlateStack.m_255036_(2)).inputItems(ringStack.m_255036_(2)).circuitMeta(4).outputItems(pumpBarrelStack).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(pumpBarrelStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_pump_barrel").inputItems(GTOItems.DATA_DISC).inputItems(pumpBarrelStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_pump_barrel").notConsumable(data).inputFluids(material.getFluid(360)).outputItems(pumpBarrelStack).duration(mass * 5 / 2).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processPistonHousing(Material material) {
        int mass = (int)material.getMass();
        ItemStack pistonHousingStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.PISTON_HOUSING, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack plateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.plate, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("piston_housing_%s", material.getName()), (ItemStack)pistonHousingStack, (Object[])new Object[]{"IhI", "SPS", "whw", Character.valueOf('I'), curvedPlateStack, Character.valueOf('P'), plateStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material)});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_piston_housing").inputItems(curvedPlateStack.m_255036_(2)).inputItems(plateStack).circuitMeta(5).outputItems(pistonHousingStack).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(pistonHousingStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_piston_housing").inputItems(GTOItems.DATA_DISC).inputItems(pistonHousingStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_piston_housing").notConsumable(data).inputFluids(material.getFluid(432)).outputItems(pistonHousingStack).duration(mass * 3).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processEmitterBases(Material material) {
        int mass = (int)material.getMass();
        ItemStack emitterBasesStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.EMITTER_BASES, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack plateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.plate, (Material)material);
        ItemStack rodStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rod, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("emitter_base_%s", material.getName()), (ItemStack)emitterBasesStack, (Object[])new Object[]{"SwS", "IPI", "RhR", Character.valueOf('I'), curvedPlateStack, Character.valueOf('P'), plateStack, Character.valueOf('R'), rodStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material)});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_emitter_base").inputItems(curvedPlateStack.m_255036_(2)).inputItems(rodStack.m_255036_(2)).inputItems(plateStack).outputItems(emitterBasesStack).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(emitterBasesStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_emitter_base").inputItems(GTOItems.DATA_DISC).inputItems(emitterBasesStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_emitter_base").notConsumable(data).inputFluids(material.getFluid(576)).outputItems(emitterBasesStack).duration(mass << 2).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processSensorCasing(Material material) {
        int mass = (int)material.getMass();
        ItemStack sensorCasingStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.SENSOR_CASING, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack rodStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.rod, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("sensor_casing_%s", material.getName()), (ItemStack)sensorCasingStack, (Object[])new Object[]{"wIh", "IRI", "SIS", Character.valueOf('I'), curvedPlateStack, Character.valueOf('R'), rodStack, Character.valueOf('S'), new MaterialEntry(GTOTagPrefix.screw, material)});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_sensor_casing").inputItems(curvedPlateStack.m_255036_(4)).inputItems(rodStack.m_255036_(1)).circuitMeta(6).outputItems(sensorCasingStack).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(sensorCasingStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_sensor_casing").inputItems(GTOItems.DATA_DISC).inputItems(sensorCasingStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_sensor_casing").notConsumable(data).inputFluids(material.getFluid(648)).outputItems(sensorCasingStack).duration(mass * 9 / 2).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processFieldGeneratorCasing(Material material) {
        int mass = (int)material.getMass();
        ItemStack fieldGeneratorCasingStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.FIELD_GENERATOR_CASING, (Material)material);
        ItemStack curvedPlateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CURVED_PLATE, (Material)material);
        ItemStack plateStack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.plate, (Material)material);
        if (mass < 240 && material.getBlastTemperature() < 3600) {
            VanillaRecipeHelper.addShapedRecipe((String)String.format("field_generator_casing_%s", material.getName()), (ItemStack)fieldGeneratorCasingStack, (Object[])new Object[]{"IPI", "PwP", "IPI", Character.valueOf('I'), curvedPlateStack, Character.valueOf('P'), plateStack});
        }
        GTORecipeTypes.LASER_WELDER_RECIPES.recipeBuilder(material.getName() + "_field_generator_casing").inputItems(curvedPlateStack.m_255036_(4)).inputItems(plateStack.m_255036_(4)).circuitMeta(7).outputItems(fieldGeneratorCasingStack).duration(mass).EUt(30L).save();
        ItemStack data = ((DiscItem)GTOItems.DATA_DISC.get()).getDisc(fieldGeneratorCasingStack);
        GTORecipeTypes.SCANNER_RECIPES.recipeBuilder(material.getName() + "_field_generator_casing").inputItems(GTOItems.DATA_DISC).inputItems(fieldGeneratorCasingStack).outputItems(data).EUt((long)GTOUtils.getVoltageMultiplier((Material)material) << 4).duration(mass).save();
        GTORecipeTypes.THREE_DIMENSIONAL_PRINTER_RECIPES.recipeBuilder(material.getName() + "_field_generator_casing").notConsumable(data).inputFluids(material.getFluid(1152)).outputItems(fieldGeneratorCasingStack).duration(mass << 3).EUt(16L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processCatalyst(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CATALYST, (Material)material);
        if (stack.m_41619_()) {
            return;
        }
        GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(material.getName() + "_catalyst").inputItems(GTOItems.CATALYST_BASE).inputItems(GTOTagPrefix.dust, material, 16).outputItems(stack).duration((int)material.getMass() << 2).EUt(120L).cleanroom(CleanroomType.CLEANROOM).save();
    }

    private static void processroughBlank(Material material) {
        ItemStack stack2 = ChemicalHelper.get((TagPrefix)GTOTagPrefix.BRICK, (Material)material);
        if (stack2.m_41619_()) {
            return;
        }
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.ROUGH_BLANK, (Material)material);
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)GTOTagPrefix.block, (Material)material);
        GTORecipeTypes.SINTERING_FURNACE_RECIPES.recipeBuilder(material.getName() + "_rough_blank").inputItems(stack).outputItems(stack1).duration(400).EUt(120L).blastFurnaceTemp(GTOMaterialBuilder.getTemp((Material)material)).save();
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder(material.getName() + "_brick").inputItems(stack1).outputItems(stack2.m_255036_(9)).duration(300).EUt(120L).save();
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder(material.getName() + "_flakes").inputItems(stack2).outputItems(GTOTagPrefix.FLAKES, material, 4).duration(200).EUt(30L).save();
    }

    private static void processCrystallization(Material material) {
        ItemStack stack = ChemicalHelper.get((TagPrefix)GTOTagPrefix.CRYSTAL_SEED, (Material)material, (int)2);
        ItemStack stack1 = ChemicalHelper.get((TagPrefix)GTOTagPrefix.gemExquisite, (Material)material);
        if (stack1.m_41619_()) {
            return;
        }
        GTORecipeTypes.CUTTER_RECIPES.recipeBuilder("%s_gem".formatted(material.getName())).inputItems(GTOTagPrefix.ARTIFICIAL_GEM, material).outputItems(stack1).outputItems(stack).duration((int)(material.getMass() << 1)).EUt(16L).save();
        GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("%s_seed".formatted(material.getName())).inputItems(stack1).inputFluids(GTMaterials.DistilledWater, 800).outputItems(stack).duration((int)(material.getMass() << 2)).EUt(7L).save();
    }
}

