/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.generated;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.tag.Tags;
import com.gtolib.GTOCore;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.utils.ItemUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class GenerateDisassembly {
    public static final Set<ResourceLocation> DISASSEMBLY_RECORD = new OpenCacheHashSet();
    public static final Set<ResourceLocation> DISASSEMBLY_BLACKLIST = new OpenCacheHashSet();
    private static final String[] outputItem = new String[]{"_frame", "_fence", "_electric_motor", "_electric_pump", "_conveyor_module", "_electric_piston", "_robot_arm", "_field_generator", "_emitter", "_sensor", "smd_", "_lamp", "_integrated_control_core", "ae2:blank_pattern", "gtocore:carbon_nanites", "gtmthings:virtual_item_provider", "gtocore:me_wildcard_pattern_buffer"};

    private static boolean isExcludeItems(String id) {
        for (String pattern : outputItem) {
            if (!id.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public static void generateDisassembly(GTRecipeBuilder recipeBuilder) {
        long eut = recipeBuilder.EUt();
        if (eut < 1L) {
            return;
        }
        List c = recipeBuilder.output.getOrDefault(ItemRecipeCapability.CAP, null);
        if (c == null) {
            GTOCore.LOGGER.error("\u914d\u65b9{}\u6ca1\u6709\u8f93\u51fa", (Object)recipeBuilder.id);
            return;
        }
        Ingredient output = (Ingredient)ItemRecipeCapability.CAP.of(((Content)c.getFirst()).getContent());
        if (output.m_43947_()) {
            return;
        }
        Item item = ItemUtils.getFirstSized((Ingredient)output).m_41720_();
        if (recipeBuilder.recipeType == GTORecipeTypes.LASER_WELDER_RECIPES && !(item instanceof MetaMachineItem)) {
            return;
        }
        ResourceLocation id = ItemUtils.getIdLocation((Item)item);
        if (DISASSEMBLY_BLACKLIST.contains(id)) {
            return;
        }
        boolean cal = recipeBuilder.recipeType == GTORecipeTypes.CIRCUIT_ASSEMBLY_LINE_RECIPES;
        ResourceLocation typeid = RecipeBuilder.getTypeID((ResourceLocation)id, (GTRecipeType)GTORecipeTypes.DISASSEMBLY_RECIPES);
        if (cal && RecipeBuilder.RECIPE_MAP.containsKey(typeid)) {
            return;
        }
        if (!cal && DISASSEMBLY_RECORD.remove(id) || GenerateDisassembly.isExcludeItems(id.toString())) {
            DISASSEMBLY_BLACKLIST.add(id);
            RecipeBuilder.RECIPE_MAP.remove(typeid);
            return;
        }
        RecipeBuilder builder = GTORecipeTypes.DISASSEMBLY_RECIPES.recipeBuilder(id).inputItems(FastSizedIngredient.copy((Ingredient)output)).duration(recipeBuilder.duration).EUt(eut);
        boolean hasOutput = false;
        List itemList = recipeBuilder.input.getOrDefault(ItemRecipeCapability.CAP, null);
        List fluidList = recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, null);
        if (itemList != null) {
            block0: for (Content content : itemList) {
                Ingredient input = (Ingredient)ItemRecipeCapability.CAP.of(content.getContent());
                if (!(input instanceof FastSizedIngredient)) continue;
                FastSizedIngredient sizedIngredient = (FastSizedIngredient)input;
                Ingredient inner = sizedIngredient.getInner();
                for (Ingredient.Value value : inner.f_43902_) {
                    if (value instanceof Ingredient.ItemValue) {
                        Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                        Collection stacks = itemValue.m_6223_();
                        if (stacks.size() != 1) continue;
                        for (ItemStack stack : stacks) {
                            if (stack.m_41619_() || content.chance != ChanceLogic.getMaxChancedValue() || stack.m_41782_()) continue;
                            builder.output((RecipeCapability)ItemRecipeCapability.CAP, (Object)FastSizedIngredient.copy((Ingredient)input));
                            hasOutput = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (!(value instanceof Ingredient.TagValue)) continue;
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                    Integer i = Tags.CIRCUITS_ARRAY.get(tagValue.f_43959_);
                    if (i == null) continue;
                    builder.outputItems((Item)GTOItems.UNIVERSAL_CIRCUIT[i].get(), sizedIngredient.getSaturatedAmount());
                    continue block0;
                }
            }
        }
        if (fluidList != null) {
            for (Content content : fluidList) {
                FluidIngredient fluid = (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent());
                if (content.chance != ChanceLogic.getMaxChancedValue() || fluid.isEmpty()) continue;
                builder.outputFluids(new FluidIngredient[]{fluid.copy()});
                hasOutput = true;
            }
        }
        if (hasOutput) {
            builder.save();
        }
        DISASSEMBLY_RECORD.add(id);
    }
}

