/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.recipe.gtm.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.common.block.LampBlock;
import com.gregtechceu.gtceu.common.block.StoneBlockType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.data.machines.GTAEMachines;
import com.gtocore.data.recipe.gtm.misc.ComputerRecipes;
import com.gtolib.GTOCore;
import com.gtolib.utils.ItemUtils;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public final class MachineRecipeLoader {
    private static final MaterialStack[][] alloySmelterList = new MaterialStack[][]{{new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.Iron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.WroughtIron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.Iron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.WroughtIron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.Lead, 4L), new MaterialStack(GTMaterials.Antimony, 1L), new MaterialStack(GTMaterials.BatteryAlloy, 5L)}, {new MaterialStack(GTMaterials.Gold, 1L), new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrum, 2L)}, {new MaterialStack(GTMaterials.Magnesium, 1L), new MaterialStack(GTMaterials.Aluminium, 2L), new MaterialStack(GTMaterials.Magnalium, 3L)}, {new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrotine, 4L), new MaterialStack(GTMaterials.BlueAlloy, 1L)}};

    private MachineRecipeLoader() {
    }

    public static void init() {
        ComputerRecipes.init();
        MachineRecipeLoader.registerDecompositionRecipes();
        MachineRecipeLoader.registerBlastFurnaceRecipes();
        MachineRecipeLoader.registerAssemblerRecipes();
        MachineRecipeLoader.registerAlloyRecipes();
        MachineRecipeLoader.registerBendingCompressingRecipes();
        MachineRecipeLoader.registerCokeOvenRecipes();
        MachineRecipeLoader.registerFluidRecipes();
        MachineRecipeLoader.registerMixingCrystallizationRecipes();
        MachineRecipeLoader.registerPrimitiveBlastFurnaceRecipes();
        MachineRecipeLoader.registerRecyclingRecipes();
        MachineRecipeLoader.registerStoneBricksRecipes();
        MachineRecipeLoader.registerNBTRemoval();
        MachineRecipeLoader.registerHatchConversion();
    }

    private static void registerBendingCompressingRecipes() {
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compressed_fireclay").inputItems(TagPrefix.dust, GTMaterials.Fireclay).outputItems((Supplier)GTItems.COMPRESSED_FIRECLAY).duration(80).EUt(4L).save();
        for (ItemEntry shapeMold : GTItems.SHAPE_MOLDS) {
            GTORecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_mold_" + String.valueOf(shapeMold.get())).duration(120).EUt(22L).notConsumable((Supplier)shapeMold).inputItems((Supplier)GTItems.SHAPE_EMPTY).outputItems((Supplier)shapeMold).save();
        }
        for (ItemEntry shapeExtruder : GTItems.SHAPE_EXTRUDERS) {
            if (shapeExtruder == null) continue;
            GTORecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_shape_" + String.valueOf(shapeExtruder.get())).duration(120).EUt(22L).notConsumable((Supplier)shapeExtruder).inputItems((Supplier)GTItems.SHAPE_EMPTY).outputItems((Supplier)shapeExtruder).save();
        }
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("empty_shape").circuitMeta(4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems((Supplier)GTItems.SHAPE_EMPTY).duration(180).EUt(12L).save();
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_tin").circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Tin, 2).outputItems((Supplier)GTItems.FLUID_CELL).duration(200).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_steel").circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Steel).outputItems((Supplier)GTItems.FLUID_CELL).duration(100).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_ptfe").circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polytetrafluoroethylene).outputItems((Supplier)GTItems.FLUID_CELL, 4).duration(100).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_pbi").circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polybenzimidazole).outputItems((Supplier)GTItems.FLUID_CELL, 16).duration(100).EUt((long)GTValues.VA[0]).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_tin").inputItems(TagPrefix.ingot, GTMaterials.Tin, 2).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier)GTItems.FLUID_CELL).duration(128).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_steel").inputItems(TagPrefix.ingot, GTMaterials.Steel).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier)GTItems.FLUID_CELL).duration(128).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_ptfe").inputItems(TagPrefix.ingot, GTMaterials.Polytetrafluoroethylene).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier)GTItems.FLUID_CELL, 4).duration(128).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_pbi").inputItems(TagPrefix.ingot, GTMaterials.Polybenzimidazole).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier)GTItems.FLUID_CELL, 16).duration(128).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_vial").inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier)GTItems.FLUID_CELL_GLASS_VIAL, 4).duration(128).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_quartz_plate").inputItems(TagPrefix.dust, GTMaterials.NetherQuartz).outputItems(TagPrefix.plate, GTMaterials.NetherQuartz).duration(400).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("certus_quartz_plate").inputItems(TagPrefix.dust, GTMaterials.CertusQuartz).outputItems(TagPrefix.plate, GTMaterials.CertusQuartz).duration(400).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("quartzite_plate").inputItems(TagPrefix.dust, GTMaterials.Quartzite).outputItems(TagPrefix.plate, GTMaterials.Quartzite).duration(400).EUt(2L).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("coke_bricks").inputItems((Supplier)GTItems.COKE_OVEN_BRICK, 4).outputItems(GTBlocks.CASING_COKE_BRICKS.m_5456_()).duration(300).EUt(2L).save();
    }

    private static void registerPrimitiveBlastFurnaceRecipes() {
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).duration(1500).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust").inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).duration(1500).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).duration(600).save();
        GTORecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust_wrought").inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).duration(600).save();
    }

    private static void registerCokeOvenRecipes() {
        GTORecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("log_to_charcoal").inputItems(ItemTags.f_13181_).outputItems(TagPrefix.gem, GTMaterials.Charcoal).outputFluids(GTMaterials.Creosote.getFluid(250)).duration(900).save();
        GTORecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke").inputItems(TagPrefix.gem, GTMaterials.Coal).outputItems(TagPrefix.gem, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(500)).duration(900).save();
        GTORecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke_block").inputItems(TagPrefix.block, GTMaterials.Coal).outputItems(TagPrefix.block, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(4500)).duration(8100).save();
        GTORecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke_dust").inputItems(TagPrefix.dust, GTMaterials.Coal).outputItems(TagPrefix.dust, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(500)).duration(900).save();
    }

    private static void registerStoneBricksRecipes() {
        List<ItemStack> cobbles = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.COBBLE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> mossCobbles = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.COBBLE_MOSSY).values().stream().map(ItemStack::new).toList();
        List<ItemStack> stones = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.STONE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> polisheds = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.POLISHED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> bricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS).values().stream().map(ItemStack::new).toList();
        List<ItemStack> crackedBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_CRACKED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> mossBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_MOSSY).values().stream().map(ItemStack::new).toList();
        List<ItemStack> chiseledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.CHISELED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> tiledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.TILED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> smallTiledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.TILED_SMALL).values().stream().map(ItemStack::new).toList();
        List<ItemStack> windmillA = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.WINDMILL_A).values().stream().map(ItemStack::new).toList();
        List<ItemStack> windmillB = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.WINDMILL_B).values().stream().map(ItemStack::new).toList();
        List<ItemStack> squareBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_SQUARE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> smallBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_SMALL).values().stream().map(ItemStack::new).toList();
        MachineRecipeLoader.registerSmoothRecipe(cobbles, stones);
        MachineRecipeLoader.registerCobbleRecipe(stones, cobbles);
        MachineRecipeLoader.registerMossRecipe(cobbles, mossCobbles);
        MachineRecipeLoader.registerSmoothRecipe(stones, polisheds);
        MachineRecipeLoader.registerBricksRecipe(polisheds, bricks, MarkerMaterials.Color.LightBlue);
        MachineRecipeLoader.registerCobbleRecipe(bricks, crackedBricks);
        MachineRecipeLoader.registerMossRecipe(bricks, mossBricks);
        MachineRecipeLoader.registerBricksRecipe(polisheds, chiseledBricks, MarkerMaterials.Color.White);
        MachineRecipeLoader.registerBricksRecipe(polisheds, tiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(tiledBricks, smallTiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(polisheds, windmillA, MarkerMaterials.Color.Blue);
        MachineRecipeLoader.registerBricksRecipe(polisheds, windmillB, MarkerMaterials.Color.Yellow);
        MachineRecipeLoader.registerBricksRecipe(polisheds, squareBricks, MarkerMaterials.Color.Green);
        MachineRecipeLoader.registerBricksRecipe(polisheds, smallBricks, MarkerMaterials.Color.Pink);
        for (int i = 0; i < stones.size(); ++i) {
            ResourceLocation bricksId = ItemUtils.getIdLocation((Item)bricks.get(i).m_41720_());
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + bricksId.m_135815_()).inputItems(stones.get(i)).notConsumable((Supplier)GTItems.SHAPE_EXTRUDER_INGOT).outputItems(bricks.get(i)).duration(24).EUt(8L).save();
        }
    }

    private static void registerMixingCrystallizationRecipes() {
        GTORecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("silicon_dioxide_to_quartzite_gem").inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputFluids(GTMaterials.DistilledWater, 250).chancedOutput(ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)GTMaterials.Quartzite), 1000, 1000).duration(1200).EUt(24L).save();
        GTORecipeTypes.MIXER_RECIPES.recipeBuilder("indium_concentrate").inputItems(TagPrefix.crushedPurified, GTMaterials.Sphalerite).inputItems(TagPrefix.crushedPurified, GTMaterials.Galena).inputFluids(GTMaterials.SulfuricAcid, 4000).outputFluids(GTMaterials.IndiumConcentrate.getFluid(1000)).duration(60).EUt(150L).save();
    }

    private static void registerAlloyRecipes() {
        for (MaterialStack[] stack : alloySmelterList) {
            String recipeNape = stack[0].material().getName() + "_%s_and_" + stack[1].material().getName() + "_%s_into_" + stack[2].material().getName();
            if (stack[0].material().hasProperty(PropertyKey.INGOT)) {
                GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "dust")).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)stack[2].material(), (int)((int)stack[2].amount()))).save();
            }
            if (stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "ingot")).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)stack[2].material(), (int)((int)stack[2].amount()))).save();
            }
            if (stack[0].material().hasProperty(PropertyKey.INGOT) && stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "ingot")).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)stack[2].material(), (int)((int)stack[2].amount()))).save();
            }
            GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "dust")).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)stack[2].material(), (int)((int)stack[2].amount()))).save();
        }
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("carbon_fiber_plate").inputItems((Supplier)GTItems.CARBON_MESH).outputItems((Supplier)GTItems.CARBON_FIBER_PLATE).duration(200).EUt(2L).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_sheet").duration(10).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.ingot, GTMaterials.Rubber, 2).notConsumable((Supplier)GTItems.SHAPE_MOLD_PLATE).outputItems(TagPrefix.plate, GTMaterials.Rubber).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_bar").duration(100).EUt((long)GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Sulfur).inputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).outputItems(TagPrefix.ingot, GTMaterials.Rubber).save();
        GTORecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("coke_oven_brick").duration(150).EUt((long)GTValues.VA[0]).inputItems(Tags.Items.SAND).inputItems(Items.f_42461_).outputItems((Supplier)GTItems.COKE_OVEN_BRICK, 2).save();
    }

    private static void registerAssemblerRecipes() {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            int lampMeta;
            GTORecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_" + GTMaterials.CHEMICAL_DYES[i].getName()).inputItems((Supplier)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(576)).outputItems((Supplier)GTItems.SPRAY_CAN_DYES[i]).EUt((long)GTValues.VA[0]).duration(200).save();
            DyeColor color = DyeColor.m_41053_((int)i);
            LampBlock lamp = (LampBlock)((BlockEntry)GTBlocks.LAMPS.get(color)).get();
            for (lampMeta = 0; lampMeta < 8; ++lampMeta) {
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lamp_" + String.valueOf(color) + "_" + lampMeta).inputItems(TagPrefix.plate, GTMaterials.Glass, 6).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 1).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(144)).outputItems(lamp.getStackFromIndex(lampMeta)).circuitMeta(lampMeta + 1).EUt((long)GTValues.VA[0]).duration(40).save();
            }
            lamp = (LampBlock)((BlockEntry)GTBlocks.BORDERLESS_LAMPS.get(color)).get();
            for (lampMeta = 0; lampMeta < 8; ++lampMeta) {
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("borderless_lamp_" + String.valueOf(color) + "_" + lampMeta).inputItems(TagPrefix.plate, GTMaterials.Glass, 6).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 1).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(144)).outputItems(lamp.getStackFromIndex(lampMeta)).circuitMeta(lampMeta + 9).EUt((long)GTValues.VA[0]).duration(40).save();
            }
        }
        GTORecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_solvent").inputItems((Supplier)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.Acetone, 1000).outputItems((Supplier)GTItems.SPRAY_SOLVENT).EUt((long)GTValues.VA[0]).duration(200).save();
        GTORecipeTypes.CANNER_RECIPES.recipeBuilder("mask_filter").inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 4).inputItems(TagPrefix.dust, GTMaterials.ActivatedCarbon, 2).outputItems((Supplier)GTItems.MASK_FILTER).duration(100).EUt(2L).save();
        GTORecipeTypes.CANNER_RECIPES.recipeBuilder("pack_paracetamol").inputItems(TagPrefix.dust, GTMaterials.Paracetamol, 16).notConsumable((Supplier)GTItems.SHAPE_MOLD_PILL).outputItems((Supplier)GTItems.PARACETAMOL_PILL, 16).duration(60).EUt((long)GTValues.VA[1]).save();
        GTORecipeTypes.CANNER_RECIPES.recipeBuilder("pack_rad_away").inputItems(TagPrefix.dust, GTMaterials.RadAway, 16).notConsumable((Supplier)GTItems.SHAPE_MOLD_PILL).outputItems((Supplier)GTItems.RAD_AWAY_PILL, 16).duration(60).EUt((long)GTValues.VA[1]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_shutter").inputItems(Items.f_42341_).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).outputItems((Supplier)GTItems.COVER_SHUTTER, 2).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_machine_controller").inputItems((Object)Blocks.f_50164_).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_MACHINE_CONTROLLER).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_energy_detector").inputItems(TagPrefix.cableGtSingle, GTMaterials.Copper, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_ENERGY_DETECTOR).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_machine_controller_exp").inputItems((Object)Blocks.f_50164_).inputItems(TagPrefix.plate, GTMaterials.Iron, 16).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 16).outputItems((Supplier)GTItems.COVER_MACHINE_CONTROLLER).EUt(7L).duration(400).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_energy_detector_exp").inputItems(TagPrefix.cableGtSingle, GTMaterials.RedAlloy, 4).inputItems(CustomTags.ULV_CIRCUITS, 2).inputItems(TagPrefix.plate, GTMaterials.Iron, 16).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 16).outputItems((Supplier)GTItems.COVER_ENERGY_DETECTOR).EUt(7L).duration(400).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_energy_detector").inputItems((Supplier)GTItems.COVER_ENERGY_DETECTOR).inputItems((Supplier)GTItems.SENSOR_HV).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_ENERGY_DETECTOR_ADVANCED).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_activity_detector").inputItems((Object)Blocks.f_50174_).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_ACTIVITY_DETECTOR).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_activity_cover").inputItems(TagPrefix.wireFine, GTMaterials.Gold, 4).inputItems(CustomTags.HV_CIRCUITS).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_ACTIVITY_DETECTOR_ADVANCED).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_fluid_detector").inputItems((Object)Blocks.f_50327_).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_FLUID_DETECTOR).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_item_detector").inputItems((Object)Blocks.f_50326_).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_ITEM_DETECTOR).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_fluid_detector").inputItems((Supplier)GTItems.COVER_FLUID_DETECTOR).inputItems((Supplier)GTItems.SENSOR_HV).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_FLUID_DETECTOR_ADVANCED).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_screen").inputItems(TagPrefix.plate, GTMaterials.Glass).inputItems(TagPrefix.foil, GTMaterials.Aluminium, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.wireFine, GTMaterials.Copper, 4).outputItems((Supplier)GTItems.COVER_SCREEN).EUt(16L).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_infinite_water").inputItems((Supplier)GTItems.ELECTRIC_PUMP_HV, 2).inputItems(Items.f_42544_).inputItems(CustomTags.HV_CIRCUITS).outputItems((Supplier)GTItems.COVER_INFINITE_WATER).EUt((long)GTValues.VA[3]).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_ender_fluid_link").inputItems(TagPrefix.plate, GTMaterials.EnderPearl, 9).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel).inputItems((Supplier)GTItems.SENSOR_HV).inputItems((Supplier)GTItems.EMITTER_HV).inputItems((Supplier)GTItems.ELECTRIC_PUMP_HV).inputFluids(GTMaterials.Polyethylene, 288).outputItems((Supplier)GTItems.COVER_ENDER_FLUID_LINK).EUt((long)GTValues.VA[3]).duration(320).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_ender_item_link").inputItems(TagPrefix.plate, GTMaterials.EnderPearl, 9).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel).inputItems((Supplier)GTItems.SENSOR_HV).inputItems((Supplier)GTItems.EMITTER_HV).inputItems((Supplier)GTItems.CONVEYOR_MODULE_HV).inputFluids(GTMaterials.Polytetrafluoroethylene, 288).outputItems((Supplier)GTItems.COVER_ENDER_ITEM_LINK).EUt((long)GTValues.VA[3]).duration(320).addMaterialInfo(true, true).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_ender_redstone_link").inputItems(TagPrefix.plate, GTMaterials.EnderPearl, 4).inputItems(TagPrefix.plateDouble, GTMaterials.Aluminium).inputItems((Supplier)GTItems.SENSOR_MV).inputItems((Supplier)GTItems.EMITTER_MV).inputItems(CustomTags.MV_CIRCUITS).inputFluids(GTMaterials.SolderingAlloy, 288).outputItems((Supplier)GTItems.COVER_ENDER_REDSTONE_LINK).EUt((long)GTValues.VA[2]).duration(320).addMaterialInfo(true, true).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_storage").inputItems(Tags.Items.CHESTS_WOODEN).inputItems((Supplier)GTItems.ELECTRIC_PISTON_LV).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy, 72).outputItems((Supplier)GTItems.COVER_STORAGE).EUt(16L).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_bronze_bricks").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze, 6).inputItems((Object)Blocks.f_50076_).circuitMeta(6).outputItems(GTBlocks.CASING_BRONZE_BRICKS.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_invar_heatproof").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Invar, 6).inputItems(TagPrefix.frameGt, GTMaterials.Invar).circuitMeta(6).outputItems(GTBlocks.CASING_INVAR_HEATPROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_solid").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel, 6).inputItems(TagPrefix.frameGt, GTMaterials.Steel).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_SOLID.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_aluminium_frostproof").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Aluminium).circuitMeta(6).outputItems(GTBlocks.CASING_ALUMINIUM_FROSTPROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungsteensteel_robust").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_clean").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.StainlessSteel).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_CLEAN.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_stable").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_STABLE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hsse_sturdy").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.HSSE, 6).inputItems(TagPrefix.frameGt, GTMaterials.Europium).circuitMeta(6).outputItems(GTBlocks.CASING_HSSE_STURDY.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_palladium_substation").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Palladium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Iridium).circuitMeta(6).outputItems(GTBlocks.CASING_PALLADIUM_SUBSTATION.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ptfe_inert").EUt(16L).inputItems(GTBlocks.CASING_STEEL_SOLID.m_5456_()).inputFluids(GTMaterials.Polytetrafluoroethylene, 216).circuitMeta(6).outputItems(GTBlocks.CASING_PTFE_INERT.m_5456_()).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_luv").EUt((long)GTValues.VA[6]).inputItems(TagPrefix.wireGtDouble, GTMaterials.IndiumTinBariumTitaniumCuprate, 32).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 32).inputFluids(GTMaterials.Trinium, 3456).outputItems(GTBlocks.SUPERCONDUCTING_COIL.m_5456_()).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_zpm").EUt((long)GTValues.VA[7]).inputItems(TagPrefix.wireGtDouble, GTMaterials.UraniumRhodiumDinaquadide, 16).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 16).inputFluids(GTMaterials.Trinium, 2304).outputItems(GTBlocks.SUPERCONDUCTING_COIL.m_5456_()).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_uv").EUt((long)GTValues.VA[8]).inputItems(TagPrefix.wireGtDouble, GTMaterials.EnrichedNaquadahTriniumEuropiumDuranide, 8).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 8).inputFluids(GTMaterials.Trinium, 1152).outputItems(GTBlocks.SUPERCONDUCTING_COIL.m_5456_()).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_coil").EUt((long)GTValues.VA[7]).inputItems(GTBlocks.SUPERCONDUCTING_COIL.m_5456_()).inputItems(GTItems.FIELD_GENERATOR_IV.m_5456_(), 2).inputItems((Supplier)GTItems.ELECTRIC_PUMP_IV).inputItems(GTItems.NEUTRON_REFLECTOR.m_5456_(), 2).inputItems(CustomTags.LuV_CIRCUITS, 4).inputItems(TagPrefix.pipeSmallFluid, GTMaterials.Naquadah, 4).inputItems(TagPrefix.plate, GTMaterials.Europium, 4).inputFluids(GTMaterials.VanadiumGallium, 576).outputItems(GTBlocks.FUSION_COIL.m_5456_()).duration(100).cleanroom(CleanroomType.CLEANROOM).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_glass").EUt((long)GTValues.VA[6]).inputItems(GTBlocks.CASING_LAMINATED_GLASS.m_5456_()).inputItems(TagPrefix.plate, GTMaterials.Naquadah, 4).inputItems(GTItems.NEUTRON_REFLECTOR.m_5456_(), 4).outputItems(GTBlocks.FUSION_GLASS.m_5456_(), 2).inputFluids(GTMaterials.Polybenzimidazole, 144).duration(50).cleanroom(CleanroomType.CLEANROOM).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing").EUt((long)GTValues.VA[6]).inputItems(GTBlocks.MACHINE_CASING_LuV.m_5456_()).inputItems(GTBlocks.SUPERCONDUCTING_COIL.m_5456_()).inputItems((Supplier)GTItems.NEUTRON_REFLECTOR).inputItems((Supplier)GTItems.ELECTRIC_PUMP_LuV).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputFluids(GTMaterials.Polybenzimidazole, 144).outputItems(GTBlocks.FUSION_CASING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk2").EUt((long)GTValues.VA[7]).inputItems(GTBlocks.MACHINE_CASING_ZPM.m_5456_()).inputItems(GTBlocks.FUSION_COIL.m_5456_()).inputItems(GTItems.VOLTAGE_COIL_ZPM.m_5456_(), 2).inputItems((Supplier)GTItems.FIELD_GENERATOR_LuV).inputItems(TagPrefix.plate, GTMaterials.Europium, 6).inputFluids(GTMaterials.Polybenzimidazole, 288).outputItems(GTBlocks.FUSION_CASING_MK2.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk3").EUt((long)GTValues.VA[8]).inputItems(GTBlocks.MACHINE_CASING_UV.m_5456_()).inputItems(GTBlocks.FUSION_COIL.m_5456_()).inputItems(GTItems.VOLTAGE_COIL_UV.m_5456_(), 2).inputItems((Supplier)GTItems.FIELD_GENERATOR_ZPM).inputItems(TagPrefix.plate, GTMaterials.Americium, 6).inputFluids(GTMaterials.Polybenzimidazole, 576).outputItems(GTBlocks.FUSION_CASING_MK3.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_turbine").EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Magnalium, 6).inputItems(TagPrefix.frameGt, GTMaterials.BlueSteel, 1).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_steel_turbine").EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.m_5456_()).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_turbine").EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.m_5456_()).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungstensteel_turbine").EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.m_5456_()).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_grate_casing").inputItems(Items.f_42025_, 6).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems((Supplier)GTItems.ELECTRIC_MOTOR_MV).inputItems(TagPrefix.rotor, GTMaterials.Steel).outputItems((Supplier)GTBlocks.CASING_GRATE, ConfigHolder.INSTANCE.recipes.casingsPerCraft).duration(200).EUt((long)GTValues.VA[3]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assembly_line_casing").inputItems(TagPrefix.gear, GTMaterials.Ruridit, 2).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).inputItems((Supplier)GTItems.ROBOT_ARM_IV, 2).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel).outputItems((Supplier)GTBlocks.CASING_ASSEMBLY_LINE, ConfigHolder.INSTANCE.recipes.casingsPerCraft).duration(650).EUt((long)GTValues.VA[5]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assembly_control_casing").inputItems((Supplier)GTItems.HIGH_POWER_INTEGRATED_CIRCUIT).inputItems(GTOCore.isExpert() ? CustomTags.LuV_CIRCUITS : CustomTags.EV_CIRCUITS, 4).inputItems((Supplier)GTItems.SENSOR_IV).inputItems((Supplier)GTItems.EMITTER_IV).inputItems((Supplier)GTItems.ELECTRIC_MOTOR_IV).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel).outputItems((Supplier)GTBlocks.CASING_ASSEMBLY_CONTROL, ConfigHolder.INSTANCE.recipes.casingsPerCraft).duration(650).EUt((long)GTValues.VA[5]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("plascrete").EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Concrete, 144).outputItems(GTBlocks.PLASTCRETE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(200).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cleanroom_glass").EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Glass, 144).outputItems(GTBlocks.CLEANROOM_GLASS.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(200).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_wrought_iron").EUt(2L).inputItems(Tags.Items.CHESTS_WOODEN).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 5).outputItems((Object)Blocks.f_50332_).duration(800).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wooden_crate").EUt(16L).inputItems(ItemTags.f_13168_, 4).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).outputItems(GTMachines.WOODEN_CRATE).duration(100).circuitMeta(5).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 4).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_CRATE).duration(200).circuitMeta(1).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_CRATE).duration(200).circuitMeta(1).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 4).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_CRATE).duration(200).circuitMeta(1).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 4).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_CRATE).circuitMeta(1).duration(200).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 4).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_CRATE).duration(200).circuitMeta(1).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_crate").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_CRATE).duration(200).circuitMeta(1).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wood_barrel").EUt(16L).inputItems(ItemTags.f_13168_, 4).inputItems(TagPrefix.rodLong, GTMaterials.Iron, 2).outputItems(GTMachines.WOODEN_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 2).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 2).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 2).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("gold_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Gold, 2).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(GTMachines.GOLD_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 2).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_drum").EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 2).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_DRUM).duration(200).circuitMeta(2).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polyethylene").EUt((long)GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polyethylene, 4).inputItems((Supplier)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene, 288).outputItems((Supplier)GTItems.DUCT_TAPE).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_silicone_rubber").EUt((long)GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.SiliconeRubber, 2).inputItems((Supplier)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene, 288).outputItems((Supplier)GTItems.DUCT_TAPE, 2).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polycaprolactam").EUt((long)GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polycaprolactam, 2).inputItems((Supplier)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(144)).outputItems((Supplier)GTItems.DUCT_TAPE, 4).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polybenzimidazole").EUt((long)GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polybenzimidazole).inputItems((Supplier)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene, 72).outputItems((Supplier)GTItems.DUCT_TAPE, 8).duration(100).save();
        VanillaRecipeHelper.addShapedRecipe((String)"basic_tape", (ItemLike)GTItems.BASIC_TAPE.m_5456_(), (Object[])new Object[]{" P ", "PSP", " P ", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Paper), Character.valueOf('S'), GTItems.STICKY_RESIN.m_5456_()});
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("basic_tape").EUt((long)GTValues.VA[0]).inputItems(TagPrefix.plate, GTMaterials.Paper, 2).inputItems((Supplier)GTItems.STICKY_RESIN).outputItems((Supplier)GTItems.BASIC_TAPE, 2).duration(100).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_steel").inputItems(TagPrefix.plateDouble, GTMaterials.Steel, 2).inputItems(TagPrefix.ring, GTMaterials.Bronze, 2).outputItems((Supplier)GTItems.FLUID_CELL_LARGE_STEEL).duration(200).EUt((long)GTValues.VA[1]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_aluminium").inputItems(TagPrefix.plateDouble, GTMaterials.Aluminium, 2).inputItems(TagPrefix.ring, GTMaterials.Silver, 2).outputItems((Supplier)GTItems.FLUID_CELL_LARGE_ALUMINIUM).duration(200).EUt(64L).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_stainless_steel").inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel, 3).inputItems(TagPrefix.ring, GTMaterials.Electrum, 3).outputItems((Supplier)GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL).duration(200).EUt((long)GTValues.VA[2]).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_titanium").inputItems(TagPrefix.plateDouble, GTMaterials.Titanium, 3).inputItems(TagPrefix.ring, GTMaterials.RoseGold, 3).outputItems((Supplier)GTItems.FLUID_CELL_LARGE_TITANIUM).duration(200).EUt(256L).save();
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_tungstensteel").inputItems(TagPrefix.plateDouble, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.ring, GTMaterials.Platinum, 4).outputItems((Supplier)GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL).duration(200).EUt((long)GTValues.VA[3]).save();
    }

    private static void registerBlastFurnaceRecipes() {
        GTORecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_iron").duration(500).EUt((long)GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputFluids(GTMaterials.Oxygen, 200).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).blastFurnaceTemp(1000).save();
        GTORecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_wrought_iron").duration(300).EUt((long)GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputFluids(GTMaterials.Oxygen, 200).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 1111, 0).blastFurnaceTemp(1000).save();
        GTORecipeTypes.BLAST_RECIPES.recipeBuilder("tempered_glass_blasting").inputItems(TagPrefix.block, GTMaterials.Glass).inputFluids(GTMaterials.Oxygen, 100).outputItems(GTBlocks.CASING_TEMPERED_GLASS.m_5456_()).blastFurnaceTemp(1000).duration(200).EUt((long)GTValues.VA[2]).save();
    }

    private static void registerDecompositionRecipes() {
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_resin").inputItems((Supplier)GTItems.STICKY_RESIN).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).duration(150).EUt(2L).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_log").duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_LOG.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_sapling").duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_SAPLING.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save();
        GTORecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_slime").duration(150).EUt(2L).inputItems(Items.f_42518_).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 2).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_sapling").duration(300).EUt(2L).inputItems(ItemTags.f_13180_).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_wheat").duration(300).EUt(2L).inputItems(Items.f_42405_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_potato").duration(300).EUt(2L).inputItems(Items.f_42620_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_carrot").duration(300).EUt(2L).inputItems(Items.f_42619_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_cactus").duration(300).EUt(2L).inputItems(Blocks.f_50128_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_sugar_cane").duration(300).EUt(2L).inputItems(Items.f_41909_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brown_mushroom").duration(300).EUt(2L).inputItems(Blocks.f_50072_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_red_mushroom").duration(300).EUt(2L).inputItems(Blocks.f_50073_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_beetroot").duration(300).EUt(2L).inputItems(Items.f_42732_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_moss").duration(300).EUt(2L).inputItems(Items.f_151016_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_nether_wart").duration(300).EUt(2L).inputItems(Items.f_42259_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_crimson_stem").duration(300).EUt(2L).inputItems(Items.f_41843_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_warped_stem").duration(300).EUt(2L).inputItems(Items.f_41844_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brain_coral").duration(300).EUt(2L).inputItems(Items.f_42291_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_bubble_coral").duration(300).EUt(2L).inputItems(Items.f_42292_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_fire_coral").duration(300).EUt(2L).inputItems(Items.f_42293_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_tube_coral").duration(300).EUt(2L).inputItems(Items.f_42290_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
        GTORecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_horn_coral").duration(300).EUt(2L).inputItems(Items.f_42294_, 8).outputItems((Supplier)GTItems.PLANT_BALL).save();
    }

    private static void registerRecyclingRecipes() {
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("end_stone").inputItems((Object)Blocks.f_50259_).outputItems(TagPrefix.dust, GTMaterials.Endstone).chancedOutput(TagPrefix.dust, GTMaterials.Tungstate, 130, 30).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("netherrack").inputItems((Object)Blocks.f_50134_).outputItems(TagPrefix.dust, GTMaterials.Netherrack).chancedOutput(TagPrefix.nugget, GTMaterials.Gold, 500, 120).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("obsidian").inputItems((Object)Blocks.f_50080_).outputItems(TagPrefix.dust, GTMaterials.Obsidian).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("basalt").inputItems(Blocks.f_50137_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Basalt).chancedOutput(TagPrefix.dust, GTMaterials.Basalt, 1000, 380).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("deepslate").inputItems(Blocks.f_152550_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Deepslate).chancedOutput(TagPrefix.dust, GTMaterials.Thorium, 100, 40).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("red_granite").inputItems(TagPrefix.rock, GTMaterials.GraniteRed).outputItems(TagPrefix.dust, GTMaterials.GraniteRed).chancedOutput(TagPrefix.dust, GTMaterials.Uranium238, 10, 5).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("andesite").inputItems(Blocks.f_50334_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Andesite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("diorite").inputItems(Blocks.f_50228_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Diorite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("granite").inputItems(Blocks.f_50122_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Granite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("calcite").inputItems(Blocks.f_152497_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Calcite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("coral_block").inputItems(CustomTags.CORAL_BLOCK_ITEMS).outputItems(TagPrefix.dust, GTMaterials.Calcite).duration(150).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("coral").inputItems(CustomTags.CORAL_ITEMS).outputItems(TagPrefix.dustTiny, GTMaterials.Calcite).duration(25).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("pork_chop").inputItems(Items.f_42485_).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("fish").inputItems(ItemTags.f_13156_).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("chicken").inputItems(Items.f_42581_).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("steak").inputItems(Items.f_42579_).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("rabbit").inputItems(Items.f_42697_).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
        GTORecipeTypes.MACERATOR_RECIPES.recipeBuilder("mutton").inputItems(Items.f_42658_).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save();
    }

    private static void registerFluidRecipes() {
        GTORecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_ice_to_water").duration(32).EUt(4L).inputFluids(GTMaterials.Ice.getFluid(144)).circuitMeta(1).outputFluids(GTMaterials.Water.getFluid(144)).save();
        GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_gelled_toluene").inputFluids(GTMaterials.Toluene, 100).notConsumable((Supplier)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier)GTItems.GELLED_TOLUENE).duration(100).EUt(16L).save();
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            GTORecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + GTMaterials.CHEMICAL_DYES[i].getName() + "_to_ball").inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(72)).notConsumable((Supplier)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier)GTItems.DYE_ONLY_ITEMS[i]).duration(100).EUt(16L).save();
        }
        GTORecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_water_to_steam").duration(30).EUt((long)GTValues.VA[1]).inputFluids(GTMaterials.Water, 6).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960)).save();
        GTORecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_distilled_to_steam").duration(30).EUt((long)GTValues.VA[1]).inputFluids(GTMaterials.DistilledWater, 6).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960)).save();
    }

    private static void registerSmoothRecipe(List<ItemStack> roughStack, List<ItemStack> stoneStack) {
        for (int i = 0; i < roughStack.size(); ++i) {
            ResourceLocation stoneId = ItemUtils.getIdLocation((Item)stoneStack.get(i).m_41720_());
            VanillaRecipeHelper.addSmeltingRecipe((String)("smelt_" + stoneId.m_135815_()), (ItemStack)roughStack.get(i), (ItemStack)stoneStack.get(i), (float)0.1f);
            GTORecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + stoneId.m_135815_()).inputItems(roughStack.get(i)).notConsumable(GTItems.SHAPE_EXTRUDER_BLOCK.m_5456_()).outputItems(stoneStack.get(i)).duration(24).EUt(8L).save();
        }
    }

    private static void registerCobbleRecipe(List<ItemStack> stoneStack, List<ItemStack> cobbleStack) {
        for (int i = 0; i < stoneStack.size(); ++i) {
            ResourceLocation cobbleId = ItemUtils.getIdLocation((Item)cobbleStack.get(i).m_41720_());
            GTORecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + cobbleId.m_135815_()).inputItems(stoneStack.get(i)).outputItems(cobbleStack.get(i)).duration(12).EUt(4L).save();
        }
    }

    private static void registerBricksRecipe(List<ItemStack> polishedStack, List<ItemStack> brickStack, MarkerMaterial color) {
        for (int i = 0; i < polishedStack.size(); ++i) {
            ResourceLocation brickId = ItemUtils.getIdLocation((Item)brickStack.get(i).m_41720_());
            GTORecipeTypes.LASER_ENGRAVER_RECIPES.recipeBuilder("engrave_" + brickId.m_135815_()).inputItems(polishedStack.get(i)).notConsumable(TagPrefix.lens, (Material)color).outputItems(brickStack.get(i)).duration(50).EUt(16L).save();
        }
    }

    private static void registerMossRecipe(List<ItemStack> regularStack, List<ItemStack> mossStack) {
        for (int i = 0; i < regularStack.size(); ++i) {
            ResourceLocation mossId = ItemUtils.getIdLocation((Item)mossStack.get(i).m_41720_());
            GTORecipeTypes.MIXER_RECIPES.recipeBuilder(mossId.m_135815_() + "_from_moss_block").inputItems(regularStack.get(i)).inputItems((Object)Blocks.f_152544_).inputFluids(GTMaterials.Water, 250).outputItems(mossStack.get(i)).duration(40).EUt(1L).save();
            GTORecipeTypes.MIXER_RECIPES.recipeBuilder(mossId.m_135815_() + "_from_vine").inputItems(regularStack.get(i)).inputItems((Object)Blocks.f_50191_).inputFluids(GTMaterials.Water, 250).outputItems(mossStack.get(i)).duration(40).EUt(1L).save();
        }
    }

    private static void registerNBTRemoval() {
        for (MachineDefinition chest : GTMachines.SUPER_CHEST) {
            if (chest == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)("super_chest_nbt_removal_" + chest.getTier()), (ItemStack)chest.asStack(), (Object[])new Object[]{chest.asItem()});
        }
        for (MachineDefinition tank : GTMachines.SUPER_TANK) {
            if (tank == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)("super_tank_nbt_removal_" + tank.getTier()), (ItemStack)tank.asStack(), (Object[])new Object[]{tank.asItem()});
        }
        for (MachineDefinition chest : GTMachines.QUANTUM_CHEST) {
            if (chest == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)("quantum_chest_nbt_removal_" + chest.getTier()), (ItemStack)chest.asStack(), (Object[])new Object[]{chest.asItem()});
        }
        for (MachineDefinition tank : GTMachines.QUANTUM_TANK) {
            if (tank == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)("quantum_tank_nbt_removal_" + tank.getTier()), (ItemStack)tank.asStack(), (Object[])new Object[]{tank.asItem()});
        }
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_wood", (ItemStack)GTMachines.WOODEN_DRUM.asStack(), (Object[])new Object[]{GTMachines.WOODEN_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_bronze", (ItemStack)GTMachines.BRONZE_DRUM.asStack(), (Object[])new Object[]{GTMachines.BRONZE_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_steel", (ItemStack)GTMachines.STEEL_DRUM.asStack(), (Object[])new Object[]{GTMachines.STEEL_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_aluminium", (ItemStack)GTMachines.ALUMINIUM_DRUM.asStack(), (Object[])new Object[]{GTMachines.ALUMINIUM_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_stainless_steel", (ItemStack)GTMachines.STAINLESS_STEEL_DRUM.asStack(), (Object[])new Object[]{GTMachines.STAINLESS_STEEL_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_gold", (ItemStack)GTMachines.GOLD_DRUM.asStack(), (Object[])new Object[]{GTMachines.GOLD_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_titanium", (ItemStack)GTMachines.TITANIUM_DRUM.asStack(), (Object[])new Object[]{GTMachines.TITANIUM_DRUM.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"drum_nbt_tungstensteel", (ItemStack)GTMachines.TUNGSTENSTEEL_DRUM.asStack(), (Object[])new Object[]{GTMachines.TUNGSTENSTEEL_DRUM.asItem()});
        VanillaRecipeHelper.addShapedNBTClearingRecipe((String)"cell_nbt_regular", (ItemStack)GTItems.FLUID_CELL.asStack(), (Object[])new Object[]{" C", "  ", Character.valueOf('C'), GTItems.FLUID_CELL.m_5456_()});
        VanillaRecipeHelper.addShapedNBTClearingRecipe((String)"cell_nbt_universal", (ItemStack)GTItems.FLUID_CELL_UNIVERSAL.asStack(), (Object[])new Object[]{" C", "  ", Character.valueOf('C'), GTItems.FLUID_CELL_UNIVERSAL.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_nbt_steel", (ItemStack)GTItems.FLUID_CELL_LARGE_STEEL.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_LARGE_STEEL.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_nbt_aluminium", (ItemStack)GTItems.FLUID_CELL_LARGE_ALUMINIUM.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_LARGE_ALUMINIUM.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_nbt_stainless_steel", (ItemStack)GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_nbt_titanium", (ItemStack)GTItems.FLUID_CELL_LARGE_TITANIUM.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_LARGE_TITANIUM.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_nbt_tungstensteel", (ItemStack)GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"cell_vial_nbt", (ItemStack)GTItems.FLUID_CELL_GLASS_VIAL.asStack(), (Object[])new Object[]{GTItems.FLUID_CELL_GLASS_VIAL.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_stick_nbt", (ItemStack)GTItems.TOOL_DATA_STICK.asStack(), (Object[])new Object[]{GTItems.TOOL_DATA_STICK.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_orb_nbt", (ItemStack)GTItems.TOOL_DATA_ORB.asStack(), (Object[])new Object[]{GTItems.TOOL_DATA_ORB.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_module_nbt", (ItemStack)GTItems.TOOL_DATA_MODULE.asStack(), (Object[])new Object[]{GTItems.TOOL_DATA_MODULE.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_neural_matrix", (ItemStack)GTOItems.NEURAL_MATRIX.asStack(), (Object[])new Object[]{GTOItems.NEURAL_MATRIX.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_atomic_archives", (ItemStack)GTOItems.ATOMIC_ARCHIVES.asStack(), (Object[])new Object[]{GTOItems.ATOMIC_ARCHIVES.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_obsidian_matrix", (ItemStack)GTOItems.OBSIDIAN_MATRIX.asStack(), (Object[])new Object[]{GTOItems.OBSIDIAN_MATRIX.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_microcosm", (ItemStack)GTOItems.MICROCOSM.asStack(), (Object[])new Object[]{GTOItems.MICROCOSM.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"data_closed_timelike_curve_guidance_unit", (ItemStack)GTOItems.CLOSED_TIMELIKE_CURVE_GUIDANCE_UNIT.asStack(), (Object[])new Object[]{GTOItems.CLOSED_TIMELIKE_CURVE_GUIDANCE_UNIT.m_5456_()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"me_pattern_buffer", (ItemStack)GTAEMachines.ME_PATTERN_BUFFER.asStack(), (Object[])new Object[]{GTAEMachines.ME_PATTERN_BUFFER.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"me_extend_pattern_buffer", (ItemStack)GTAEMachines.ME_EXTEND_PATTERN_BUFFER.asStack(), (Object[])new Object[]{GTAEMachines.ME_EXTEND_PATTERN_BUFFER.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"me_extend_pattern_buffer_ultra", (ItemStack)GTAEMachines.ME_EXTEND_PATTERN_BUFFER_ULTRA.asStack(), (Object[])new Object[]{GTAEMachines.ME_EXTEND_PATTERN_BUFFER_ULTRA.asItem()});
        VanillaRecipeHelper.addShapelessNBTClearingRecipe((String)"me_catalyst_me_pattern_buffer", (ItemStack)GTAEMachines.ME_CATALYST_ME_PATTERN_BUFFER.asStack(), (Object[])new Object[]{GTAEMachines.ME_CATALYST_ME_PATTERN_BUFFER.asItem()});
        VanillaRecipeHelper.addShapelessRecipe((String)"fluid_jetpack_clear", (ItemStack)GTItems.LIQUID_FUEL_JETPACK.asStack(), (Object[])new Object[]{GTItems.LIQUID_FUEL_JETPACK.m_5456_()});
        VanillaRecipeHelper.addShapelessRecipe((String)"item_filter_nbt", (ItemStack)GTItems.ITEM_FILTER.asStack(), (Object[])new Object[]{GTItems.ITEM_FILTER.m_5456_()});
        VanillaRecipeHelper.addShapelessRecipe((String)"fluid_filter_nbt", (ItemStack)GTItems.FLUID_FILTER.asStack(), (Object[])new Object[]{GTItems.FLUID_FILTER.m_5456_()});
        VanillaRecipeHelper.addShapelessRecipe((String)"item_tag_filter_nbt", (ItemStack)GTItems.TAG_FILTER.asStack(), (Object[])new Object[]{GTItems.TAG_FILTER.m_5456_()});
        VanillaRecipeHelper.addShapelessRecipe((String)"fluid_tag_filter_nbt", (ItemStack)GTItems.TAG_FLUID_FILTER.asStack(), (Object[])new Object[]{GTItems.TAG_FLUID_FILTER.m_5456_()});
    }

    private static void registerHatchConversion() {
        String tierName;
        int i;
        for (i = 0; i < GTMachines.FLUID_IMPORT_HATCH.length; ++i) {
            if (GTMachines.FLUID_IMPORT_HATCH[i] == null || GTMachines.FLUID_EXPORT_HATCH[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_output_to_input_" + GTMachines.FLUID_IMPORT_HATCH[i].getTier()), (ItemLike)GTMachines.FLUID_IMPORT_HATCH[i].asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.FLUID_EXPORT_HATCH[i].asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_input_to_output_" + GTMachines.FLUID_EXPORT_HATCH[i].getTier()), (ItemLike)GTMachines.FLUID_EXPORT_HATCH[i].asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.FLUID_IMPORT_HATCH[i].asItem()});
        }
        for (i = 0; i < GTMachines.ITEM_IMPORT_BUS.length; ++i) {
            if (GTMachines.ITEM_IMPORT_BUS[i] == null || GTMachines.ITEM_EXPORT_BUS[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe((String)("item_bus_output_to_input_" + GTMachines.ITEM_IMPORT_BUS[i].getTier()), (ItemLike)GTMachines.ITEM_IMPORT_BUS[i].asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.ITEM_EXPORT_BUS[i].asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("item_bus_input_to_output_" + GTMachines.ITEM_EXPORT_BUS[i].getTier()), (ItemLike)GTMachines.ITEM_EXPORT_BUS[i].asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.ITEM_IMPORT_BUS[i].asItem()});
        }
        for (int tier : GTMachineUtils.MULTI_HATCH_TIERS) {
            tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            MachineDefinition importHatch4x = GTMachines.FLUID_IMPORT_HATCH_4X[tier];
            MachineDefinition exportHatch4x = GTMachines.FLUID_EXPORT_HATCH_4X[tier];
            MachineDefinition importHatch9x = GTMachines.FLUID_IMPORT_HATCH_9X[tier];
            MachineDefinition exportHatch9x = GTMachines.FLUID_EXPORT_HATCH_9X[tier];
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_4x_output_to_input_" + tierName), (ItemLike)importHatch4x.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), exportHatch4x.asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_4x_input_to_output_" + tierName), (ItemLike)exportHatch4x.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), importHatch4x.asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_9x_output_to_input_" + tierName), (ItemLike)importHatch9x.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), exportHatch9x.asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("fluid_hatch_9x_input_to_output_" + tierName), (ItemLike)exportHatch9x.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), importHatch9x.asItem()});
        }
        for (int tier : GTValues.tiersBetween((int)1, (int)14)) {
            tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            MachineDefinition inputBuffer = GTMachines.DUAL_IMPORT_HATCH[tier];
            MachineDefinition outputBuffer = GTMachines.DUAL_EXPORT_HATCH[tier];
            VanillaRecipeHelper.addShapedRecipe((String)("dual_hatch_output_to_input_" + tierName), (ItemLike)inputBuffer.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), outputBuffer.asItem()});
            VanillaRecipeHelper.addShapedRecipe((String)("dual_hatch_input_to_output_" + tierName), (ItemLike)outputBuffer.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), inputBuffer.asItem()});
        }
        VanillaRecipeHelper.addShapedRecipe((String)"steam_bus_output_to_input", (ItemLike)GTMachines.STEAM_EXPORT_BUS.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.STEAM_IMPORT_BUS.asItem()});
        VanillaRecipeHelper.addShapedRecipe((String)"steam_bus_input_to_output", (ItemLike)GTMachines.STEAM_IMPORT_BUS.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTMachines.STEAM_EXPORT_BUS.asItem()});
        VanillaRecipeHelper.addShapedRecipe((String)"me_fluid_hatch_output_to_input", (ItemLike)GTAEMachines.FLUID_IMPORT_HATCH_ME.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTAEMachines.FLUID_EXPORT_HATCH_ME.asItem()});
        VanillaRecipeHelper.addShapedRecipe((String)"me_fluid_hatch_input_to_output", (ItemLike)GTAEMachines.FLUID_EXPORT_HATCH_ME.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTAEMachines.FLUID_IMPORT_HATCH_ME.asItem()});
        VanillaRecipeHelper.addShapedRecipe((String)"me_item_bus_output_to_input", (ItemLike)GTAEMachines.ITEM_IMPORT_BUS_ME.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTAEMachines.ITEM_EXPORT_BUS_ME.asItem()});
        VanillaRecipeHelper.addShapedRecipe((String)"me_item_bus_input_to_output", (ItemLike)GTAEMachines.ITEM_EXPORT_BUS_ME.asItem(), (Object[])new Object[]{"d", "B", Character.valueOf('B'), GTAEMachines.ITEM_IMPORT_BUS_ME.asItem()});
    }
}

