/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.data.trade;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.api.gui.StackTexture;
import com.gtocore.common.data.GTOMachines;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.data.transaction.data.TradeLang;
import com.gtocore.data.transaction.manager.TradeData;
import com.gtocore.data.transaction.manager.TradeEntry;
import com.gtocore.data.transaction.manager.TradingManager;
import com.gtolib.utils.WalletUtils;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class WelcomeGroup {
    private static final String Weekly_check_in = "Weekly check-in";
    private static final long Weekly_time = 140L;

    public static void init() {
        int GroupIndex = TradingManager.INSTANCE.addShopGroup(TradeLang.addTradeLang("\u6b22\u8fce\u6765\u5230\u683c\u96f7\u79d1\u6280", "Welcome to Gray Technology"), (IGuiTexture)GuiTextures.GREGTECH_LOGO, (IGuiTexture)GuiTextures.GREGTECH_LOGO);
        int ShopIndex1 = TradingManager.INSTANCE.addShopByGroupIndex(GroupIndex, TradeLang.addTradeLang("\u683c\u96f7\u79d1\u6280\u9500\u552e\u90e8\u5151\u5e01\u533a", "Currency Exchange Area of Gray Technology Sales Department"), "Base", Set.of("tech_operator_coin"), (IGuiTexture)new ItemStackTexture(new ItemStack[]{ChemicalHelper.get((TagPrefix)GTOTagPrefix.COIN, (Material)GTMaterials.Neutronium)}));
        Material[] materials = new Material[]{GTMaterials.Copper, GTMaterials.Cupronickel, GTMaterials.Silver, GTMaterials.Gold, GTMaterials.Osmium, GTMaterials.Naquadah, GTMaterials.Neutronium, GTOMaterials.Adamantine, GTOMaterials.Infinity, GTOMaterials.Neutron};
        for (int i = 0; i < materials.length; ++i) {
            TradingManager.INSTANCE.addTradeEntryByIndices(GroupIndex, ShopIndex1, WelcomeGroup.createCoinExchangeTrade(materials[i], i));
            TradingManager.INSTANCE.addTradeEntryByIndices(GroupIndex, ShopIndex1, WelcomeGroup.createCoinWithdrawTrade(materials[i], i));
        }
        int ShopIndex2 = TradingManager.INSTANCE.addShopByGroupIndex(GroupIndex, TradeLang.addTradeLang("\u683c\u96f7\u79d1\u6280\u9500\u552e\u90e8\u4f1a\u5458\u533a", "Membership Area of Gray Technology Sales Department"), "Base", Set.of("tech_operator_coin"), (IGuiTexture)new ResourceTexture("minecraft:textures/mob_effect/luck.png"));
        TradingManager.INSTANCE.addTradeEntryByIndices(GroupIndex, ShopIndex2, new TradeEntry.Builder().texture((IGuiTexture)new ResourceTexture("minecraft:textures/mob_effect/luck.png")).description(List.of(Component.m_237115_((String)TradeLang.addTradeLang("\u6bcf\u5468\u7b7e\u5230", Weekly_check_in)), Component.m_237115_((String)TradeLang.addTradeLang("\u9886\u53d6\u5e78\u8fd0\u7269\u8d44", "Claim lucky supplies")))).unlockCondition("Base").preCheck(WelcomeGroup::checkThisWeek).onExecute(WelcomeGroup::performCheckIn).build());
        for (int i = 1; i < 8; ++i) {
            TradingManager.INSTANCE.addTradeEntryByIndices(GroupIndex, ShopIndex2, new TradeEntry.Builder().texture((IGuiTexture)new StackTexture((Object)GTOMachines.TRADING_STATION[1].asStack())).addDescription((Component)Component.m_237115_((String)TradeLang.addTradeLang("\u5347\u7ea7\u8d38\u6613\u7ad9", "Upgrade Trading Station"))).addDescription((Component)Component.m_237110_((String)"gtocore.trade_group.exchanged", (Object[])new Object[]{"Tier" + (i + 1), "Tier" + i})).unlockCondition("Base").inputItem(GTOMachines.TRADING_STATION[i].asStack()).inputCurrency("tech_operator_coin", 4 << i * 3).outputItem(GTOMachines.TRADING_STATION[i + 1].asStack()).build());
        }
    }

    public static TradeEntry createCoinExchangeTrade(Material material, int tier) {
        ItemStack Coin = ChemicalHelper.get((TagPrefix)GTOTagPrefix.COIN, (Material)material);
        return new TradeEntry.Builder().texture((IGuiTexture)new ItemStackTexture(new ItemStack[]{Coin})).description(List.of(Component.m_237110_((String)"gtocore.trade_group.exchanged", (Object[])new Object[]{Component.m_237115_((String)"gtocore.currency.tech_operator_coin"), Coin.m_41611_()}))).unlockCondition("Base").inputItem(Coin).outputCurrency("tech_operator_coin", 1L << tier * 3).build();
    }

    public static TradeEntry createCoinWithdrawTrade(Material material, int tier) {
        ItemStack Coin = ChemicalHelper.get((TagPrefix)GTOTagPrefix.COIN, (Material)material);
        return new TradeEntry.Builder().texture((IGuiTexture)new ItemStackTexture(new ItemStack[]{Coin})).description(List.of(Component.m_237110_((String)"gtocore.trade_group.exchanged", (Object[])new Object[]{Coin.m_41611_(), Component.m_237115_((String)"gtocore.currency.tech_operator_coin")}))).unlockCondition("Base").inputCurrency("tech_operator_coin", 1L << tier * 3).outputItem(Coin).build();
    }

    private static int checkThisWeek(TradeData data, TradeEntry entry) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        long time = WalletUtils.getGameMinuteKey((Level)level) / 140L * 140L;
        if (WalletUtils.getTransactionMinuteAmount((UUID)data.uuid(), (Level)serverLevel, (String)Weekly_check_in, (long)time) == 0L) {
            return 1;
        }
        return 0;
    }

    private static void performCheckIn(TradeData data, TradeEntry entry, int multiplier) {
        Level level = data.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        WalletUtils.addTimingCompressionStrategyTransaction((UUID)data.uuid(), (Level)serverLevel, (String)Weekly_check_in, (long)140L, (long)1L);
        WalletUtils.addCurrency((UUID)data.uuid(), (Level)serverLevel, (String)"tech_operator_coin", (long)(LDLib.random.nextInt() & 0x64));
    }
}

