/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel;

import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gtocore.api.travel.TravelMode;
import com.gtocore.common.item.TravelStaffBehavior;
import com.gtocore.eio_travel.api.TravelHandler;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.Input;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class TravelEvents {
    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ComponentItem c;
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof ComponentItem) || !(c = (ComponentItem)item).getComponents().stream().anyMatch(comp -> comp instanceof TravelStaffBehavior)) {
            return;
        }
        event.setCanceled(true);
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        TravelMode currentMode = TravelEvents.gtocore$getTravelMode(stack);
        TravelMode nextMode = currentMode.next();
        TravelEvents.gtocore$setTravelMode(stack, nextMode);
        if (nextMode == TravelMode.FILTER_BY_BLOCK) {
            BlockPos pos = event.getPos();
            BlockState blockState = level.m_8055_(pos);
            String blockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_())).toString();
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_("FilterBlock", blockId);
            player.m_5661_((Component)Component.m_237115_((String)"gtocore.travel.mode.switched").m_130946_(": ").m_7220_(nextMode.getDisplayName()).m_130946_(" [").m_7220_((Component)Component.m_237113_((String)blockId).m_130940_(ChatFormatting.YELLOW)).m_130946_("]"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"gtocore.travel.mode.switched").m_130946_(": ").m_7220_(nextMode.getDisplayName()), true);
        }
    }

    private static TravelMode gtocore$getTravelMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return TravelMode.fromString(tag.m_128461_("TravelMode"));
    }

    private static void gtocore$setTravelMode(ItemStack stack, TravelMode mode) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("TravelMode", mode.m_7912_());
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Client {
        private static boolean LAST_JUMPING = false;
        private static boolean LAST_SNEAKING = false;
        private static int JUMP_COOLDOWN = 0;

        @SubscribeEvent
        public static void movementInputUpdate(MovementInputUpdateEvent event) {
            boolean success;
            Input input = event.getInput();
            Player player = event.getEntity();
            boolean isNewJump = input.f_108572_ && !LAST_JUMPING;
            LAST_JUMPING = input.f_108572_;
            boolean isNewCrouch = input.f_108573_ && !LAST_SNEAKING;
            LAST_SNEAKING = input.f_108573_;
            if (!player.m_20096_() || !TravelHandler.canBlockTeleport(player)) {
                JUMP_COOLDOWN = 0;
                return;
            }
            if (isNewJump) {
                boolean success2 = TravelHandler.blockElevatorTeleport(player.m_9236_(), player, Direction.UP, true);
                if (!success2) {
                    success2 = TravelHandler.blockTeleport(player.m_9236_(), player, true);
                }
                JUMP_COOLDOWN = success2 ? 7 : 0;
            } else if (isNewCrouch && !(success = TravelHandler.blockElevatorTeleport(player.m_9236_(), player, Direction.DOWN, true))) {
                TravelHandler.blockTeleport(player.m_9236_(), player, true);
            }
            if (JUMP_COOLDOWN > 0) {
                --JUMP_COOLDOWN;
                input.f_108572_ = false;
            }
        }

        @SubscribeEvent
        public static void emptyClick(PlayerInteractEvent.RightClickEmpty event) {
            Player player = event.getEntity();
            if (TravelHandler.canBlockTeleport(player) && !player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().m_21120_(InteractionHand.OFF_HAND).m_41619_() && event.getItemStack().m_41619_() && TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
                player.m_21011_(event.getHand(), true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }

        @SubscribeEvent
        public static void blockClick(PlayerInteractEvent.RightClickBlock event) {
            Player player = event.getEntity();
            if (!TravelHandler.canBlockTeleport(player)) {
                return;
            }
            if (TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void itemClick(PlayerInteractEvent.RightClickItem event) {
            Player player = event.getEntity();
            if (!TravelHandler.canBlockTeleport(player)) {
                return;
            }
            if (TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

