/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.eio_travel.network;

import com.google.common.base.Predicates;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.eio_travel.ITravelTarget;
import com.gtocore.eio_travel.api.TravelHandler;
import com.gtocore.eio_travel.api.TravelRegistry;
import com.gtocore.eio_travel.api.TravelSavedData;
import com.gtolib.api.network.NetworkPack;
import com.gtolib.utils.ServerUtils;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TravelNetworks {
    private static final NetworkPack ADD_TRAVEL = NetworkPack.registerS2C((String)"eio_travel:add_travel", (player, buf) -> TravelRegistry.deserialize(buf.m_130260_()).ifPresent(TravelNetworks::handleAddTravel));
    private static final NetworkPack SYNC_TRAVEL = NetworkPack.registerS2C((String)"eio_travel:sync_travel", (player, buf) -> {
        CompoundTag nbt = buf.m_130260_();
        TravelSavedData travelData = TravelSavedData.getTravelData(GTUtil.getClientLevel());
        travelData.loadNBT(nbt);
    });
    private static final NetworkPack REMOVE_TRAVEL = NetworkPack.registerS2C((String)"eio_travel:remove_travel", (player, buf) -> {
        TravelSavedData travelData = TravelSavedData.getTravelData(GTUtil.getClientLevel());
        travelData.removeTravelTargetAt(GTUtil.getClientLevel(), buf.m_130135_());
    });
    private static final NetworkPack REQUEST_TRAVEL = NetworkPack.registerC2S((String)"eio_travel:request_travel", TravelNetworks::handleRequest);

    public static void onServerTravelAdded(ITravelTarget target) {
        ADD_TRAVEL.send(b2 -> b2.m_130079_(target.save()), new Object[]{ServerUtils.getServer()});
    }

    public static void syncTravelData(CompoundTag nbt, ServerPlayer player) {
        SYNC_TRAVEL.send(b2 -> b2.m_130079_(nbt), new Object[]{player});
    }

    public static void syncTravelData(CompoundTag nbt, ServerLevel level) {
        SYNC_TRAVEL.send(b2 -> b2.m_130079_(nbt), new Object[]{level.m_8795_((Predicate)Predicates.alwaysTrue())});
    }

    public static void onServerTravelRemoved(BlockPos pos) {
        REMOVE_TRAVEL.send(b2 -> b2.m_130064_(pos), new Object[]{ServerUtils.getServer()});
    }

    public static void requestTravel(BlockPos pos) {
        REQUEST_TRAVEL.send(b2 -> b2.m_130064_(pos), new Object[0]);
    }

    private static void handleAddTravel(ITravelTarget target) {
        TravelSavedData travelData = TravelSavedData.getTravelData(GTUtil.getClientLevel());
        travelData.addTravelTarget(GTUtil.getClientLevel(), target);
    }

    private static void handleRequest(ServerPlayer player, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        if (player == null) {
            return;
        }
        TravelSavedData travelData = TravelSavedData.getTravelData(player.m_9236_());
        Optional<ITravelTarget> target = travelData.getTravelTarget(pos);
        if (!TravelHandler.canBlockTeleport((Player)player)) {
            player.m_5661_(Component.m_130674_((String)"ERROR: Cannot teleport"), true);
            return;
        }
        if (target.isEmpty()) {
            player.m_5661_(Component.m_130674_((String)"ERROR: Destination not a valid target"), true);
            return;
        }
        int range = Math.max(target.get().getBlock2BlockRange(), target.get().getItem2BlockRange());
        if (pos.m_123331_((Vec3i)player.m_20097_()) > (double)(range * range)) {
            player.m_5661_(Component.m_130674_((String)"ERROR: Too far"), true);
            return;
        }
        TravelHandler.blockTeleportAround(player.m_9236_(), (Player)player, target.get().getPos(), false);
    }
}

