/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.apotheosis;

import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.integration.apotheosis.NumeralStatsAffix;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

@DataGeneratorScanned
public class BedrockMineRestoreAffix
extends NumeralStatsAffix {
    @RegisterLanguage(cn="\u6bcf\u6b21\u5f00\u91c7\u77ff\u77f3\u53ef\u4ee5\u5728\u5f53\u524d\u533a\u5757\u52d8\u63a2\u51fa\u76f8\u5f53\u4e8e\u4e00\u822c\u50a8\u91cf%s\u2030\u7684\u989d\u5916\u57fa\u5ca9\u77ff\u8109\u50a8\u91cf", en="Each time you mine ore, you can explore an additional bedrock ore vein reserve equivalent to %s\u2030 of the average reserve in the current chunk")
    private static final String DESC = "affix.gtocore.bedrock_mine_restore.desc";
    @RegisterLanguage(cn="\u6bcf\u6b21\u5f00\u91c7\u77ff\u77f3\u53ef\u4ee5\u5728\u5f53\u524d\u533a\u5757\u52d8\u63a2\u51fa\u76f8\u5f53\u4e8e\u4e00\u822c\u50a8\u91cf%s\u2030\u7684\u989d\u5916\u57fa\u5ca9\u6d41\u4f53\u77ff\u8109\u50a8\u91cf", en="Each time you mine ore, you can explore an additional bedrock fluid vein reserve equivalent to %s\u2030 of the average reserve in the current chunk")
    private static final String FLUID_DESC = "affix.gtocore.bedrock_mine_restore.fluid.desc";
    public static final Codec<BedrockMineRestoreAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(NumeralStatsAffix::getValues), (App)Codec.BOOL.fieldOf("fluid").forGetter(BedrockMineRestoreAffix::isFluidMode)).apply((Applicative)inst, BedrockMineRestoreAffix::new));
    private final boolean isFluidMode;

    public BedrockMineRestoreAffix(Map<LootRarity, StepFunction> values, boolean isFluidMode) {
        super(values);
        this.isFluidMode = isFluidMode;
    }

    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        String desc = this.isFluidMode ? FLUID_DESC : DESC;
        return Component.m_237110_((String)desc, (Object[])new Object[]{FormattingUtil.formatNumber2Places((double)((double)this.getBuff(rarity, level) * 0.01))});
    }

    @Override
    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (state.m_204336_(Tags.Blocks.ORES)) {
                ChunkPos chunkPos = new ChunkPos(pos);
                if (this.isFluidMode) {
                    BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate((ServerLevel)serverLevel);
                    if (data.getFluidVeinWorldEntry(chunkPos.f_45578_, chunkPos.f_45579_).getDefinition() != null) {
                        data.depleteVein(chunkPos.f_45578_, chunkPos.f_45579_, -Math.round(this.getBuff(rarity, level)), true);
                    }
                } else {
                    BedrockOreVeinSavedData data = BedrockOreVeinSavedData.getOrCreate((ServerLevel)serverLevel);
                    if (data.getOreVeinWorldEntry(chunkPos.f_45578_, chunkPos.f_45579_).getDefinition() != null) {
                        data.depleteVein(chunkPos.f_45578_, chunkPos.f_45579_, -Math.round(this.getBuff(rarity, level)), true);
                    }
                }
            }
        }
    }

    @Generated
    public boolean isFluidMode() {
        return this.isFluidMode;
    }
}

