/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.xei.widgets.GTRecipeWidget;
import com.gtolib.api.recipe.ContentBuilder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.lowdragmc.lowdraglib.emi.ModularEmiRecipe;
import com.lowdragmc.lowdraglib.emi.ModularForegroundRenderWidget;
import com.lowdragmc.lowdraglib.emi.ModularWrapperWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;

public final class GTEMIRecipe
extends ModularEmiRecipe<com.lowdragmc.lowdraglib.gui.widget.Widget> {
    private static final Map<GTRecipeType, com.lowdragmc.lowdraglib.gui.widget.Widget> EMI_RECIPE_WIDGETS = new Reference2ReferenceOpenHashMap();
    private final EmiRecipeCategory category;
    private final Recipe recipe;
    public final IntSupplier displayPriority;

    public GTEMIRecipe(Recipe recipe, EmiRecipeCategory category) {
        super(() -> EMI_RECIPE_WIDGETS.computeIfAbsent(recipe.recipeType, type -> new com.lowdragmc.lowdraglib.gui.widget.Widget(GTEMIRecipe.getXOffset(recipe), 0, type.getRecipeUI().getJEISize().width, GTEMIRecipe.getHeight(recipe))));
        this.recipe = recipe;
        this.category = category;
        this.displayPriority = () -> recipe.displayPriority;
        this.inputs = null;
        this.widget = () -> new GTRecipeWidget((GTRecipe)recipe);
    }

    public int getTier() {
        return this.recipe.tier;
    }

    public GTRecipeType getRecipeType() {
        return this.recipe.recipeType;
    }

    private static int getXOffset(Recipe recipe) {
        if (recipe.recipeType.getRecipeUI().getOriginalWidth() != recipe.recipeType.getRecipeUI().getJEISize().width) {
            return (recipe.recipeType.getRecipeUI().getJEISize().width - recipe.recipeType.getRecipeUI().getOriginalWidth()) / 2;
        }
        return 0;
    }

    private static int getHeight(Recipe recipe) {
        return recipe.recipeType.getRecipeUI().getJEISize().height + recipe.conditions.size() * 10;
    }

    public int getDisplayHeight() {
        return GTEMIRecipe.getHeight(this.recipe);
    }

    private static EmiIngredient getEmiIngredient(Ingredient ingredient, boolean input) {
        long amount;
        Ingredient inner = FastSizedIngredient.getInner((Ingredient)ingredient);
        ItemStack[] itemStacks = inner.m_43908_();
        if (itemStacks.length == 0) {
            return EmiStack.EMPTY;
        }
        ItemStack itemStack = itemStacks[0];
        if (ingredient instanceof FastSizedIngredient) {
            FastSizedIngredient sizedIngredient = (FastSizedIngredient)ingredient;
            amount = sizedIngredient.getAmount();
        } else {
            amount = itemStack.m_41613_();
        }
        Ingredient.Value[] valueArray = inner.f_43902_;
        int n = valueArray.length;
        int n2 = 0;
        if (n2 < n) {
            Ingredient.Value value = valueArray[n2];
            if (input && value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                return new TagEmiIngredient(tagValue.f_43959_, amount);
            }
            Item item = itemStack.m_41720_();
            CompoundTag nbt = itemStack.m_41783_();
            if (nbt == null || nbt.m_128456_()) {
                return new ItemEmiStack(item, null, amount);
            }
            ItemEmiStack stack = new ItemEmiStack(item, nbt, amount);
            stack.comparison(EmiPort.compareStrict());
            return stack;
        }
        return EmiStack.EMPTY;
    }

    public List<EmiIngredient> getInputs() {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
            this.recipe.inputs.forEach((k, v) -> {
                if (k instanceof ItemRecipeCapability) {
                    v.forEach(c -> {
                        Object patt0$temp = c.getContent();
                        if (patt0$temp instanceof Ingredient) {
                            Ingredient ingredient = (Ingredient)patt0$temp;
                            float chance = (float)c.chance / (float)ContentBuilder.maxChance;
                            EmiIngredient emiIngredient = GTEMIRecipe.getEmiIngredient(ingredient, true).setChance(chance);
                            if (chance > 0.0f) {
                                this.inputs.add(emiIngredient);
                            } else {
                                this.catalysts.add(emiIngredient);
                            }
                        }
                    });
                } else if (k instanceof FluidRecipeCapability) {
                    v.forEach(c -> {
                        FluidIngredient ingredient;
                        FluidStack[] stacks;
                        Object patt0$temp = c.getContent();
                        if (patt0$temp instanceof FluidIngredient && (stacks = (ingredient = (FluidIngredient)patt0$temp).getStacks()).length != 0) {
                            float chance = (float)c.chance / (float)ContentBuilder.maxChance;
                            EmiStack emiIngredient = EmiStack.of((Fluid)stacks[0].getFluid(), (CompoundTag)stacks[0].getTag(), (long)stacks[0].getAmount()).setChance(chance);
                            if (chance > 0.0f) {
                                this.inputs.add(emiIngredient);
                            } else {
                                this.catalysts.add(emiIngredient);
                            }
                        }
                    });
                }
            });
            this.recipe.outputs.forEach((k, v) -> {
                if (k instanceof ItemRecipeCapability) {
                    v.forEach(c -> {
                        Object patt0$temp = c.getContent();
                        if (patt0$temp instanceof Ingredient) {
                            Ingredient ingredient = (Ingredient)patt0$temp;
                            float chance = (float)c.chance / (float)ContentBuilder.maxChance;
                            this.outputs.add((EmiStack)GTEMIRecipe.getEmiIngredient(ingredient, false).setChance(chance));
                        }
                    });
                } else if (k instanceof FluidRecipeCapability) {
                    v.forEach(c -> {
                        Object patt0$temp = c.getContent();
                        if (patt0$temp instanceof FluidIngredient) {
                            FluidIngredient ingredient = (FluidIngredient)patt0$temp;
                            float chance = (float)c.chance / (float)ContentBuilder.maxChance;
                            FluidStack[] stacks = ingredient.getStacks();
                            if (stacks.length != 0) {
                                this.outputs.add(EmiStack.of((Fluid)stacks[0].getFluid(), (CompoundTag)stacks[0].getTag(), (long)stacks[0].getAmount()).setChance(chance));
                            }
                        }
                    });
                }
            });
        }
        return this.inputs;
    }

    public List<com.lowdragmc.lowdraglib.gui.widget.Widget> getFlatWidgetCollection(com.lowdragmc.lowdraglib.gui.widget.Widget widget2) {
        return Collections.emptyList();
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWidgets(WidgetHolder widgets) {
        com.lowdragmc.lowdraglib.gui.widget.Widget widget2 = (com.lowdragmc.lowdraglib.gui.widget.Widget)this.widget.get();
        ModularWrapper modular = new ModularWrapper(widget2);
        modular.setRecipeWidget(0, 0);
        List list = CACHE_OPENED;
        synchronized (list) {
            CACHE_OPENED.add(modular);
        }
        ArrayList<com.lowdragmc.lowdraglib.gui.widget.Widget> widgetList = new ArrayList<com.lowdragmc.lowdraglib.gui.widget.Widget>();
        if (widget2 instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)widget2;
            for (com.lowdragmc.lowdraglib.gui.widget.Widget w : group.widgets) {
                widgetList.add(w);
                if (!(w instanceof WidgetGroup)) continue;
                WidgetGroup group1 = (WidgetGroup)w;
                widgetList.addAll(group1.getContainedWidgets(true));
            }
        } else {
            widgetList.add(widget2);
        }
        ArrayList<dev.emi.emi.api.widget.SlotWidget> slots = new ArrayList<dev.emi.emi.api.widget.SlotWidget>();
        for (com.lowdragmc.lowdraglib.gui.widget.Widget w : widgetList) {
            IngredientIO io;
            DraggableScrollableWidgetGroup draggable;
            if (!(w instanceof IRecipeIngredientSlot)) continue;
            IRecipeIngredientSlot slot = (IRecipeIngredientSlot)w;
            WidgetGroup widgetGroup = w.getParent();
            if (widgetGroup instanceof DraggableScrollableWidgetGroup && (draggable = (DraggableScrollableWidgetGroup)widgetGroup).isUseScissor() || (io = slot.getIngredientIO()) == null || io == IngredientIO.RENDER_ONLY) continue;
            EmiIngredient ingredients = EmiIngredient.of((List)slot.getXEIIngredients());
            dev.emi.emi.api.widget.SlotWidget slotWidget = null;
            if (slot instanceof SlotWidget) {
                SlotWidget slotW = (SlotWidget)slot;
                slotW.setHandlerSlot((IItemHandlerModifiable)EmptyHandler.INSTANCE, 0);
                slotW.setDrawHoverOverlay(false).setDrawHoverTips(false);
            } else if (slot instanceof TankWidget) {
                TankWidget tankW = (TankWidget)slot;
                tankW.setFluidTank((IFluidHandler)EmptyFluidHandler.INSTANCE);
                tankW.setDrawHoverOverlay(false).setDrawHoverTips(false);
                long capacity = Math.max(1L, ingredients.getAmount());
                slotWidget = new dev.emi.emi.api.widget.TankWidget(ingredients, w.getPosition().x, w.getPosition().y, w.getSize().width, w.getSize().height, capacity);
            }
            if (slotWidget == null) {
                slotWidget = new dev.emi.emi.api.widget.SlotWidget(ingredients, w.getPosition().x, w.getPosition().y);
            }
            slotWidget.customBackground(null, w.getPosition().x, w.getPosition().y, w.getSize().width, w.getSize().height).drawBack(false);
            if (io == IngredientIO.CATALYST) {
                slotWidget.catalyst(true);
            } else if (io == IngredientIO.OUTPUT) {
                slotWidget.recipeContext((EmiRecipe)this);
            }
            for (Component component : w.getTooltipTexts()) {
                slotWidget.appendTooltip(component);
            }
            slots.add(slotWidget);
        }
        widgets.add((Widget)new ModularWrapperWidget(modular, slots));
        slots.forEach(arg_0 -> ((WidgetHolder)widgets).add(arg_0));
        widgets.add((Widget)new ModularForegroundRenderWidget(modular));
    }
}

