/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.item.ItemMap;
import com.gtocore.data.tag.Tags;
import com.gtocore.integration.emi.multipage.MultiblockInfoEmiRecipe;
import com.hepdd.gtmthings.api.misc.Hatch;
import com.hepdd.gtmthings.common.item.VirtualItemProviderBehavior;
import com.hepdd.gtmthings.data.CustomItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.TagEmiIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTEmiEncodingHelper {
    @Nullable
    private static GenericStack ofVirtual(EmiStack stack, long amount) {
        if (stack.getKey() instanceof Item) {
            ItemStack item = CustomItems.VIRTUAL_ITEM_PROVIDER.asStack();
            item.m_41784_().m_128379_("marked", true);
            return new GenericStack((AEKey)AEItemKey.of((ItemStack)VirtualItemProviderBehavior.setVirtualItem((ItemStack)item, (ItemStack)stack.getItemStack())), amount);
        }
        return null;
    }

    private static List<GenericStack> intoGenericStack(EmiIngredient ingredient, boolean virtual) {
        if (ingredient.isEmpty()) {
            return Collections.emptyList();
        }
        if (ingredient instanceof TagEmiIngredient) {
            TagEmiIngredient tag = (TagEmiIngredient)ingredient;
            if (Tags.CIRCUITS_ARRAY.containsKey(tag.key)) {
                return ingredient.getEmiStacks().stream().filter(stack -> {
                    ItemEmiStack itemEmiStack;
                    return stack instanceof ItemEmiStack && ItemMap.UNIVERSAL_CIRCUITS.contains((itemEmiStack = (ItemEmiStack)stack).getKey());
                }).map(stack -> GTEmiEncodingHelper.fromEmiStackVirtualConvertible(stack, ingredient.getAmount(), virtual)).toList();
            }
        }
        return ingredient.getEmiStacks().stream().map(stack -> GTEmiEncodingHelper.fromEmiStackVirtualConvertible(stack, ingredient.getAmount(), virtual)).toList();
    }

    private static GenericStack fromEmiStackVirtualConvertible(EmiStack stack, long amount, boolean virtual) {
        if (stack.getKey() instanceof Item) {
            if (virtual) {
                return GTEmiEncodingHelper.ofVirtual(stack, amount);
            }
            return new GenericStack((AEKey)AEItemKey.of((ItemStack)stack.getItemStack()), amount);
        }
        Object object = stack.getKey();
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            return new GenericStack((AEKey)AEFluidKey.of((Fluid)fluid), amount);
        }
        return new GenericStack((AEKey)AEItemKey.of((ItemLike)Items.f_42398_), 0L);
    }

    public static List<GenericStack> intoGenericStack(EmiIngredient ingredient) {
        return GTEmiEncodingHelper.intoGenericStack(ingredient, false);
    }

    public static List<List<GenericStack>> ofInputs(EmiRecipe emiRecipe) {
        ArrayList<List<GenericStack>> list;
        block12: {
            block11: {
                if (emiRecipe instanceof MultiblockInfoEmiRecipe) {
                    MultiblockInfoEmiRecipe recipe = (MultiblockInfoEmiRecipe)emiRecipe;
                    Stream<List<Object>> layerInputsStream = GTEmiEncodingHelper.getProcessedLayerInputs(recipe, recipe.i);
                    if (recipe.i > 0 && recipe.definition.getSubPatternFactory() != null) {
                        if (GTUtil.isShiftDown()) {
                            layerInputsStream = Stream.concat(GTEmiEncodingHelper.getProcessedLayerInputs(recipe, 0), layerInputsStream);
                        }
                        if (GTUtil.isCtrlDown()) {
                            layerInputsStream = IntStream.rangeClosed(0, recipe.i).boxed().flatMap(layerIndex -> GTEmiEncodingHelper.getProcessedLayerInputs(recipe, layerIndex));
                        }
                    }
                    List<List<GenericStack>> layerInputs = layerInputsStream.toList();
                    AEItemKey controllerKey = AEItemKey.of((ItemLike)recipe.definition.asItem());
                    long controllerCount = 0L;
                    for (List<GenericStack> stackList : layerInputs) {
                        for (GenericStack stack : stackList) {
                            if (controllerKey != stack.what()) continue;
                            controllerCount += stack.amount();
                        }
                    }
                    if (controllerCount > 1L) {
                        return GTEmiEncodingHelper.consolidateControllerStacks(layerInputs, controllerKey);
                    }
                    return layerInputs;
                }
                list = new ArrayList<List<GenericStack>>();
                if (GTUtil.isShiftDown()) break block11;
                if (!GTUtil.isCtrlDown()) break block12;
            }
            emiRecipe.getCatalysts().stream().map(s -> GTEmiEncodingHelper.intoGenericStack(s, GTUtil.isCtrlDown())).forEach(list::add);
            if (list.isEmpty() && GTUtil.isCtrlDown()) {
                AEItemKey itemKey = AEItemKey.of((ItemStack)VirtualItemProviderBehavior.setVirtualItem((ItemStack)CustomItems.VIRTUAL_ITEM_PROVIDER.asStack(), (ItemStack)ItemStack.f_41583_));
                itemKey.getTag().m_128379_("marked", true);
                list.add(List.of(new GenericStack((AEKey)itemKey, 1L)));
            }
        }
        emiRecipe.getInputs().stream().map(GTEmiEncodingHelper::intoGenericStack).forEach(list::add);
        return list;
    }

    @NotNull
    private static List<List<GenericStack>> consolidateControllerStacks(List<List<GenericStack>> layerInputs, AEItemKey controllerKey) {
        ArrayList<List<GenericStack>> filteredList = new ArrayList<List<GenericStack>>();
        boolean controllerKept = false;
        for (List<GenericStack> stackList : layerInputs) {
            ArrayList<GenericStack> newStackList = new ArrayList<GenericStack>();
            for (GenericStack stack : stackList) {
                AEKey key = stack.what();
                if (controllerKey != key) {
                    newStackList.add(stack);
                    continue;
                }
                if (controllerKept) continue;
                newStackList.add(new GenericStack(key, 1L));
                controllerKept = true;
            }
            if (newStackList.isEmpty()) continue;
            filteredList.add(newStackList);
        }
        return filteredList;
    }

    private static Stream<List<GenericStack>> getProcessedLayerInputs(MultiblockInfoEmiRecipe recipe, int layerIndex) {
        return recipe.getInputs(layerIndex).stream().map(emiStack -> {
            ItemEmiStack itemStack;
            Object patt0$temp;
            if (emiStack instanceof ItemEmiStack && (patt0$temp = (itemStack = (ItemEmiStack)emiStack).getKey()) instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)patt0$temp;
                return EmiStack.of((Fluid)bucketItem.getFluid(), (long)(emiStack.getAmount() * 1000L));
            }
            return emiStack;
        }).filter(GTEmiEncodingHelper::isNotHatch).map(GTEmiEncodingHelper::intoGenericStack);
    }

    private static boolean isNotHatch(EmiIngredient ingredient) {
        if (ingredient instanceof EmiStack) {
            MetaMachineItem meta;
            EmiStack stack = (EmiStack)ingredient;
            Object object = stack.getKey();
            return !(object instanceof MetaMachineItem) || !Hatch.Set.contains((meta = (MetaMachineItem)object).m_40614_());
        }
        return false;
    }
}

